/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.TypeUtils;

public final class ComplexFunction
extends FunctionSet<ComplexNumber> {
    public static final UnaryFunction<ComplexNumber> ABS = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            return ComplexNumber.valueOf(arg.norm());
        }
    };
    public static final UnaryFunction<ComplexNumber> ACOS = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            ComplexNumber tmpSqrt = SQRT.invoke(ComplexNumber.ONE.subtract(arg.multiply(arg)));
            ComplexNumber tmpNmbr = arg.add(ComplexNumber.I.multiply(tmpSqrt));
            ComplexNumber tmpLog = LOG.invoke(tmpNmbr);
            return tmpLog.multiply(ComplexNumber.I).negate();
        }
    };
    public static final UnaryFunction<ComplexNumber> ACOSH = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            return LOG.invoke(arg.add(SQRT.invoke(arg.multiply(arg).subtract(PrimitiveMath.ONE))));
        }
    };
    public static final BinaryFunction<ComplexNumber> ADD = new Binary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg1, ComplexNumber arg2) {
            return arg1.add(arg2);
        }
    };
    public static final UnaryFunction<ComplexNumber> ASIN = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            ComplexNumber tmpNmbr = SQRT.invoke(ComplexNumber.ONE.subtract(POWER.invoke(arg, 2)));
            ComplexNumber aNumber = tmpNmbr = ComplexNumber.I.multiply(arg).add(tmpNmbr);
            return LOG.invoke(aNumber).multiply(ComplexNumber.I).negate();
        }
    };
    public static final UnaryFunction<ComplexNumber> ASINH = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            ComplexNumber tmpNmbr = arg.multiply(arg).add(PrimitiveMath.ONE);
            return LOG.invoke(arg.add(SQRT.invoke(tmpNmbr)));
        }
    };
    public static final UnaryFunction<ComplexNumber> ATAN = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            ComplexNumber tmpNmbr = ComplexNumber.I.add(arg).divide(ComplexNumber.I.subtract(arg));
            return LOG.invoke(tmpNmbr).multiply(ComplexNumber.I).divide(PrimitiveMath.TWO);
        }
    };
    public static final UnaryFunction<ComplexNumber> ATANH = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            ComplexNumber tmpNmbr = arg.add(PrimitiveMath.ONE).divide(ComplexNumber.ONE.subtract(arg));
            return LOG.invoke(tmpNmbr).divide(PrimitiveMath.TWO);
        }
    };
    public static final UnaryFunction<ComplexNumber> CARDINALITY = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            return TypeUtils.isZero(arg.norm()) ? ComplexNumber.ZERO : ComplexNumber.ONE;
        }
    };
    public static final UnaryFunction<ComplexNumber> CONJUGATE = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            return arg.conjugate();
        }
    };
    public static final UnaryFunction<ComplexNumber> COS = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            return COSH.invoke(arg.multiply(ComplexNumber.I));
        }
    };
    public static final UnaryFunction<ComplexNumber> COSH = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            return EXP.invoke(arg).add(EXP.invoke(arg.negate())).divide(PrimitiveMath.TWO);
        }
    };
    public static final BinaryFunction<ComplexNumber> DIVIDE = new Binary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg1, ComplexNumber arg2) {
            return arg1.divide(arg2);
        }
    };
    public static final UnaryFunction<ComplexNumber> EXP = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            double tmpNorm = Math.exp(arg.doubleValue());
            double tmpPhase = arg.i;
            return ComplexNumber.makePolar(tmpNorm, tmpPhase);
        }
    };
    public static final UnaryFunction<ComplexNumber> EXPM1 = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            double retMod = Math.expm1(arg.doubleValue());
            double retArg = arg.i;
            return ComplexNumber.makePolar(retMod, retArg);
        }
    };
    public static final BinaryFunction<ComplexNumber> HYPOT = new Binary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg1, ComplexNumber arg2) {
            return ComplexNumber.valueOf(Math.hypot(arg1.norm(), arg2.norm()));
        }
    };
    public static final UnaryFunction<ComplexNumber> INVERT = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            return POWER.invoke(arg, -1);
        }
    };
    public static final UnaryFunction<ComplexNumber> LOG = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            double tmpRe = Math.log(arg.norm());
            double tmpIm = arg.phase();
            return ComplexNumber.of(tmpRe, tmpIm);
        }
    };
    public static final UnaryFunction<ComplexNumber> LOG10 = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            double retRe = Math.log10(arg.norm());
            double retIm = arg.phase();
            return ComplexNumber.of(retRe, retIm);
        }
    };
    public static final UnaryFunction<ComplexNumber> LOG1P = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            double retRe = Math.log1p(arg.norm());
            double retIm = arg.phase();
            return ComplexNumber.of(retRe, retIm);
        }
    };
    public static final BinaryFunction<ComplexNumber> MAX = new Binary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg1, ComplexNumber arg2) {
            ComplexNumber retVal = null;
            retVal = arg1.norm() >= arg2.norm() ? arg1 : arg2;
            return retVal;
        }
    };
    public static final BinaryFunction<ComplexNumber> MIN = new Binary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg1, ComplexNumber arg2) {
            ComplexNumber retVal = null;
            retVal = arg1.norm() <= arg2.norm() ? arg1 : arg2;
            return retVal;
        }
    };
    public static final BinaryFunction<ComplexNumber> MULTIPLY = new Binary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg1, ComplexNumber arg2) {
            return arg1.multiply(arg2);
        }
    };
    public static final UnaryFunction<ComplexNumber> NEGATE = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            return arg.negate();
        }
    };
    public static final BinaryFunction<ComplexNumber> POW = new Binary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg1, ComplexNumber arg2) {
            return EXP.invoke(LOG.invoke(arg1).multiply(arg2));
        }
    };
    public static final ParameterFunction<ComplexNumber> POWER = new Parameter(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg, int param) {
            double retMod = PrimitiveFunction.POWER.invoke(arg.norm(), param);
            double retArg = arg.phase() * (double)param;
            return ComplexNumber.makePolar(retMod, retArg);
        }
    };
    public static final ParameterFunction<ComplexNumber> ROOT = new Parameter(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg, int param) {
            if (param != 0) {
                double tmpExp = PrimitiveMath.ONE / (double)param;
                double retMod = Math.pow(arg.norm(), tmpExp);
                double retArg = arg.phase() * tmpExp;
                return ComplexNumber.makePolar(retMod, retArg);
            }
            throw new IllegalArgumentException();
        }
    };
    public static final ParameterFunction<ComplexNumber> SCALE = new Parameter(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg, int param) {
            double tmpRe = PrimitiveFunction.SCALE.invoke(arg.doubleValue(), param);
            double tmpIm = PrimitiveFunction.SCALE.invoke(arg.i, param);
            return ComplexNumber.of(tmpRe, tmpIm);
        }
    };
    public static final UnaryFunction<ComplexNumber> SIGNUM = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            return arg.signum();
        }
    };
    public static final UnaryFunction<ComplexNumber> SIN = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            return SINH.invoke(arg.multiply(ComplexNumber.I)).multiply(ComplexNumber.I.negate());
        }
    };
    public static final UnaryFunction<ComplexNumber> SINH = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            return EXP.invoke(arg).subtract(EXP.invoke(arg.negate())).divide(PrimitiveMath.TWO);
        }
    };
    public static final UnaryFunction<ComplexNumber> SQRT = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            double retMod = Math.sqrt(arg.norm());
            double retArg = arg.phase() * PrimitiveMath.HALF;
            return ComplexNumber.makePolar(retMod, retArg);
        }
    };
    public static final UnaryFunction<ComplexNumber> SQRT1PX2 = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            return SQRT.invoke(ComplexNumber.ONE.add(arg.multiply(arg)));
        }
    };
    public static final BinaryFunction<ComplexNumber> SUBTRACT = new Binary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg1, ComplexNumber arg2) {
            return arg1.subtract(arg2);
        }
    };
    public static final UnaryFunction<ComplexNumber> TAN = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            return TANH.invoke(arg.multiply(ComplexNumber.I)).multiply(ComplexNumber.I.negate());
        }
    };
    public static final UnaryFunction<ComplexNumber> TANH = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            ComplexNumber tmpDivisor;
            ComplexNumber tmpMinus;
            ComplexNumber tmpPlus = EXP.invoke(arg);
            ComplexNumber tmpDividend = tmpPlus.subtract(tmpMinus = EXP.invoke(arg.negate()));
            ComplexNumber retVal = tmpDividend.equals(tmpDivisor = tmpPlus.add(tmpMinus)) ? ComplexNumber.ONE : (tmpDividend.equals(tmpDivisor.negate()) ? ComplexNumber.ONE.negate() : tmpDividend.divide(tmpDivisor));
            return retVal;
        }
    };
    public static final UnaryFunction<ComplexNumber> VALUE = new Unary(){

        @Override
        public final ComplexNumber invoke(ComplexNumber arg) {
            return arg;
        }
    };
    private static final ComplexFunction SET = new ComplexFunction();

    public static ComplexFunction getSet() {
        return SET;
    }

    private ComplexFunction() {
    }

    @Override
    public UnaryFunction<ComplexNumber> abs() {
        return ABS;
    }

    @Override
    public UnaryFunction<ComplexNumber> acos() {
        return ACOS;
    }

    @Override
    public UnaryFunction<ComplexNumber> acosh() {
        return ACOSH;
    }

    @Override
    public BinaryFunction<ComplexNumber> add() {
        return ADD;
    }

    @Override
    public UnaryFunction<ComplexNumber> asin() {
        return ASIN;
    }

    @Override
    public UnaryFunction<ComplexNumber> asinh() {
        return ASINH;
    }

    @Override
    public UnaryFunction<ComplexNumber> atan() {
        return ATAN;
    }

    @Override
    public UnaryFunction<ComplexNumber> atanh() {
        return ATANH;
    }

    @Override
    public UnaryFunction<ComplexNumber> cardinality() {
        return CARDINALITY;
    }

    @Override
    public UnaryFunction<ComplexNumber> conjugate() {
        return CONJUGATE;
    }

    @Override
    public UnaryFunction<ComplexNumber> cos() {
        return COS;
    }

    @Override
    public UnaryFunction<ComplexNumber> cosh() {
        return COSH;
    }

    @Override
    public BinaryFunction<ComplexNumber> divide() {
        return DIVIDE;
    }

    @Override
    public UnaryFunction<ComplexNumber> exp() {
        return EXP;
    }

    @Override
    public UnaryFunction<ComplexNumber> expm1() {
        return EXPM1;
    }

    @Override
    public BinaryFunction<ComplexNumber> hypot() {
        return HYPOT;
    }

    @Override
    public UnaryFunction<ComplexNumber> invert() {
        return INVERT;
    }

    @Override
    public UnaryFunction<ComplexNumber> log() {
        return LOG;
    }

    @Override
    public UnaryFunction<ComplexNumber> log10() {
        return LOG10;
    }

    @Override
    public UnaryFunction<ComplexNumber> log1p() {
        return LOG1P;
    }

    @Override
    public BinaryFunction<ComplexNumber> max() {
        return MAX;
    }

    @Override
    public BinaryFunction<ComplexNumber> min() {
        return MIN;
    }

    @Override
    public BinaryFunction<ComplexNumber> multiply() {
        return MULTIPLY;
    }

    @Override
    public UnaryFunction<ComplexNumber> negate() {
        return NEGATE;
    }

    @Override
    public BinaryFunction<ComplexNumber> pow() {
        return POW;
    }

    @Override
    public ParameterFunction<ComplexNumber> power() {
        return POWER;
    }

    @Override
    public ParameterFunction<ComplexNumber> root() {
        return ROOT;
    }

    @Override
    public ParameterFunction<ComplexNumber> scale() {
        return SCALE;
    }

    @Override
    public UnaryFunction<ComplexNumber> signum() {
        return SIGNUM;
    }

    @Override
    public UnaryFunction<ComplexNumber> sin() {
        return SIN;
    }

    @Override
    public UnaryFunction<ComplexNumber> sinh() {
        return SINH;
    }

    @Override
    public UnaryFunction<ComplexNumber> sqrt() {
        return SQRT;
    }

    @Override
    public UnaryFunction<ComplexNumber> sqrt1px2() {
        return SQRT1PX2;
    }

    @Override
    public BinaryFunction<ComplexNumber> subtract() {
        return SUBTRACT;
    }

    @Override
    public UnaryFunction<ComplexNumber> tan() {
        return TAN;
    }

    @Override
    public UnaryFunction<ComplexNumber> tanh() {
        return TANH;
    }

    @Override
    public UnaryFunction<ComplexNumber> value() {
        return VALUE;
    }

    @FunctionalInterface
    public static interface Unary
    extends UnaryFunction<ComplexNumber> {
        @Override
        default public double invoke(double arg) {
            return this.invoke(ComplexNumber.valueOf(arg)).doubleValue();
        }
    }

    @FunctionalInterface
    public static interface Parameter
    extends ParameterFunction<ComplexNumber> {
        @Override
        default public double invoke(double arg, int param) {
            return this.invoke(ComplexNumber.valueOf(arg), param).doubleValue();
        }
    }

    @FunctionalInterface
    public static interface Binary
    extends BinaryFunction<ComplexNumber> {
        @Override
        default public double invoke(double arg1, double arg2) {
            return this.invoke(ComplexNumber.valueOf(arg1), ComplexNumber.valueOf(arg2)).doubleValue();
        }
    }
}

