/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance.portfolio;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.ojalgo.access.Access2D;
import org.ojalgo.finance.portfolio.FinancePortfolio;
import org.ojalgo.finance.portfolio.MarketEquilibrium;
import org.ojalgo.finance.portfolio.SimpleAsset;
import org.ojalgo.finance.portfolio.simulator.PortfolioSimulator;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.random.process.GeometricBrownianMotion;

public final class SimplePortfolio
extends FinancePortfolio
implements FinancePortfolio.Context {
    private transient BasicMatrix myAssetReturns = null;
    private transient BasicMatrix myAssetVolatilities = null;
    private transient BasicMatrix myAssetWeights = null;
    private final List<SimpleAsset> myComponents;
    private final BasicMatrix myCorrelations;
    private transient BasicMatrix myCovariances = null;
    private transient Number myMeanReturn;
    private transient Number myReturnVariance;
    private transient List<BigDecimal> myWeights;

    static List<SimpleAsset> toSimpleAssets(Number[] someWeights) {
        ArrayList<SimpleAsset> retVal = new ArrayList<SimpleAsset>(someWeights.length);
        for (int i = 0; i < someWeights.length; ++i) {
            retVal.add(new SimpleAsset(someWeights[i]));
        }
        return retVal;
    }

    public SimplePortfolio(Access2D<?> correlationsMatrix, List<SimpleAsset> someAssets) {
        if ((long)someAssets.size() != correlationsMatrix.countRows() || (long)someAssets.size() != correlationsMatrix.countColumns()) {
            throw new IllegalArgumentException("Input dimensions don't match!");
        }
        this.myCorrelations = (BasicMatrix)MATRIX_FACTORY.copy(correlationsMatrix);
        this.myComponents = someAssets;
    }

    public SimplePortfolio(FinancePortfolio.Context aContext, FinancePortfolio weightsPortfolio) {
        this.myCorrelations = aContext.getCorrelations();
        BasicMatrix tmpCovariances = aContext.getCovariances();
        BasicMatrix tmpAssetReturns = aContext.getAssetReturns();
        List<BigDecimal> tmpWeights = weightsPortfolio.getWeights();
        if ((long)tmpWeights.size() != this.myCorrelations.countRows() || (long)tmpWeights.size() != this.myCorrelations.countColumns()) {
            throw new IllegalArgumentException("Input dimensions don't match!");
        }
        this.myComponents = new ArrayList<SimpleAsset>(tmpWeights.size());
        for (int i = 0; i < tmpWeights.size(); ++i) {
            double tmpMeanReturn = tmpAssetReturns.doubleValue(i, 0L);
            double tmpVolatilty = Math.sqrt(tmpCovariances.doubleValue(i, i));
            BigDecimal tmpWeight = tmpWeights.get(i);
            this.myComponents.add(new SimpleAsset(tmpMeanReturn, tmpVolatilty, tmpWeight));
        }
    }

    public SimplePortfolio(List<SimpleAsset> someAssets) {
        this((Access2D<?>)MATRIX_FACTORY.makeEye(someAssets.size(), someAssets.size()), someAssets);
    }

    public SimplePortfolio(Number ... someWeights) {
        this(SimplePortfolio.toSimpleAssets(someWeights));
    }

    private SimplePortfolio() {
        this((BasicMatrix)null, null);
    }

    @Override
    public double calculatePortfolioReturn(FinancePortfolio weightsPortfolio) {
        List<BigDecimal> tmpWeights = weightsPortfolio.getWeights();
        BasicMatrix tmpAssetWeights = (BasicMatrix)MATRIX_FACTORY.columns(tmpWeights);
        BasicMatrix tmpAssetReturns = this.getAssetReturns();
        return MarketEquilibrium.calculatePortfolioReturn(tmpAssetWeights, tmpAssetReturns).doubleValue();
    }

    @Override
    public double calculatePortfolioVariance(FinancePortfolio weightsPortfolio) {
        List<BigDecimal> tmpWeights = weightsPortfolio.getWeights();
        BasicMatrix tmpAssetWeights = (BasicMatrix)MATRIX_FACTORY.columns(tmpWeights);
        return new MarketEquilibrium(this.getCovariances()).calculatePortfolioVariance(tmpAssetWeights).doubleValue();
    }

    @Override
    public BasicMatrix getAssetReturns() {
        if (this.myAssetReturns == null) {
            int tmpSize = this.myComponents.size();
            Access2D.Builder tmpReturns = MATRIX_FACTORY.getBuilder(tmpSize, 1);
            for (int i = 0; i < tmpSize; ++i) {
                tmpReturns.set((long)i, 0L, this.getMeanReturn(i));
            }
            this.myAssetReturns = (BasicMatrix)tmpReturns.build();
        }
        return this.myAssetReturns;
    }

    @Override
    public BasicMatrix getAssetVolatilities() {
        if (this.myAssetVolatilities == null) {
            int tmpSize = this.myComponents.size();
            Access2D.Builder tmpVolatilities = MATRIX_FACTORY.getBuilder(tmpSize, 1);
            for (int i = 0; i < tmpSize; ++i) {
                tmpVolatilities.set((long)i, 0L, this.getVolatility(i));
            }
            this.myAssetVolatilities = (BasicMatrix)tmpVolatilities.build();
        }
        return this.myAssetVolatilities;
    }

    public double getCorrelation(int aRow, int aCol) {
        return this.myCorrelations.doubleValue(aRow, aCol);
    }

    @Override
    public BasicMatrix getCorrelations() {
        return this.myCorrelations;
    }

    public double getCovariance(int aRow, int aCol) {
        BasicMatrix tmpCovariances = this.myCovariances;
        if (tmpCovariances != null) {
            return tmpCovariances.doubleValue(aRow, aCol);
        }
        double tmpRowRisk = this.getVolatility(aRow);
        double tmpColRisk = this.getVolatility(aCol);
        double tmpCorrelation = this.getCorrelation(aRow, aCol);
        return tmpRowRisk * tmpCorrelation * tmpColRisk;
    }

    @Override
    public BasicMatrix getCovariances() {
        if (this.myCovariances == null) {
            int tmpSize = this.myComponents.size();
            Access2D.Builder tmpCovaris = MATRIX_FACTORY.getBuilder(tmpSize, tmpSize);
            for (int j = 0; j < tmpSize; ++j) {
                for (int i = 0; i < tmpSize; ++i) {
                    tmpCovaris.set((long)i, (long)j, this.getCovariance(i, j));
                }
            }
            this.myCovariances = (BasicMatrix)tmpCovaris.build();
        }
        return this.myCovariances;
    }

    @Override
    public double getMeanReturn() {
        if (this.myMeanReturn == null) {
            BasicMatrix tmpWeightsVector = this.getAssetWeights();
            BasicMatrix tmpReturnsVector = this.getAssetReturns();
            this.myMeanReturn = MarketEquilibrium.calculatePortfolioReturn(tmpWeightsVector, tmpReturnsVector).getNumber();
        }
        return this.myMeanReturn.doubleValue();
    }

    public double getMeanReturn(int index) {
        return this.myComponents.get(index).getMeanReturn();
    }

    @Override
    public double getReturnVariance() {
        if (this.myReturnVariance == null) {
            MarketEquilibrium tmpMarketEquilibrium = new MarketEquilibrium(this.getCovariances());
            BasicMatrix tmpWeightsVector = this.getAssetWeights();
            this.myReturnVariance = tmpMarketEquilibrium.calculatePortfolioVariance(tmpWeightsVector).getNumber();
        }
        return this.myReturnVariance.doubleValue();
    }

    public double getReturnVariance(int index) {
        return this.myComponents.get(index).getReturnVariance();
    }

    public PortfolioSimulator getSimulator() {
        ArrayList<GeometricBrownianMotion> tmpAssetProcesses = new ArrayList<GeometricBrownianMotion>(this.myComponents.size());
        for (SimpleAsset tmpAsset : this.myComponents) {
            GeometricBrownianMotion tmpForecast = tmpAsset.forecast();
            tmpForecast.setValue(tmpAsset.getWeight().doubleValue());
            tmpAssetProcesses.add(tmpForecast);
        }
        return new PortfolioSimulator(this.myCorrelations.toPrimitiveStore(), tmpAssetProcesses);
    }

    public double getVolatility(int index) {
        return this.myComponents.get(index).getVolatility();
    }

    public BigDecimal getWeight(int index) {
        return this.myComponents.get(index).getWeight();
    }

    @Override
    public List<BigDecimal> getWeights() {
        if (this.myWeights == null) {
            this.myWeights = new ArrayList<BigDecimal>(this.myComponents.size());
            for (SimpleAsset tmpAsset : this.myComponents) {
                this.myWeights.add(tmpAsset.getWeight());
            }
        }
        return this.myWeights;
    }

    @Override
    public int size() {
        return this.myComponents.size();
    }

    @Override
    protected void reset() {
        this.myMeanReturn = null;
        this.myReturnVariance = null;
        this.myWeights = null;
        this.myCovariances = null;
        this.myAssetReturns = null;
        this.myAssetVolatilities = null;
        this.myAssetWeights = null;
        for (SimpleAsset tmpAsset : this.myComponents) {
            tmpAsset.reset();
        }
    }

    BasicMatrix getAssetWeights() {
        if (this.myAssetWeights == null) {
            int tmpSize = this.myComponents.size();
            Access2D.Builder tmpWeights = MATRIX_FACTORY.getBuilder(tmpSize, 1);
            for (int i = 0; i < tmpSize; ++i) {
                tmpWeights.set((long)i, 0L, this.getWeight(i));
            }
            this.myAssetWeights = (BasicMatrix)tmpWeights.build();
        }
        return this.myAssetWeights;
    }
}

