/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance.data;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.ojalgo.finance.data.DataSource;
import org.ojalgo.finance.data.DatePrice;
import org.ojalgo.type.CalendarDateUnit;
import org.ojalgo.type.context.GenericContext;

public class GoogleSymbol
extends DataSource<Data> {
    private static final String CSV = "csv";
    private static final String DAILY = "daily";
    private static final GenericContext<Date> DATE_FORMAT = new GenericContext(new SimpleDateFormat("dd-MMM-yy", Locale.US));
    private static final String FINANCE_GOOGLE_COM = "finance.google.com";
    private static final String FINANCE_HISTORICAL = "/finance/historical";
    private static final String HISTPERIOD = "histperiod";
    private static final String JAN_2_1970 = "Jan+2,+1970";
    private static final String OUTPUT = "output";
    private static final String Q = "q";
    private static final String STARTDATE = "startdate";
    private static final String WEEKLY = "weekly";

    public GoogleSymbol(String aSymbol) {
        this(aSymbol, CalendarDateUnit.DAY);
    }

    public GoogleSymbol(String aSymbol, CalendarDateUnit aResolution) {
        super(aSymbol, aResolution);
        this.setHost(FINANCE_GOOGLE_COM);
        this.setPath(FINANCE_HISTORICAL);
        this.addQueryParameter(Q, aSymbol);
        this.addQueryParameter(STARTDATE, JAN_2_1970);
        switch (aResolution) {
            case WEEK: {
                this.addQueryParameter(HISTPERIOD, WEEKLY);
                break;
            }
            default: {
                this.addQueryParameter(HISTPERIOD, DAILY);
            }
        }
        this.addQueryParameter(OUTPUT, CSV);
    }

    @Override
    protected Data parse(String aLine) {
        Data retVal = null;
        int tmpInclusiveBegin = 0;
        int tmpExclusiveEnd = aLine.indexOf(44, tmpInclusiveBegin);
        String tmpString = aLine.substring(tmpInclusiveBegin, tmpExclusiveEnd);
        GregorianCalendar tmpCalendar = new GregorianCalendar();
        tmpCalendar.setTime((Date)DATE_FORMAT.parse(tmpString));
        this.getResolution().round(tmpCalendar);
        retVal = new Data(tmpCalendar);
        tmpInclusiveBegin = tmpExclusiveEnd + 1;
        tmpExclusiveEnd = aLine.indexOf(44, tmpInclusiveBegin);
        tmpString = aLine.substring(tmpInclusiveBegin, tmpExclusiveEnd);
        try {
            retVal.open = Double.parseDouble(tmpString);
        }
        catch (NumberFormatException ex) {
            retVal.open = Double.NaN;
        }
        tmpInclusiveBegin = tmpExclusiveEnd + 1;
        tmpExclusiveEnd = aLine.indexOf(44, tmpInclusiveBegin);
        tmpString = aLine.substring(tmpInclusiveBegin, tmpExclusiveEnd);
        try {
            retVal.high = Double.parseDouble(tmpString);
        }
        catch (NumberFormatException ex) {
            retVal.high = Double.NaN;
        }
        tmpInclusiveBegin = tmpExclusiveEnd + 1;
        tmpExclusiveEnd = aLine.indexOf(44, tmpInclusiveBegin);
        tmpString = aLine.substring(tmpInclusiveBegin, tmpExclusiveEnd);
        try {
            retVal.low = Double.parseDouble(tmpString);
        }
        catch (NumberFormatException ex) {
            retVal.low = Double.NaN;
        }
        tmpInclusiveBegin = tmpExclusiveEnd + 1;
        tmpExclusiveEnd = aLine.indexOf(44, tmpInclusiveBegin);
        tmpString = aLine.substring(tmpInclusiveBegin, tmpExclusiveEnd);
        try {
            retVal.close = Double.parseDouble(tmpString);
        }
        catch (NumberFormatException ex) {
            retVal.close = Double.NaN;
        }
        tmpInclusiveBegin = tmpExclusiveEnd + 1;
        tmpString = aLine.substring(tmpInclusiveBegin);
        try {
            retVal.volume = Double.parseDouble(tmpString);
        }
        catch (NumberFormatException ex) {
            retVal.volume = Double.NaN;
        }
        return retVal;
    }

    public static final class Data
    extends DatePrice {
        public double close;
        public double high;
        public double low;
        public double open;
        public double volume;

        protected Data(Calendar aDate) {
            super(aDate);
        }

        @Override
        public double getPrice() {
            return this.close;
        }
    }
}

