/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.finance.data.DatePrice;
import org.ojalgo.netio.ResourceLocator;
import org.ojalgo.series.CalendarDateSeries;
import org.ojalgo.type.CalendarDateUnit;
import org.ojalgo.type.Colour;
import org.ojalgo.type.TypeCache;

public abstract class DataSource<DP extends DatePrice> {
    protected static final boolean DEBUG = false;
    private final CalendarDateUnit myResolution;
    private final ResourceLocator myResourceLocator = new ResourceLocator();
    private final String mySymbol;

    private DataSource() {
        this(null, null);
        ProgrammingError.throwForIllegalInvocation();
    }

    protected DataSource(String aSymbol, CalendarDateUnit aResolution) {
        this.mySymbol = aSymbol;
        this.myResolution = aResolution;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSource)) {
            return false;
        }
        DataSource other = (DataSource)obj;
        if (this.myResolution != other.myResolution) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        return !(this.mySymbol == null ? other.mySymbol != null : !this.mySymbol.equals(other.mySymbol));
    }

    public List<DP> getHistoricalPrices() {
        return this.getHistoricalPrices(this.myResourceLocator.getStreamReader());
    }

    public List<DP> getHistoricalPrices(BufferedReader aReader) {
        ArrayList<DP> retVal = new ArrayList<DP>();
        try {
            String tmpLine = aReader.readLine();
            while ((tmpLine = aReader.readLine()) != null) {
                DP tmpHistPrice = this.parse(tmpLine);
                retVal.add(tmpHistPrice);
            }
            aReader.close();
        }
        catch (IOException anException) {
            anException.printStackTrace();
        }
        Collections.sort(retVal);
        return retVal;
    }

    public CalendarDateSeries<Double> getPriceSeries() {
        return this.getPriceSeries(this.myResourceLocator.getStreamReader());
    }

    public CalendarDateSeries<Double> getPriceSeries(BufferedReader aReader) {
        CalendarDateSeries retVal = (CalendarDateSeries)((CalendarDateSeries)new CalendarDateSeries(this.myResolution).name(this.mySymbol)).colour(Colour.random());
        for (DatePrice tmpDatePrice : this.getHistoricalPrices(aReader)) {
            retVal.put(tmpDatePrice.getKey(), tmpDatePrice.getValue());
        }
        return retVal;
    }

    public CalendarDateUnit getResolution() {
        return this.myResolution;
    }

    public String getSymbol() {
        return this.mySymbol;
    }

    public TypeCache<? extends List<DP>> getSymbolCache(long aPurgeIntervalMeassure, CalendarDateUnit aPurgeIntervalUnit) {
        return new TypeCache<List<DP>>(aPurgeIntervalMeassure, aPurgeIntervalUnit){

            @Override
            protected List<DP> recreateCache() {
                return DataSource.this.getHistoricalPrices();
            }
        };
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myResolution == null ? 0 : this.myResolution.hashCode());
        result = 31 * result + (this.mySymbol == null ? 0 : this.mySymbol.hashCode());
        return result;
    }

    protected String addQueryParameter(String aKey, String aValue) {
        return this.myResourceLocator.addQueryParameter(aKey, aValue);
    }

    protected abstract DP parse(String var1);

    protected void setHost(String aHost) {
        this.myResourceLocator.setHost(aHost);
    }

    protected void setPath(String aPath) {
        this.myResourceLocator.setPath(aPath);
    }
}

