/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.ArrayUtils;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.PrimitiveMatrix;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.random.Deterministic;
import org.ojalgo.random.RandomNumber;
import org.ojalgo.random.RandomUtils;
import org.ojalgo.random.SampleSet;
import org.ojalgo.random.process.GeometricBrownianMotion;
import org.ojalgo.series.CalendarDateSeries;
import org.ojalgo.series.CoordinationSet;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.CalendarDateUnit;

public abstract class FinanceUtils {
    public static double calculateValueAtRisk(double aReturn, double aStdDev, double aConfidence, double aTime) {
        double tmpConfidenceScale = PrimitiveMath.SQRT_TWO * RandomUtils.erfi(PrimitiveMath.ONE - PrimitiveMath.TWO * (PrimitiveMath.ONE - aConfidence));
        return Math.max(Math.sqrt(aTime) * aStdDev * tmpConfidenceScale - aTime * aReturn, PrimitiveMath.ZERO);
    }

    public static GeometricBrownianMotion estimateExcessDiffusionProcess(CalendarDateSeries<?> aPriceSeries, CalendarDateSeries<?> aRiskFreeInterestRateSeries, CalendarDateUnit aTimeUnit) {
        SampleSet tmpSampleSet = FinanceUtils.makeExcessGrowthRateSampleSet(aPriceSeries, aRiskFreeInterestRateSeries);
        double tmpStepSize = aPriceSeries.getResolution().size();
        double tmpExp = tmpSampleSet.getMean();
        double tmpVar = tmpSampleSet.getVariance();
        double tmpDiff = Math.sqrt(tmpVar / (tmpStepSize /= (double)aTimeUnit.size()));
        double tmpDrift = tmpExp / tmpStepSize + tmpDiff * tmpDiff / PrimitiveMath.TWO;
        GeometricBrownianMotion retVal = new GeometricBrownianMotion(tmpDrift, tmpDiff);
        return retVal;
    }

    public static CalendarDateSeries<RandomNumber> forecast(CalendarDateSeries<? extends Number> aSeries, int aPointCount, CalendarDateUnit aTimeUnit, boolean includeOriginalSeries) {
        CalendarDateSeries<RandomNumber> retVal = new CalendarDateSeries<RandomNumber>(aTimeUnit);
        ((CalendarDateSeries)retVal.name(aSeries.getName())).colour(aSeries.getColour());
        double tmpSamplePeriod = (double)aSeries.getAverageStepSize() / (double)aTimeUnit.size();
        GeometricBrownianMotion tmpProcess = GeometricBrownianMotion.estimate(aSeries.getDataSeries(), tmpSamplePeriod);
        if (includeOriginalSeries) {
            for (Map.Entry tmpEntry : aSeries.entrySet()) {
                retVal.put((CalendarDate)tmpEntry.getKey(), (RandomNumber)new Deterministic((Number)tmpEntry.getValue()));
            }
        }
        CalendarDate tmpLastKey = (CalendarDate)aSeries.lastKey();
        double tmpLastValue = aSeries.lastValue().doubleValue();
        tmpProcess.setValue(tmpLastValue);
        for (int i = 1; i <= aPointCount; ++i) {
            retVal.put(tmpLastKey.millis + (long)i * aTimeUnit.size(), (RandomNumber)tmpProcess.getDistribution(i));
        }
        return retVal;
    }

    public static CalendarDateSeries<BigDecimal> makeCalendarPriceSeries(double[] somePrices, Calendar aStartCalendar, CalendarDateUnit aResolution) {
        CalendarDateSeries<BigDecimal> retVal = new CalendarDateSeries<BigDecimal>(aResolution);
        FinanceUtils.copyValues(retVal, new CalendarDate(aStartCalendar), somePrices);
        return retVal;
    }

    public static <V extends Number> BasicMatrix makeCovarianceMatrix(Collection<CalendarDateSeries<V>> timeSeriesCollection) {
        CoordinationSet<V> tmpCoordinator = new CoordinationSet<V>(timeSeriesCollection).prune();
        ArrayList<SampleSet> tmpSampleSets = new ArrayList<SampleSet>();
        for (CalendarDateSeries<V> tmpTimeSeries : timeSeriesCollection) {
            double[] someValues = tmpCoordinator.get(tmpTimeSeries.getName()).getPrimitiveValues();
            int tmpSize1 = someValues.length - 1;
            double[] retVal = new double[tmpSize1];
            for (int i = 0; i < tmpSize1; ++i) {
                retVal[i] = Math.log(someValues[i + 1] / someValues[i]);
            }
            SampleSet tmpMakeUsingLogarithmicChanges = SampleSet.wrap(ArrayUtils.wrapAccess1D(retVal));
            tmpSampleSets.add(tmpMakeUsingLogarithmicChanges);
        }
        int tmpSize = timeSeriesCollection.size();
        Access2D.Builder<PrimitiveMatrix> retValStore = PrimitiveMatrix.getBuilder(tmpSize, tmpSize);
        double tmpToYearFactor = (double)CalendarDateUnit.YEAR.size() / (double)tmpCoordinator.getResolution().size();
        for (int j = 0; j < tmpSize; ++j) {
            SampleSet tmpColSet = (SampleSet)tmpSampleSets.get(j);
            for (int i = 0; i < tmpSize; ++i) {
                SampleSet tmpRowSet = (SampleSet)tmpSampleSets.get(i);
                retValStore.set((long)i, (long)j, tmpToYearFactor * tmpRowSet.getCovariance(tmpColSet));
            }
        }
        return (BasicMatrix)retValStore.build();
    }

    public static CalendarDateSeries<BigDecimal> makeDatePriceSeries(double[] somePrices, Date aStartDate, CalendarDateUnit aResolution) {
        CalendarDateSeries<BigDecimal> retVal = new CalendarDateSeries<BigDecimal>(aResolution);
        FinanceUtils.copyValues(retVal, new CalendarDate(aStartDate), somePrices);
        return retVal;
    }

    public static SampleSet makeExcessGrowthRateSampleSet(CalendarDateSeries<?> aPriceSeries, CalendarDateSeries<?> aRiskFreeInterestRateSeries) {
        if (aPriceSeries.size() != aRiskFreeInterestRateSeries.size()) {
            throw new IllegalArgumentException("The two series must have the same size (number of elements).");
        }
        if (!((CalendarDate)aPriceSeries.firstKey()).equals(aRiskFreeInterestRateSeries.firstKey())) {
            throw new IllegalArgumentException("The two series must have the same first key (date or calendar).");
        }
        if (!((CalendarDate)aPriceSeries.lastKey()).equals(aRiskFreeInterestRateSeries.lastKey())) {
            throw new IllegalArgumentException("The two series must have the same last key (date or calendar).");
        }
        double[] tmpPrices = aPriceSeries.getPrimitiveValues();
        double[] tmpRiskFreeInterestRates = aRiskFreeInterestRateSeries.getPrimitiveValues();
        Access1D retVal = Array1D.PRIMITIVE.makeZero(tmpPrices.length - 1);
        CalendarDateUnit tmpUnit = aPriceSeries.getResolution();
        for (int i = 0; i < ((Array1D)retVal).size(); ++i) {
            double tmpThisRiskFree = tmpRiskFreeInterestRates[i] / PrimitiveMath.HUNDRED;
            double tmpNextRiskFree = tmpRiskFreeInterestRates[i + 1] / PrimitiveMath.HUNDRED;
            double tmpAvgRiskFree = (tmpThisRiskFree + tmpNextRiskFree) / PrimitiveMath.TWO;
            double tmpRiskFreeGrowthRate = FinanceUtils.toGrowthRateFromAnnualReturn(tmpAvgRiskFree, tmpUnit);
            double tmpThisPrice = tmpPrices[i];
            double tmpNextPrice = tmpPrices[i + 1];
            double tmpPriceGrowthFactor = tmpNextPrice / tmpThisPrice;
            double tmpPriceGrowthRate = Math.log(tmpPriceGrowthFactor);
            double tmpAdjustedPriceGrowthRate = tmpPriceGrowthRate - tmpRiskFreeGrowthRate;
            ((Array1D)retVal).set((long)i, tmpAdjustedPriceGrowthRate);
        }
        return SampleSet.wrap(retVal);
    }

    public static CalendarDateSeries<Double> makeNormalisedExcessPrice(CalendarDateSeries<?> aPriceSeries, CalendarDateSeries<?> aRiskFreeInterestRateSeries) {
        if (aPriceSeries.size() != aRiskFreeInterestRateSeries.size()) {
            throw new IllegalArgumentException("The two series must have the same size (number of elements).");
        }
        if (!((CalendarDate)aPriceSeries.firstKey()).equals(aRiskFreeInterestRateSeries.firstKey())) {
            throw new IllegalArgumentException("The two series must have the same first key (date or calendar).");
        }
        if (!((CalendarDate)aPriceSeries.lastKey()).equals(aRiskFreeInterestRateSeries.lastKey())) {
            throw new IllegalArgumentException("The two series must have the same last key (date or calendar).");
        }
        long[] tmpDates = aPriceSeries.getPrimitiveKeys();
        double[] tmpPrices = aPriceSeries.getPrimitiveValues();
        double[] tmpRiskFreeInterestRates = aRiskFreeInterestRateSeries.getPrimitiveValues();
        CalendarDateUnit tmpResolution = aPriceSeries.getResolution();
        CalendarDateSeries<Double> retVal = new CalendarDateSeries<Double>(tmpResolution);
        double tmpAggregatedExcessPrice = PrimitiveMath.ONE;
        retVal.put(new CalendarDate(tmpDates[0]), Double.valueOf(tmpAggregatedExcessPrice));
        for (int i = 1; i < aPriceSeries.size(); ++i) {
            double tmpThisRiskFree = tmpRiskFreeInterestRates[i] / PrimitiveMath.HUNDRED;
            double tmpLastRiskFree = tmpRiskFreeInterestRates[i - 1] / PrimitiveMath.HUNDRED;
            double tmpAvgRiskFree = (tmpThisRiskFree + tmpLastRiskFree) / PrimitiveMath.TWO;
            double tmpRiskFreeGrowthFactor = FinanceUtils.toGrowthFactorFromAnnualReturn(tmpAvgRiskFree, tmpResolution);
            double tmpThisPrice = tmpPrices[i];
            double tmpLastPrice = tmpPrices[i - 1];
            double tmpPriceGrowthFactor = tmpThisPrice / tmpLastPrice;
            double tmpAdjustedPriceGrowthFactor = tmpPriceGrowthFactor / tmpRiskFreeGrowthFactor;
            retVal.put(new CalendarDate(tmpDates[i]), Double.valueOf(tmpAggregatedExcessPrice *= tmpAdjustedPriceGrowthFactor));
        }
        return (CalendarDateSeries)((CalendarDateSeries)retVal.name(aPriceSeries.getName())).colour(aPriceSeries.getColour());
    }

    public static double toAnnualReturnFromGrowthFactor(double growthFactor, CalendarDateUnit growthFactorUnit) {
        double tmpGrowthFactorUnitsPerYear = growthFactorUnit.convert(CalendarDateUnit.YEAR);
        return PrimitiveFunction.POW.invoke(growthFactor, tmpGrowthFactorUnitsPerYear) - PrimitiveMath.ONE;
    }

    public static double toAnnualReturnFromGrowthRate(double growthRate, CalendarDateUnit growthRateUnit) {
        double tmpGrowthRateUnitsPerYear = growthRateUnit.convert(CalendarDateUnit.YEAR);
        return PrimitiveFunction.EXPM1.invoke(growthRate * tmpGrowthRateUnitsPerYear);
    }

    public static PrimitiveMatrix toAssetVolatilities(Access2D<?> covariances) {
        int tmpSize = (int)Math.min(covariances.countRows(), covariances.countColumns());
        Access2D.Builder<PrimitiveMatrix> retVal = PrimitiveMatrix.getBuilder(tmpSize);
        for (int ij = 0; ij < tmpSize; ++ij) {
            retVal.set((long)ij, Math.sqrt(covariances.doubleValue(ij, ij)));
        }
        return (PrimitiveMatrix)retVal.build();
    }

    public static PrimitiveMatrix toCorrelations(Access2D<?> covariances, boolean clean) {
        int tmpSize = (int)Math.min(covariances.countRows(), covariances.countColumns());
        MatrixStore<PhysicalStore<Double>> tmpCovariances = MatrixStore.PRIMITIVE.makeWrapper(covariances).get();
        if (clean) {
            Eigenvalue<Double> tmpEvD = Eigenvalue.makePrimitive(true);
            tmpEvD.decompose((ElementsSupplier<Double>)tmpCovariances);
            MatrixStore<Double> tmpV = tmpEvD.getV();
            PhysicalStore<Double> tmpD = tmpEvD.getD().copy();
            double tmpLargest = tmpD.doubleValue(0L, 0L);
            double tmpLimit = Math.max(PrimitiveMath.MACHINE_EPSILON * tmpLargest, 1.0E-12);
            for (int ij = 0; ij < tmpSize; ++ij) {
                if (!(tmpD.doubleValue(ij, ij) < tmpLimit)) continue;
                tmpD.set((long)ij, (long)ij, tmpLimit);
            }
            MatrixStore<Double> tmpLeft = tmpV;
            PhysicalStore<Double> tmpMiddle = tmpD;
            ElementsSupplier tmpRight = tmpLeft.transpose();
            tmpCovariances = tmpLeft.multiply((Double)((Object)tmpMiddle)).multiply((PhysicalStore<Double>)tmpRight);
        }
        Access2D.Builder<PrimitiveMatrix> retVal = PrimitiveMatrix.getBuilder(tmpSize, tmpSize);
        double[] tmpVolatilities = new double[tmpSize];
        for (int ij = 0; ij < tmpSize; ++ij) {
            tmpVolatilities[ij] = Math.sqrt(tmpCovariances.doubleValue(ij, ij));
        }
        for (int j = 0; j < tmpSize; ++j) {
            double tmpColVol = tmpVolatilities[j];
            retVal.set((long)j, (long)j, PrimitiveMath.ONE);
            for (int i = j + 1; i < tmpSize; ++i) {
                double tmpCovariance = tmpCovariances.doubleValue(i, j);
                double tmpCorrelation = tmpCovariance / (tmpVolatilities[i] * tmpColVol);
                retVal.set((long)i, (long)j, tmpCorrelation);
                retVal.set((long)j, (long)i, tmpCorrelation);
            }
        }
        return (PrimitiveMatrix)retVal.build();
    }

    public static PrimitiveMatrix toCovariances(Access1D<?> assetVolatilities, Access2D<?> correlations) {
        int tmpSize = (int)assetVolatilities.count();
        Access2D.Builder<PrimitiveMatrix> retVal = PrimitiveMatrix.getBuilder(tmpSize, tmpSize);
        for (int j = 0; j < tmpSize; ++j) {
            double tmpColumnVolatility = assetVolatilities.doubleValue(j);
            retVal.set((long)j, (long)j, tmpColumnVolatility * tmpColumnVolatility);
            for (int i = j + 1; i < tmpSize; ++i) {
                double tmpCovariance = assetVolatilities.doubleValue(i) * correlations.doubleValue(i, j) * tmpColumnVolatility;
                retVal.set((long)i, (long)j, tmpCovariance);
                retVal.set((long)j, (long)i, tmpCovariance);
            }
        }
        return (PrimitiveMatrix)retVal.build();
    }

    public static double toGrowthFactorFromAnnualReturn(double annualReturn, CalendarDateUnit growthFactorUnit) {
        double tmpAnnualGrowthFactor = PrimitiveMath.ONE + annualReturn;
        double tmpYearsPerGrowthFactorUnit = CalendarDateUnit.YEAR.convert(growthFactorUnit);
        return PrimitiveFunction.POW.invoke(tmpAnnualGrowthFactor, tmpYearsPerGrowthFactorUnit);
    }

    public static double toGrowthRateFromAnnualReturn(double annualReturn, CalendarDateUnit growthRateUnit) {
        double tmpAnnualGrowthRate = PrimitiveFunction.LOG1P.invoke(annualReturn);
        double tmpYearsPerGrowthRateUnit = CalendarDateUnit.YEAR.convert(growthRateUnit);
        return tmpAnnualGrowthRate * tmpYearsPerGrowthRateUnit;
    }

    private static <K extends Comparable<K>> void copyValues(CalendarDateSeries<BigDecimal> aSeries, CalendarDate aFirstKey, double[] someValues) {
        CalendarDate tmpKey = aFirstKey;
        for (int tmpValueIndex = 0; tmpValueIndex < someValues.length; ++tmpValueIndex) {
            aSeries.put(tmpKey, new BigDecimal(someValues[tmpValueIndex]));
            tmpKey = aSeries.step(tmpKey);
        }
    }

    private FinanceUtils() {
    }
}

