/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.math.BigDecimal;
import org.ojalgo.OjAlgoUtils;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.array.ArrayFactory;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.BigArray;
import org.ojalgo.array.ComplexArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PrimitiveArray;
import org.ojalgo.array.QuaternionArray;
import org.ojalgo.array.RationalArray;
import org.ojalgo.array.SparseArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;

public final class SegmentedArray<N extends Number>
extends BasicArray<N> {
    static final SegmentedFactory<BigDecimal> BIG = new SegmentedFactory<BigDecimal>(){

        @Override
        DenseArray.DenseFactory<BigDecimal> getDenseFactory() {
            return BigArray.FACTORY;
        }

        @Override
        SparseArray.SparseFactory<BigDecimal> getSparseFactory() {
            return SparseArray.BIG;
        }
    };
    static final SegmentedFactory<ComplexNumber> COMPLEX = new SegmentedFactory<ComplexNumber>(){

        @Override
        DenseArray.DenseFactory<ComplexNumber> getDenseFactory() {
            return ComplexArray.FACTORY;
        }

        @Override
        SparseArray.SparseFactory<ComplexNumber> getSparseFactory() {
            return SparseArray.COMPLEX;
        }
    };
    static final SegmentedFactory<Double> PRIMITIVE = new SegmentedFactory<Double>(){

        @Override
        DenseArray.DenseFactory<Double> getDenseFactory() {
            return PrimitiveArray.FACTORY;
        }

        @Override
        SparseArray.SparseFactory<Double> getSparseFactory() {
            return SparseArray.PRIMITIVE;
        }
    };
    static final SegmentedFactory<Quaternion> QUATERNION = new SegmentedFactory<Quaternion>(){

        @Override
        DenseArray.DenseFactory<Quaternion> getDenseFactory() {
            return QuaternionArray.FACTORY;
        }

        @Override
        SparseArray.SparseFactory<Quaternion> getSparseFactory() {
            return SparseArray.QUATERNION;
        }
    };
    static final SegmentedFactory<RationalNumber> RATIONAL = new SegmentedFactory<RationalNumber>(){

        @Override
        DenseArray.DenseFactory<RationalNumber> getDenseFactory() {
            return RationalArray.FACTORY;
        }

        @Override
        SparseArray.SparseFactory<RationalNumber> getSparseFactory() {
            return SparseArray.RATIONAL;
        }
    };
    private final int myIndexBits;
    private final long myIndexMask;
    private final BasicArray<N>[] mySegments;
    private final long mySegmentSize;

    public static SegmentedArray<BigDecimal> makeBigDense(long count) {
        return SegmentedArray.make(BasicArray.BIG, count);
    }

    public static SegmentedArray<BigDecimal> makeBigSparse(long count) {
        return SegmentedArray.make(SparseArray.BIG, count);
    }

    public static SegmentedArray<ComplexNumber> makeComplexDense(long count) {
        return SegmentedArray.make(BasicArray.COMPLEX, count);
    }

    public static SegmentedArray<ComplexNumber> makeComplexSparse(long count) {
        return SegmentedArray.make(SparseArray.COMPLEX, count);
    }

    public static SegmentedArray<Double> makePrimitiveDense(long count) {
        return SegmentedArray.make(BasicArray.PRIMITIVE, count);
    }

    public static SegmentedArray<Double> makePrimitiveSparse(long count) {
        return SegmentedArray.make(SparseArray.PRIMITIVE, count);
    }

    public static SegmentedArray<Quaternion> makeQuaternionDense(long count) {
        return SegmentedArray.make(BasicArray.QUATERNION, count);
    }

    public static SegmentedArray<Quaternion> makeQuaternionSparse(long count) {
        return SegmentedArray.make(SparseArray.QUATERNION, count);
    }

    public static SegmentedArray<RationalNumber> makeRationalDense(long count) {
        return SegmentedArray.make(BasicArray.RATIONAL, count);
    }

    public static SegmentedArray<RationalNumber> makeRationalSparse(long count) {
        return SegmentedArray.make(SparseArray.RATIONAL, count);
    }

    static <N extends Number> SegmentedArray<N> make(ArrayFactory<N> segmentFactory, long ... structure) {
        long tmpCount = AccessUtils.count(structure);
        int tmpNumberOfUniformSegments = 1;
        long tmpUniformSegmentSize = tmpCount;
        long tmpMaxNumberOfSegments = (long)Math.min(2.147483646E9, Math.sqrt(tmpCount));
        for (int i = 0; i < structure.length; ++i) {
            long tmpNoS = (long)tmpNumberOfUniformSegments * structure[i];
            long tmpSS = tmpUniformSegmentSize / structure[i];
            if (tmpNoS > tmpMaxNumberOfSegments) continue;
            tmpNumberOfUniformSegments = (int)tmpNoS;
            tmpUniformSegmentSize = tmpSS;
        }
        long tmpCacheDim = OjAlgoUtils.ENVIRONMENT.getCacheDim1D(segmentFactory.getElementSize());
        long tmpUnits = OjAlgoUtils.ENVIRONMENT.units;
        while (tmpUnits != 1L && tmpUniformSegmentSize >= tmpCacheDim && (long)tmpNumberOfUniformSegments * tmpUnits <= tmpMaxNumberOfSegments) {
            tmpNumberOfUniformSegments = (int)((long)tmpNumberOfUniformSegments * tmpUnits);
            tmpUniformSegmentSize /= tmpUnits;
        }
        int tmpShift = (int)(Math.log(tmpUniformSegmentSize) / Math.log(2.0));
        return new SegmentedArray<N>(tmpCount, tmpShift, segmentFactory);
    }

    SegmentedArray(long count, int indexBits, ArrayFactory<N> segmentFactory) {
        long tmpSegmentSize = 1L << indexBits;
        int tmpNumberOfUniformSegments = (int)(count / tmpSegmentSize);
        long tmpRemainder = count % tmpSegmentSize;
        int tmpTotalNumberOfSegments = tmpRemainder == 0L ? tmpNumberOfUniformSegments : tmpNumberOfUniformSegments + 1;
        this.mySegments = new BasicArray[tmpTotalNumberOfSegments];
        for (int s = 0; s < tmpNumberOfUniformSegments; ++s) {
            this.mySegments[s] = segmentFactory.makeZero(tmpSegmentSize);
        }
        if (tmpRemainder != 0L) {
            this.mySegments[tmpNumberOfUniformSegments] = segmentFactory.makeZero(tmpRemainder);
        }
        this.mySegmentSize = tmpSegmentSize;
        this.myIndexBits = indexBits;
        this.myIndexMask = tmpSegmentSize - 1L;
    }

    @Override
    public void add(long index, double addend) {
        this.mySegments[(int)(index >> this.myIndexBits)].add(index & this.myIndexMask, addend);
    }

    @Override
    public void add(long index, Number addend) {
        this.mySegments[(int)(index >> this.myIndexBits)].add(index & this.myIndexMask, addend);
    }

    @Override
    public long count() {
        int tmpVal = this.mySegments.length - 1;
        return this.mySegments[0].count() * (long)tmpVal + this.mySegments[tmpVal].count();
    }

    @Override
    public double doubleValue(long index) {
        return this.mySegments[(int)(index >> this.myIndexBits)].doubleValue(index & this.myIndexMask);
    }

    @Override
    public void fillAll(N value) {
        for (BasicArray<N> tmpSegment : this.mySegments) {
            tmpSegment.fillAll(value);
        }
    }

    @Override
    public void fillAll(NullaryFunction<N> supplier) {
        for (BasicArray<N> tmpSegment : this.mySegments) {
            tmpSegment.fillAll(supplier);
        }
    }

    @Override
    public void fillOne(long index, N value) {
        this.mySegments[(int)(index >> this.myIndexBits)].fillOne(index & this.myIndexMask, value);
    }

    @Override
    public void fillOneMatching(long index, Access1D<?> values, long valueIndex) {
        this.mySegments[(int)(index >> this.myIndexBits)].fillOneMatching(index & this.myIndexMask, values, valueIndex);
    }

    @Override
    public void fillOne(long index, NullaryFunction<N> supplier) {
        this.mySegments[(int)(index >> this.myIndexBits)].fillOne(index & this.myIndexMask, supplier);
    }

    @Override
    public void fillRange(long first, long limit, N value) {
        int tmpFirstSegment = (int)(first / this.mySegmentSize);
        int tmpLastSegemnt = (int)((limit - 1L) / this.mySegmentSize);
        long tmpFirstInSegment = first % this.mySegmentSize;
        for (int s = tmpFirstSegment; s < tmpLastSegemnt; ++s) {
            this.mySegments[s].fillRange(tmpFirstInSegment, this.mySegmentSize, value);
            tmpFirstInSegment = 0L;
        }
        this.mySegments[tmpLastSegemnt].fillRange(tmpFirstInSegment, limit - (long)tmpLastSegemnt * this.mySegmentSize, value);
    }

    @Override
    public void fillRange(long first, long limit, NullaryFunction<N> supplier) {
        int tmpFirstSegment = (int)(first / this.mySegmentSize);
        int tmpLastSegemnt = (int)((limit - 1L) / this.mySegmentSize);
        long tmpFirstInSegment = first % this.mySegmentSize;
        for (int s = tmpFirstSegment; s < tmpLastSegemnt; ++s) {
            this.mySegments[s].fillRange(tmpFirstInSegment, this.mySegmentSize, supplier);
            tmpFirstInSegment = 0L;
        }
        this.mySegments[tmpLastSegemnt].fillRange(tmpFirstInSegment, limit - (long)tmpLastSegemnt * this.mySegmentSize, supplier);
    }

    @Override
    public N get(long index) {
        return this.mySegments[(int)(index >> this.myIndexBits)].get(index & this.myIndexMask);
    }

    @Override
    public boolean isAbsolute(long index) {
        return this.mySegments[(int)(index >> this.myIndexBits)].isAbsolute(index & this.myIndexMask);
    }

    @Override
    public boolean isSmall(long index, double comparedTo) {
        return this.mySegments[(int)(index >> this.myIndexBits)].isSmall(index & this.myIndexMask, comparedTo);
    }

    @Override
    public void modifyOne(long index, UnaryFunction<N> function) {
        BasicArray<N> tmpSegment = this.mySegments[(int)(index >> this.myIndexBits)];
        long tmpIndex = index & this.myIndexMask;
        tmpSegment.set(tmpIndex, (Number)function.invoke(tmpSegment.get(tmpIndex)));
    }

    @Override
    public void set(long index, double value) {
        this.mySegments[(int)(index >> this.myIndexBits)].set(index & this.myIndexMask, value);
    }

    @Override
    public void set(long index, Number value) {
        this.mySegments[(int)(index >> this.myIndexBits)].set(index & this.myIndexMask, value);
    }

    @Override
    public void visitOne(long index, VoidFunction<N> visitor) {
        if (this.isPrimitive()) {
            visitor.invoke(this.doubleValue(index));
        } else {
            visitor.invoke(this.get(index));
        }
    }

    @Override
    protected void exchange(long firstA, long firstB, long step, long count) {
        if (this.isPrimitive()) {
            long tmpIndexA = firstA;
            long tmpIndexB = firstB;
            for (long i = 0L; i < count; ++i) {
                double tmpVal = this.doubleValue(tmpIndexA);
                this.set(tmpIndexA, this.doubleValue(tmpIndexB));
                this.set(tmpIndexB, tmpVal);
                tmpIndexA += step;
                tmpIndexB += step;
            }
        } else {
            long tmpIndexA = firstA;
            long tmpIndexB = firstB;
            for (long i = 0L; i < count; ++i) {
                N tmpVal = this.get(tmpIndexA);
                this.set(tmpIndexA, (Number)this.get(tmpIndexB));
                this.set(tmpIndexB, (Number)tmpVal);
                tmpIndexA += step;
                tmpIndexB += step;
            }
        }
    }

    @Override
    protected void fill(long first, long limit, long step, N value) {
        if (step <= this.mySegmentSize) {
            int tmpFirstSegment = (int)(first / this.mySegmentSize);
            int tmpLastSegemnt = (int)((limit - 1L) / this.mySegmentSize);
            long tmpFirstInSegment = first % this.mySegmentSize;
            for (int s = tmpFirstSegment; s < tmpLastSegemnt; ++s) {
                this.mySegments[s].fill(tmpFirstInSegment, this.mySegmentSize, step, value);
                long tmpRemainder = (this.mySegmentSize - tmpFirstInSegment) % step;
                tmpFirstInSegment = tmpRemainder == 0L ? 0L : step - tmpRemainder;
            }
            this.mySegments[tmpLastSegemnt].fill(tmpFirstInSegment, limit - (long)tmpLastSegemnt * this.mySegmentSize, step, value);
        } else if (this.isPrimitive()) {
            double tmpValue = ((Number)value).doubleValue();
            for (long i = first; i < limit; i += step) {
                this.set(i, tmpValue);
            }
        } else {
            for (long i = first; i < limit; i += step) {
                this.set(i, (Number)value);
            }
        }
    }

    @Override
    protected void fill(long first, long limit, long step, NullaryFunction<N> supplier) {
        if (step <= this.mySegmentSize) {
            int tmpFirstSegment = (int)(first / this.mySegmentSize);
            int tmpLastSegemnt = (int)((limit - 1L) / this.mySegmentSize);
            long tmpFirstInSegment = first % this.mySegmentSize;
            for (int s = tmpFirstSegment; s < tmpLastSegemnt; ++s) {
                this.mySegments[s].fill(tmpFirstInSegment, this.mySegmentSize, step, supplier);
                long tmpRemainder = (this.mySegmentSize - tmpFirstInSegment) % step;
                tmpFirstInSegment = tmpRemainder == 0L ? 0L : step - tmpRemainder;
            }
            this.mySegments[tmpLastSegemnt].fill(tmpFirstInSegment, limit - (long)tmpLastSegemnt * this.mySegmentSize, step, supplier);
        } else if (this.isPrimitive()) {
            for (long i = first; i < limit; i += step) {
                this.set(i, supplier.doubleValue());
            }
        } else {
            for (long i = first; i < limit; i += step) {
                this.set(i, (Number)supplier.invoke());
            }
        }
    }

    @Override
    protected long indexOfLargest(long first, long limit, long step) {
        double tmpVal = PrimitiveMath.ZERO;
        long retVal = Long.MIN_VALUE;
        for (long tmpIndex = first; tmpIndex < limit; tmpIndex += step) {
            if (!(this.doubleValue(tmpIndex) > tmpVal)) continue;
            tmpVal = Math.abs(this.doubleValue(tmpIndex));
            retVal = tmpIndex;
        }
        return retVal;
    }

    @Override
    protected boolean isSmall(long first, long limit, long step, double comparedTo) {
        boolean retVal = true;
        for (long i = first; retVal && i < limit; retVal &= this.isSmall(i, comparedTo), i += step) {
        }
        return retVal;
    }

    @Override
    protected void modify(long first, long limit, long step, Access1D<N> left, BinaryFunction<N> function) {
        if (this.isPrimitive()) {
            for (long l = first; l < limit; l += step) {
                this.set(l, function.invoke(left.doubleValue(l), this.doubleValue(l)));
            }
        } else {
            for (long l = first; l < limit; l += step) {
                this.set(l, (Number)function.invoke(left.get(l), this.get(l)));
            }
        }
    }

    @Override
    protected void modify(long first, long limit, long step, BinaryFunction<N> function, Access1D<N> right) {
        if (this.isPrimitive()) {
            for (long l = first; l < limit; l += step) {
                this.set(l, function.invoke(this.doubleValue(l), right.doubleValue(l)));
            }
        } else {
            for (long l = first; l < limit; l += step) {
                this.set(l, (Number)function.invoke(this.get(l), right.get(l)));
            }
        }
    }

    @Override
    protected void modify(long first, long limit, long step, UnaryFunction<N> function) {
        if (step <= this.mySegmentSize) {
            int tmpFirstSegment = (int)(first / this.mySegmentSize);
            int tmpLastSegemnt = (int)((limit - 1L) / this.mySegmentSize);
            long tmpFirstInSegment = first % this.mySegmentSize;
            for (int s = tmpFirstSegment; s < tmpLastSegemnt; ++s) {
                this.mySegments[s].modify(tmpFirstInSegment, this.mySegmentSize, step, function);
                long tmpRemainder = (this.mySegmentSize - tmpFirstInSegment) % step;
                tmpFirstInSegment = tmpRemainder == 0L ? 0L : step - tmpRemainder;
            }
            this.mySegments[tmpLastSegemnt].modify(tmpFirstInSegment, limit - (long)tmpLastSegemnt * this.mySegmentSize, step, function);
        } else if (this.isPrimitive()) {
            for (long i = first; i < limit; i += step) {
                this.set(i, function.invoke(this.doubleValue(i)));
            }
        } else {
            for (long i = first; i < limit; i += step) {
                this.set(i, (Number)function.invoke(this.get(i)));
            }
        }
    }

    @Override
    protected void visit(long first, long limit, long step, VoidFunction<N> visitor) {
        if (step <= this.mySegmentSize) {
            int tmpFirstSegment = (int)(first / this.mySegmentSize);
            int tmpLastSegemnt = (int)((limit - 1L) / this.mySegmentSize);
            long tmpFirstInSegment = first % this.mySegmentSize;
            for (int s = tmpFirstSegment; s < tmpLastSegemnt; ++s) {
                this.mySegments[s].visit(tmpFirstInSegment, this.mySegmentSize, step, visitor);
                long tmpRemainder = (this.mySegmentSize - tmpFirstInSegment) % step;
                tmpFirstInSegment = tmpRemainder == 0L ? 0L : step - tmpRemainder;
            }
            this.mySegments[tmpLastSegemnt].visit(tmpFirstInSegment, limit - (long)tmpLastSegemnt * this.mySegmentSize, step, visitor);
        } else if (this.isPrimitive()) {
            for (long i = first; i < limit; i += step) {
                visitor.invoke(this.doubleValue(i));
            }
        } else {
            for (long i = first; i < limit; i += step) {
                visitor.invoke(this.get(i));
            }
        }
    }

    @Override
    boolean isPrimitive() {
        return this.mySegments[0].isPrimitive();
    }

    static abstract class SegmentedFactory<N extends Number>
    extends ArrayFactory<N> {
        SegmentedFactory() {
        }

        abstract DenseArray.DenseFactory<N> getDenseFactory();

        @Override
        long getElementSize() {
            return this.getDenseFactory().getElementSize();
        }

        abstract SparseArray.SparseFactory<N> getSparseFactory();

        @Override
        final SegmentedArray<N> makeStructuredZero(long ... structure) {
            return SegmentedArray.make(this.getSparseFactory(), structure);
        }

        @Override
        final SegmentedArray<N> makeToBeFilled(long ... structure) {
            return SegmentedArray.make(this.getDenseFactory(), structure);
        }
    }
}

