/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.Arrays;
import org.ojalgo.access.Access1D;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.ReferenceTypeArray;
import org.ojalgo.array.SegmentedArray;
import org.ojalgo.function.FunctionUtils;
import org.ojalgo.machine.MemoryEstimator;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;

public class RationalArray
extends ReferenceTypeArray<RationalNumber> {
    static final long ELEMENT_SIZE = MemoryEstimator.estimateObject(RationalNumber.class);
    static final DenseArray.DenseFactory<RationalNumber> FACTORY = new DenseArray.DenseFactory<RationalNumber>(){

        @Override
        long getElementSize() {
            return ELEMENT_SIZE;
        }

        @Override
        DenseArray<RationalNumber> make(int size) {
            return RationalArray.make(size);
        }

        @Override
        Scalar<RationalNumber> zero() {
            return RationalNumber.ZERO;
        }
    };

    public static final RationalArray make(int size) {
        return new RationalArray(size);
    }

    public static final SegmentedArray<RationalNumber> makeSegmented(long count) {
        return SegmentedArray.make(FACTORY, count);
    }

    public static final RationalArray wrap(RationalNumber[] data) {
        return new RationalArray(data);
    }

    protected RationalArray(int size) {
        super((Number[])new RationalNumber[size]);
        this.fill(0, size, 1, RationalNumber.ZERO);
    }

    protected RationalArray(RationalNumber[] data) {
        super((Number[])data);
    }

    @Override
    public boolean equals(Object anObj) {
        if (anObj instanceof RationalArray) {
            return Arrays.equals(this.data, ((RationalArray)anObj).data);
        }
        return super.equals(anObj);
    }

    @Override
    public final void fillMatching(Access1D<?> values) {
        int tmpLimit = (int)FunctionUtils.min(this.count(), values.count());
        for (int i = 0; i < tmpLimit; ++i) {
            ((RationalNumber[])this.data)[i] = RationalNumber.valueOf(values.get(i));
        }
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    protected final void add(int index, double addend) {
        this.fillOne(index, ((RationalNumber)this.get(index)).add(this.valueOf(addend)));
    }

    @Override
    protected final void add(int index, Number addend) {
        this.fillOne(index, ((RationalNumber)this.get(index)).add(this.valueOf(addend)));
    }

    @Override
    protected int indexOfLargest(int first, int limit, int step) {
        int retVal = first;
        RationalNumber tmpLargest = RationalNumber.ZERO;
        for (int i = first; i < limit; i += step) {
            RationalNumber tmpValue = ((RationalNumber[])this.data)[i];
            if (tmpValue.compareTo(tmpLargest) != 1) continue;
            tmpLargest = tmpValue;
            retVal = i;
        }
        return retVal;
    }

    @Override
    protected boolean isAbsolute(int index) {
        return RationalNumber.isAbsolute(((RationalNumber[])this.data)[index]);
    }

    @Override
    protected boolean isSmall(int index, double comparedTo) {
        return RationalNumber.isSmall(comparedTo, ((RationalNumber[])this.data)[index]);
    }

    @Override
    DenseArray<RationalNumber> newInstance(int capacity) {
        return new RationalArray(capacity);
    }

    @Override
    final RationalNumber valueOf(double value) {
        return RationalNumber.valueOf(value);
    }

    @Override
    final RationalNumber valueOf(Number number) {
        return RationalNumber.valueOf(number);
    }
}

