/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.array.ArrayAnyD;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.SegmentedArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.machine.JavaType;
import org.ojalgo.scalar.PrimitiveScalar;

public class BufferArray
extends DenseArray<Double> {
    static long ELEMENT_SIZE = JavaType.DOUBLE.memory();
    static long MAX = 256L;
    private final DoubleBuffer myBuffer;
    private final RandomAccessFile myFile;

    public static Array1D<Double> make(File file, long count) {
        return BufferArray.create(file, count).asArray1D();
    }

    public static ArrayAnyD<Double> make(File file, long ... structure) {
        return BufferArray.create(file, structure).asArrayAnyD(structure);
    }

    public static Array2D<Double> make(File file, long rows, long columns) {
        return BufferArray.create(file, rows, columns).asArray2D(rows);
    }

    public static BasicArray<Double> make(int capacity) {
        return new BufferArray(DoubleBuffer.allocate(capacity), null);
    }

    public static BufferArray wrap(DoubleBuffer data) {
        return new BufferArray(data, null);
    }

    private static BasicArray<Double> create(File file, long ... structure) {
        long tmpCount = AccessUtils.count(structure);
        DoubleBuffer tmpDoubleBuffer = null;
        try {
            final RandomAccessFile tmpRandomAccessFile = new RandomAccessFile(file, "rw");
            final FileChannel tmpFileChannel = tmpRandomAccessFile.getChannel();
            long tmpSize = ELEMENT_SIZE * tmpCount;
            if (tmpCount > MAX) {
                DenseArray.DenseFactory<Double> tmpFactory = new DenseArray.DenseFactory<Double>(){
                    long offset = 0L;

                    @Override
                    long getElementSize() {
                        return ELEMENT_SIZE;
                    }

                    @Override
                    DenseArray<Double> make(int size) {
                        long tmpSize2 = (long)size * ELEMENT_SIZE;
                        try {
                            MappedByteBuffer tmpMap = tmpFileChannel.map(FileChannel.MapMode.READ_WRITE, this.offset, tmpSize2);
                            tmpMap.order(ByteOrder.nativeOrder());
                            BufferArray bufferArray = new BufferArray(tmpMap.asDoubleBuffer(), tmpRandomAccessFile);
                            return bufferArray;
                        }
                        catch (IOException exception) {
                            throw new RuntimeException(exception);
                        }
                        finally {
                            this.offset += tmpSize2;
                        }
                    }

                    PrimitiveScalar zero() {
                        return PrimitiveScalar.ZERO;
                    }
                };
                return SegmentedArray.make(tmpFactory, structure);
            }
            MappedByteBuffer tmpMappedByteBuffer = tmpFileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, tmpSize);
            tmpMappedByteBuffer.order(ByteOrder.nativeOrder());
            tmpDoubleBuffer = tmpMappedByteBuffer.asDoubleBuffer();
            return new BufferArray(tmpDoubleBuffer, tmpRandomAccessFile);
        }
        catch (FileNotFoundException exception) {
            throw new RuntimeException(exception);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    protected static void fill(DoubleBuffer data, Access1D<?> value) {
        int tmpLimit = (int)Math.min((long)data.capacity(), value.count());
        for (int i = 0; i < tmpLimit; ++i) {
            data.put(i, value.doubleValue(i));
        }
    }

    protected static void fill(DoubleBuffer data, int first, int limit, int step, double value) {
        for (int i = first; i < limit; i += step) {
            data.put(i, value);
        }
    }

    protected static void fill(DoubleBuffer data, int first, int limit, int step, NullaryFunction<?> supplier) {
        for (int i = first; i < limit; i += step) {
            data.put(i, supplier.doubleValue());
        }
    }

    protected static void invoke(DoubleBuffer data, int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function, Access1D<Double> right) {
        for (int i = first; i < limit; i += step) {
            data.put(i, function.invoke(left.get(i), right.get(i)));
        }
    }

    protected static void invoke(DoubleBuffer data, int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function, double right) {
        for (int i = first; i < limit; i += step) {
            data.put(i, function.invoke(left.doubleValue(i), right));
        }
    }

    protected static void invoke(DoubleBuffer data, int first, int limit, int step, Access1D<Double> value, ParameterFunction<Double> function, int aParam) {
        for (int i = first; i < limit; i += step) {
            data.put(i, function.invoke(value.doubleValue(i), aParam));
        }
    }

    protected static void invoke(DoubleBuffer data, int first, int limit, int step, Access1D<Double> value, UnaryFunction<Double> function) {
        for (int i = first; i < limit; i += step) {
            data.put(i, function.invoke(value.doubleValue(i)));
        }
    }

    protected static void invoke(DoubleBuffer data, int first, int limit, int step, double left, BinaryFunction<Double> function, Access1D<Double> right) {
        for (int i = first; i < limit; i += step) {
            data.put(i, function.invoke(left, right.doubleValue(i)));
        }
    }

    protected static void invoke(DoubleBuffer data, int first, int limit, int step, VoidFunction<Double> visitor) {
        for (int i = first; i < limit; i += step) {
            visitor.invoke(data.get(i));
        }
    }

    private BufferArray(DoubleBuffer buffer, RandomAccessFile file) {
        this.myBuffer = buffer;
        this.myFile = file;
    }

    public void close() {
        if (this.myFile != null) {
            try {
                this.myFile.close();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    protected void add(int index, double addend) {
        this.myBuffer.put(index, this.myBuffer.get(index) + addend);
    }

    @Override
    protected void add(int index, Number addend) {
        this.myBuffer.put(index, this.myBuffer.get(index) + addend.doubleValue());
    }

    @Override
    protected double doubleValue(int index) {
        return this.myBuffer.get(index);
    }

    @Override
    protected void exchange(int firstA, int firstB, int step, int count) {
        int tmpIndexA = firstA;
        int tmpIndexB = firstB;
        for (int i = 0; i < count; ++i) {
            double tmpVal = this.myBuffer.get(tmpIndexA);
            this.myBuffer.put(tmpIndexA, this.myBuffer.get(tmpIndexB));
            this.myBuffer.put(tmpIndexB, tmpVal);
            tmpIndexA += step;
            tmpIndexB += step;
        }
    }

    @Override
    protected void fill(int first, int limit, Access1D<Double> left, BinaryFunction<Double> function, Access1D<Double> right) {
        BufferArray.invoke(this.myBuffer, first, limit, 1, left, function, right);
    }

    @Override
    protected void fill(int first, int limit, Access1D<Double> left, BinaryFunction<Double> function, Double right) {
        BufferArray.invoke(this.myBuffer, first, limit, 1, left, function, right);
    }

    @Override
    protected void fill(int first, int limit, Double left, BinaryFunction<Double> function, Access1D<Double> right) {
        BufferArray.invoke(this.myBuffer, first, limit, 1, left, function, right);
    }

    @Override
    protected void fill(int first, int limit, int step, Double value) {
        BufferArray.fill(this.myBuffer, first, limit, step, value);
    }

    @Override
    protected void fill(int first, int limit, int step, NullaryFunction<Double> supplier) {
        BufferArray.fill(this.myBuffer, first, limit, step, supplier);
    }

    @Override
    protected void fillOne(int index, Double value) {
        this.myBuffer.put(index, value);
    }

    @Override
    protected void fillOne(int index, NullaryFunction<Double> supplier) {
        this.myBuffer.put(index, supplier.doubleValue());
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.myFile != null) {
            this.close();
        }
    }

    @Override
    protected Double get(int index) {
        return this.myBuffer.get(index);
    }

    @Override
    protected int indexOfLargest(int first, int limit, int step) {
        int retVal = first;
        double tmpLargest = PrimitiveMath.ZERO;
        for (int i = first; i < limit; i += step) {
            double tmpValue = Math.abs(this.myBuffer.get(i));
            if (!(tmpValue > tmpLargest)) continue;
            tmpLargest = tmpValue;
            retVal = i;
        }
        return retVal;
    }

    @Override
    protected boolean isAbsolute(int index) {
        return PrimitiveScalar.isAbsolute(this.myBuffer.get(index));
    }

    @Override
    protected boolean isSmall(int index, double comparedTo) {
        return PrimitiveScalar.isSmall(comparedTo, this.myBuffer.get(index));
    }

    @Override
    protected void modify(int index, Access1D<Double> left, BinaryFunction<Double> function) {
    }

    @Override
    protected void modify(int index, BinaryFunction<Double> function, Access1D<Double> right) {
    }

    @Override
    protected void modify(int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function) {
        BufferArray.invoke(this.myBuffer, first, limit, step, left, function, (Access1D<Double>)this);
    }

    @Override
    protected void modify(int first, int limit, int step, BinaryFunction<Double> function, Access1D<Double> right) {
        BufferArray.invoke(this.myBuffer, first, limit, step, (Access1D<Double>)this, function, right);
    }

    @Override
    protected void modify(int first, int limit, int step, BinaryFunction<Double> function, Double right) {
        BufferArray.invoke(this.myBuffer, first, limit, step, (Access1D<Double>)this, function, right);
    }

    @Override
    protected void modify(int first, int limit, int step, Double left, BinaryFunction<Double> function) {
        BufferArray.invoke(this.myBuffer, first, limit, step, left, function, (Access1D<Double>)this);
    }

    @Override
    protected void modify(int first, int limit, int step, ParameterFunction<Double> function, int parameter) {
        BufferArray.invoke(this.myBuffer, first, limit, step, (Access1D<Double>)this, function, parameter);
    }

    @Override
    protected void modify(int first, int limit, int step, UnaryFunction<Double> function) {
        BufferArray.invoke(this.myBuffer, first, limit, step, this, function);
    }

    @Override
    protected void modify(int index, UnaryFunction<Double> function) {
        this.myBuffer.put(index, function.invoke(this.myBuffer.get(index)));
    }

    @Override
    protected int searchAscending(Double number) {
        return -1;
    }

    @Override
    protected void set(int index, double value) {
        this.myBuffer.put(index, value);
    }

    @Override
    protected void set(int index, Number value) {
        this.myBuffer.put(index, value.doubleValue());
    }

    @Override
    protected int size() {
        return this.myBuffer.capacity();
    }

    @Override
    protected void sortAscending() {
    }

    @Override
    protected void visit(int first, int limit, int step, VoidFunction<Double> visitor) {
        BufferArray.invoke(this.myBuffer, first, limit, step, visitor);
    }

    @Override
    protected void visitOne(int index, VoidFunction<Double> visitor) {
        visitor.invoke(this.myBuffer.get(index));
    }

    @Override
    boolean isPrimitive() {
        return true;
    }

    @Override
    DenseArray<Double> newInstance(int capacity) {
        return null;
    }

    @Override
    protected void fillOneMatching(int index, Access1D<?> values, long valueIndex) {
        this.myBuffer.put(index, values.doubleValue(valueIndex));
    }
}

