/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.io.Serializable;
import java.math.BigDecimal;
import org.ojalgo.OjAlgoUtils;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.array.ArrayAnyD;
import org.ojalgo.array.ArrayFactory;
import org.ojalgo.array.BigArray;
import org.ojalgo.array.ComplexArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PrimitiveArray;
import org.ojalgo.array.QuaternionArray;
import org.ojalgo.array.RationalArray;
import org.ojalgo.array.SegmentedArray;
import org.ojalgo.array.SparseArray;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;

public abstract class BasicArray<N extends Number>
implements Access1D<N>,
Access1D.Elements,
Access1D.IndexOf,
Access1D.Fillable<N>,
Access1D.Modifiable<N>,
Access1D.Visitable<N>,
Serializable {
    public static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    static final BasicFactory<BigDecimal> BIG = new BasicFactory<BigDecimal>(){

        @Override
        DenseArray.DenseFactory<BigDecimal> getDenseFactory() {
            return BigArray.FACTORY;
        }

        @Override
        long getElementSize() {
            return BigArray.ELEMENT_SIZE;
        }

        @Override
        SegmentedArray.SegmentedFactory<BigDecimal> getSegmentedFactory() {
            return SegmentedArray.BIG;
        }

        @Override
        SparseArray.SparseFactory<BigDecimal> getSparseFactory() {
            return SparseArray.BIG;
        }
    };
    static final BasicFactory<ComplexNumber> COMPLEX = new BasicFactory<ComplexNumber>(){

        @Override
        DenseArray.DenseFactory<ComplexNumber> getDenseFactory() {
            return ComplexArray.FACTORY;
        }

        @Override
        long getElementSize() {
            return ComplexArray.ELEMENT_SIZE;
        }

        @Override
        SegmentedArray.SegmentedFactory<ComplexNumber> getSegmentedFactory() {
            return SegmentedArray.COMPLEX;
        }

        @Override
        SparseArray.SparseFactory<ComplexNumber> getSparseFactory() {
            return SparseArray.COMPLEX;
        }
    };
    static final BasicFactory<Double> PRIMITIVE = new BasicFactory<Double>(){

        @Override
        DenseArray.DenseFactory<Double> getDenseFactory() {
            return PrimitiveArray.FACTORY;
        }

        @Override
        long getElementSize() {
            return PrimitiveArray.ELEMENT_SIZE;
        }

        @Override
        SegmentedArray.SegmentedFactory<Double> getSegmentedFactory() {
            return SegmentedArray.PRIMITIVE;
        }

        @Override
        SparseArray.SparseFactory<Double> getSparseFactory() {
            return SparseArray.PRIMITIVE;
        }
    };
    static final BasicFactory<Quaternion> QUATERNION = new BasicFactory<Quaternion>(){

        @Override
        DenseArray.DenseFactory<Quaternion> getDenseFactory() {
            return QuaternionArray.FACTORY;
        }

        @Override
        long getElementSize() {
            return QuaternionArray.ELEMENT_SIZE;
        }

        @Override
        SegmentedArray.SegmentedFactory<Quaternion> getSegmentedFactory() {
            return SegmentedArray.QUATERNION;
        }

        @Override
        SparseArray.SparseFactory<Quaternion> getSparseFactory() {
            return SparseArray.QUATERNION;
        }
    };
    static final BasicFactory<RationalNumber> RATIONAL = new BasicFactory<RationalNumber>(){

        @Override
        DenseArray.DenseFactory<RationalNumber> getDenseFactory() {
            return RationalArray.FACTORY;
        }

        @Override
        long getElementSize() {
            return RationalArray.ELEMENT_SIZE;
        }

        @Override
        SegmentedArray.SegmentedFactory<RationalNumber> getSegmentedFactory() {
            return SegmentedArray.RATIONAL;
        }

        @Override
        SparseArray.SparseFactory<RationalNumber> getSparseFactory() {
            return SparseArray.RATIONAL;
        }
    };

    protected BasicArray() {
    }

    @Override
    public long indexOfLargest() {
        return this.indexOfLargest(0L, this.count(), 1L);
    }

    @Override
    public long indexOfLargestInRange(long first, long limit) {
        return this.indexOfLargest(first, limit, 1L);
    }

    @Override
    public void modifyAll(UnaryFunction<N> function) {
        this.modify(0L, this.count(), 1L, function);
    }

    @Override
    public void modifyMatching(Access1D<N> left, BinaryFunction<N> function) {
        this.fillMatching(left, function, this);
    }

    @Override
    public void modifyMatching(BinaryFunction<N> function, Access1D<N> right) {
        this.fillMatching(this, function, right);
    }

    @Override
    public void modifyRange(long first, long limit, UnaryFunction<N> function) {
        this.modify(first, limit, 1L, function);
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder();
        retVal.append('{');
        retVal.append(' ');
        int tmpLength = (int)this.count();
        if (tmpLength >= 1) {
            retVal.append(this.get(0L).toString());
            for (int i = 1; i < tmpLength; ++i) {
                retVal.append(',');
                retVal.append(' ');
                retVal.append(this.get(i).toString());
            }
            retVal.append(' ');
        }
        retVal.append('}');
        return retVal.toString();
    }

    @Override
    public void visitAll(VoidFunction<N> visitor) {
        this.visit(0L, this.count(), 1L, visitor);
    }

    @Override
    public void visitRange(long first, long limit, VoidFunction<N> visitor) {
        this.visit(first, limit, 1L, visitor);
    }

    protected final Array1D<N> asArray1D() {
        return new Array1D(this);
    }

    protected final Array2D<N> asArray2D(long structure) {
        return new Array2D(this, structure);
    }

    protected final ArrayAnyD<N> asArrayAnyD(long[] structure) {
        return new ArrayAnyD(this, structure);
    }

    protected abstract void exchange(long var1, long var3, long var5, long var7);

    protected abstract void fill(long var1, long var3, long var5, N var7);

    protected abstract void fill(long var1, long var3, long var5, NullaryFunction<N> var7);

    protected abstract long indexOfLargest(long var1, long var3, long var5);

    protected abstract boolean isSmall(long var1, long var3, long var5, double var7);

    protected abstract void modify(long var1, long var3, long var5, Access1D<N> var7, BinaryFunction<N> var8);

    protected abstract void modify(long var1, long var3, long var5, BinaryFunction<N> var7, Access1D<N> var8);

    protected abstract void modify(long var1, long var3, long var5, UnaryFunction<N> var7);

    protected abstract void visit(long var1, long var3, long var5, VoidFunction<N> var7);

    final boolean isDense() {
        return this instanceof DenseArray;
    }

    abstract boolean isPrimitive();

    final boolean isSegmented() {
        return this instanceof SegmentedArray;
    }

    final boolean isSparse() {
        return this instanceof SparseArray;
    }

    static abstract class BasicFactory<N extends Number>
    extends ArrayFactory<N> {
        BasicFactory() {
        }

        abstract DenseArray.DenseFactory<N> getDenseFactory();

        abstract SegmentedArray.SegmentedFactory<N> getSegmentedFactory();

        abstract SparseArray.SparseFactory<N> getSparseFactory();

        @Override
        BasicArray<N> makeStructuredZero(long ... structure) {
            long tmpTotal = AccessUtils.count(structure);
            if (tmpTotal > 0x7FFFFFF7L) {
                return this.getSegmentedFactory().makeStructuredZero(structure);
            }
            if (tmpTotal > (long)OjAlgoUtils.ENVIRONMENT.getCacheDim1D(this.getDenseFactory().getElementSize())) {
                return new SparseArray<N>(tmpTotal, this.getDenseFactory());
            }
            return this.getDenseFactory().makeStructuredZero(structure);
        }

        @Override
        BasicArray<N> makeToBeFilled(long ... structure) {
            long tmpTotal = AccessUtils.count(structure);
            if (tmpTotal > 0x7FFFFFF7L) {
                return this.getSegmentedFactory().makeToBeFilled(structure);
            }
            return this.getDenseFactory().makeToBeFilled(structure);
        }
    }
}

