/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.List;
import org.ojalgo.access.Access1D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.function.NullaryFunction;

abstract class ArrayFactory<N extends Number>
implements Access1D.Factory<BasicArray<N>> {
    ArrayFactory() {
    }

    @Override
    public final BasicArray<N> copy(Access1D<?> source) {
        long tmpCount = source.count();
        BasicArray<N> retVal = this.makeToBeFilled(tmpCount);
        for (long i = 0L; i < tmpCount; ++i) {
            retVal.set(i, source.doubleValue(i));
        }
        return retVal;
    }

    @Override
    public final BasicArray<N> copy(double ... source) {
        int tmpLength = source.length;
        BasicArray<N> retVal = this.makeToBeFilled(tmpLength);
        for (int i = 0; i < tmpLength; ++i) {
            retVal.set((long)i, source[i]);
        }
        return retVal;
    }

    @Override
    public final BasicArray<N> copy(List<? extends Number> source) {
        int tmpSize = source.size();
        BasicArray<N> retVal = this.makeToBeFilled(tmpSize);
        for (int i = 0; i < tmpSize; ++i) {
            retVal.set((long)i, source.get(i));
        }
        return retVal;
    }

    @Override
    public final BasicArray<N> copy(Number ... source) {
        int tmpLength = source.length;
        BasicArray<N> retVal = this.makeToBeFilled(tmpLength);
        for (int i = 0; i < tmpLength; ++i) {
            retVal.set((long)i, source[i]);
        }
        return retVal;
    }

    @Override
    public BasicArray<N> makeFilled(long count, NullaryFunction<?> supplier) {
        BasicArray<N> retVal = this.makeToBeFilled(count);
        for (long i = 0L; i < count; ++i) {
            retVal.set(i, (Number)supplier.get());
        }
        return retVal;
    }

    @Override
    public final BasicArray<N> makeZero(long count) {
        return this.makeStructuredZero(count);
    }

    abstract long getElementSize();

    abstract BasicArray<N> makeStructuredZero(long ... var1);

    abstract BasicArray<N> makeToBeFilled(long ... var1);
}

