/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.access;

import java.util.Iterator;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;

public class RowsIterator<N extends Number>
implements Access1D<N>,
Iterator<Access1D<N>> {
    public long row = -1L;
    private final Access2D<N> myAccess2D;
    final RowIterable iterable = new RowIterable();

    public static <S extends Number> Iterable<Access1D<S>> make(Access2D<S> access) {
        return new RowsIterator<S>(access).iterable;
    }

    public RowsIterator(Access2D<N> access) {
        this.myAccess2D = access;
    }

    private RowsIterator() {
        this(null);
    }

    @Override
    public long count() {
        return this.myAccess2D.countColumns();
    }

    @Override
    public double doubleValue(long index) {
        return this.myAccess2D.doubleValue(this.row, index);
    }

    @Override
    public N get(long index) {
        return this.myAccess2D.get(this.row, index);
    }

    @Override
    public boolean hasNext() {
        return this.row + 1L < this.myAccess2D.countRows();
    }

    @Override
    public Access1D<N> next() {
        ++this.row;
        return this;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    final class RowIterable
    implements Iterable<Access1D<N>> {
        RowIterable() {
        }

        @Override
        public Iterator<Access1D<N>> iterator() {
            return RowsIterator.this;
        }
    }
}

