/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.access;

import java.util.Iterator;
import java.util.List;
import java.util.stream.BaseStream;
import java.util.stream.StreamSupport;
import org.ojalgo.access.Iterator1D;
import org.ojalgo.access.Structure1D;
import org.ojalgo.array.ArrayUtils;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionUtils;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;

public interface Access1D<N extends Number>
extends Structure1D,
Iterable<N> {
    public double doubleValue(long var1);

    public N get(long var1);

    @Override
    default public Iterator<N> iterator() {
        return new Iterator1D(this);
    }

    default public BaseStream<N, ? extends BaseStream<N, ?>> stream(boolean parallel) {
        return StreamSupport.stream(this.spliterator(), parallel);
    }

    default public double[] toRawCopy1D() {
        return ArrayUtils.toRawCopyOf(this);
    }

    public static interface Visitable<N extends Number>
    extends Structure1D {
        public void visitAll(VoidFunction<N> var1);

        public void visitOne(long var1, VoidFunction<N> var3);

        public void visitRange(long var1, long var3, VoidFunction<N> var5);
    }

    public static interface Sliceable<N extends Number>
    extends Structure1D {
        public Access1D<N> sliceRange(long var1, long var3);
    }

    public static interface Settable<N extends Number>
    extends Structure1D {
        public void add(long var1, double var3);

        public void add(long var1, Number var3);

        public void set(long var1, double var3);

        public void set(long var1, Number var3);
    }

    public static interface Modifiable<N extends Number>
    extends Settable<N> {
        public void modifyAll(UnaryFunction<N> var1);

        public void modifyMatching(Access1D<N> var1, BinaryFunction<N> var2);

        public void modifyMatching(BinaryFunction<N> var1, Access1D<N> var2);

        public void modifyOne(long var1, UnaryFunction<N> var3);

        public void modifyRange(long var1, long var3, UnaryFunction<N> var5);
    }

    public static interface Fillable<N extends Number>
    extends Settable<N> {
        public void fillAll(N var1);

        public void fillAll(NullaryFunction<N> var1);

        default public void fillMatching(Access1D<?> values) {
            long tmpLimit = FunctionUtils.min(this.count(), values.count());
            for (long i = 0L; i < tmpLimit; ++i) {
                this.fillOneMatching(i, values, i);
            }
        }

        default public void fillMatching(Access1D<N> left, BinaryFunction<N> function, Access1D<N> right) {
            long tmpLimit = FunctionUtils.min(left.count(), right.count(), this.count());
            for (long i = 0L; i < tmpLimit; ++i) {
                this.fillOne(i, function.invoke(left.get(i), right.get(i)));
            }
        }

        default public void fillMatching(UnaryFunction<N> function, Access1D<N> arguments) {
            long tmpLimit = FunctionUtils.min(this.count(), arguments.count());
            for (long i = 0L; i < tmpLimit; ++i) {
                this.fillOne(i, function.invoke(arguments.get(i)));
            }
        }

        public void fillOne(long var1, N var3);

        public void fillOne(long var1, NullaryFunction<N> var3);

        public void fillOneMatching(long var1, Access1D<?> var3, long var4);

        public void fillRange(long var1, long var3, N var5);

        public void fillRange(long var1, long var3, NullaryFunction<N> var5);
    }

    public static interface Factory<I extends Access1D<?>> {
        public I copy(Access1D<?> var1);

        public I copy(double ... var1);

        public I copy(List<? extends Number> var1);

        public I copy(Number ... var1);

        public I makeFilled(long var1, NullaryFunction<?> var3);

        public I makeZero(long var1);
    }

    public static interface IndexOf
    extends Structure1D {
        default public long indexOfLargest() {
            return this.indexOfLargestInRange(0L, this.count());
        }

        public long indexOfLargestInRange(long var1, long var3);
    }

    public static interface Elements
    extends Structure1D {
        public boolean isAbsolute(long var1);

        public boolean isSmall(long var1, double var3);

        @Deprecated
        default public boolean isZero(long index) {
            return this.isSmall(index, PrimitiveMath.ONE);
        }
    }

    public static interface Builder<I extends Access1D<?>>
    extends Structure1D {
        public I build();

        public Builder<I> fillAll(Number var1);

        public Builder<I> set(long var1, double var3);

        public Builder<I> set(long var1, Number var3);
    }
}

