/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.serializer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.spark.SparkConf;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BroadcastBlockId;
import org.apache.spark.storage.RDDBlockId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.storage.TempLocalBlockId;
import org.apache.spark.storage.TempShuffleBlockId;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.apache.spark.util.io.ChunkedByteBufferOutputStream;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh!B\u0001\u0003\u0001\u0011Q!!E*fe&\fG.\u001b>fe6\u000bg.Y4fe*\u00111\u0001B\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014(BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0014\u0005\u0001Y\u0001C\u0001\u0007\u0010\u001b\u0005i!\"\u0001\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ai!AB!osJ+g\r\u0003\u0005\u0013\u0001\t\u0005\t\u0015!\u0003\u0015\u0003E!WMZ1vYR\u001cVM]5bY&TXM]\u0002\u0001!\t)b#D\u0001\u0003\u0013\t9\"A\u0001\u0006TKJL\u0017\r\\5{KJD\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0005G>tg\r\u0005\u0002\u001c95\tA!\u0003\u0002\u001e\t\tI1\u000b]1sW\u000e{gN\u001a\u0005\u0006?\u0001!\t\u0001I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0005\u00123\u0005\u0005\u0002\u0016\u0001!)!C\ba\u0001)!)\u0011D\ba\u00015!1Q\u0005\u0001Q\u0001\n\u0019\nab\u001b:z_N+'/[1mSj,'\u000f\u0005\u0002\u0016O%\u0011\u0001F\u0001\u0002\u000f\u0017JLxnU3sS\u0006d\u0017N_3s\u0011\u0019Q\u0003\u0001)A\u0005W\u0005q1\u000f\u001e:j]\u001e\u001cE.Y:t)\u0006<\u0007c\u0001\u00170c5\tQF\u0003\u0002/\u001b\u00059!/\u001a4mK\u000e$\u0018B\u0001\u0019.\u0005!\u0019E.Y:t)\u0006<\u0007C\u0001\u001a6\u001d\ta1'\u0003\u00025\u001b\u00051\u0001K]3eK\u001aL!AN\u001c\u0003\rM#(/\u001b8h\u0015\t!T\u0002\u0003\u0004:\u0001\u0001\u0006IAO\u0001$aJLW.\u001b;jm\u0016\fe\u000e\u001a)sS6LG/\u001b<f\u0003J\u0014\u0018-_\"mCN\u001cH+Y4t!\r\u00114(P\u0005\u0003y]\u00121aU3ua\tq\u0014\tE\u0002-_}\u0002\"\u0001Q!\r\u0001\u0011I!\tOA\u0001\u0002\u0003\u0015\ta\u0011\u0002\u0004?\u0012\n\u0014C\u0001#H!\taQ)\u0003\u0002G\u001b\t9aj\u001c;iS:<\u0007C\u0001\u0007I\u0013\tIUBA\u0002B]fDaa\u0013\u0001!\u0002\u0013a\u0015!E2p[B\u0014Xm]:Ce>\fGmY1tiB\u0011A\"T\u0005\u0003\u001d6\u0011qAQ8pY\u0016\fg\u000e\u0003\u0004Q\u0001\u0001\u0006I\u0001T\u0001\u0010G>l\u0007O]3tgNCWO\u001a4mK\"1!\u000b\u0001Q\u0001\n1\u000bAbY8naJ,7o\u001d*eINDa\u0001\u0016\u0001!\u0002\u0013a\u0015\u0001F2p[B\u0014Xm]:TQV4g\r\\3Ta&dG\u000e\u0003\u0005W\u0001!\u0015\r\u0011\"\u0003X\u0003A\u0019w.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7-F\u0001Y!\tIF,D\u0001[\u0015\tYF!\u0001\u0002j_&\u0011QL\u0017\u0002\u0011\u0007>l\u0007O]3tg&|gnQ8eK\u000eD\u0001b\u0018\u0001\t\u0002\u0003\u0006K\u0001W\u0001\u0012G>l\u0007O]3tg&|gnQ8eK\u000e\u0004\u0003\"B1\u0001\t\u0003\u0011\u0017AC2b]V\u001bXm\u0013:z_R\u0011Aj\u0019\u0005\u0006I\u0002\u0004\r!Z\u0001\u0003GR\u0004$A\u001a5\u0011\u00071zs\r\u0005\u0002AQ\u0012I\u0011nYA\u0001\u0002\u0003\u0015\ta\u0011\u0002\u0004?\u0012\u001a\u0004\"B6\u0001\t\u0003a\u0017!D4fiN+'/[1mSj,'\u000f\u0006\u0002\u0015[\")AM\u001ba\u0001]B\u0012q.\u001d\t\u0004Y=\u0002\bC\u0001!r\t%\u0011X.!A\u0001\u0002\u000b\u00051IA\u0002`IQBQa\u001b\u0001\u0005\u0002Q$2\u0001F;}\u0011\u001518\u000f1\u0001x\u0003-YW-_\"mCN\u001cH+Y41\u0005aT\bc\u0001\u00170sB\u0011\u0001I\u001f\u0003\nwV\f\t\u0011!A\u0003\u0002\r\u00131a\u0018\u00136\u0011\u0015i8\u000f1\u0001\u007f\u000351\u0018\r\\;f\u00072\f7o\u001d+bOB\u001aq0a\u0001\u0011\t1z\u0013\u0011\u0001\t\u0004\u0001\u0006\rAACA\u0003y\u0006\u0005\t\u0011!B\u0001\u0007\n\u0019q\f\n\u001c\t\u000f\u0005%\u0001\u0001\"\u0003\u0002\f\u0005q1\u000f[8vY\u0012\u001cu.\u001c9sKN\u001cHc\u0001'\u0002\u000e!A\u0011qBA\u0004\u0001\u0004\t\t\"A\u0004cY>\u001c7.\u00133\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006\u0005\u0003\u001d\u0019Ho\u001c:bO\u0016LA!a\u0007\u0002\u0016\t9!\t\\8dW&#\u0007bBA\u0010\u0001\u0011\u0005\u0011\u0011E\u0001\u0013oJ\f\u0007OR8s\u0007>l\u0007O]3tg&|g\u000e\u0006\u0004\u0002$\u0005E\u00121\u0007\t\u0005\u0003K\ti#\u0004\u0002\u0002()\u00191,!\u000b\u000b\u0005\u0005-\u0012\u0001\u00026bm\u0006LA!a\f\u0002(\taq*\u001e;qkR\u001cFO]3b[\"A\u0011qBA\u000f\u0001\u0004\t\t\u0002\u0003\u0005\u00026\u0005u\u0001\u0019AA\u0012\u0003\u0005\u0019\bbBA\u0010\u0001\u0011\u0005\u0011\u0011\b\u000b\u0007\u0003w\t\t%a\u0011\u0011\t\u0005\u0015\u0012QH\u0005\u0005\u0003\u007f\t9CA\u0006J]B,Ho\u0015;sK\u0006l\u0007\u0002CA\b\u0003o\u0001\r!!\u0005\t\u0011\u0005U\u0012q\u0007a\u0001\u0003wAq!a\u0012\u0001\t\u0003\tI%A\neCR\f7+\u001a:jC2L'0Z*ue\u0016\fW.\u0006\u0003\u0002L\u0005uC\u0003CA'\u0003C\n\u0019'a\u001a\u0015\t\u0005=\u0013Q\u000b\t\u0004\u0019\u0005E\u0013bAA*\u001b\t!QK\\5u\u0011)\t9&!\u0012\u0002\u0002\u0003\u000f\u0011\u0011L\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004\u0003\u0002\u00170\u00037\u00022\u0001QA/\t\u001d\ty&!\u0012C\u0002\r\u0013\u0011\u0001\u0016\u0005\t\u0003\u001f\t)\u00051\u0001\u0002\u0012!A\u0011QMA#\u0001\u0004\t\u0019#\u0001\u0007pkR\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0005\u0002j\u0005\u0015\u0003\u0019AA6\u0003\u00191\u0018\r\\;fgB1\u0011QNA?\u00037rA!a\u001c\u0002z9!\u0011\u0011OA<\u001b\t\t\u0019HC\u0002\u0002vM\ta\u0001\u0010:p_Rt\u0014\"\u0001\b\n\u0007\u0005mT\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005}\u0014\u0011\u0011\u0002\t\u0013R,'/\u0019;pe*\u0019\u00111P\u0007\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\b\u0006iA-\u0019;b'\u0016\u0014\u0018.\u00197ju\u0016,B!!#\u0002$R1\u00111RAS\u0003O#B!!$\u0002\u001cB!\u0011qRAL\u001b\t\t\tJC\u0002\\\u0003'S1!!&\u0005\u0003\u0011)H/\u001b7\n\t\u0005e\u0015\u0011\u0013\u0002\u0012\u0007\",hn[3e\u0005f$XMQ;gM\u0016\u0014\bBCAO\u0003\u0007\u000b\t\u0011q\u0001\u0002 \u0006QQM^5eK:\u001cW\r\n\u001a\u0011\t1z\u0013\u0011\u0015\t\u0004\u0001\u0006\rFaBA0\u0003\u0007\u0013\ra\u0011\u0005\t\u0003\u001f\t\u0019\t1\u0001\u0002\u0012!A\u0011\u0011NAB\u0001\u0004\tI\u000b\u0005\u0004\u0002n\u0005u\u0014\u0011\u0015\u0005\b\u0003[\u0003A\u0011AAX\u0003\u0005\"\u0017\r^1TKJL\u0017\r\\5{K^KG\u000f[#ya2L7-\u001b;DY\u0006\u001c8\u000fV1h)!\ti)!-\u00024\u0006}\u0006\u0002CA\b\u0003W\u0003\r!!\u0005\t\u0011\u0005%\u00141\u0016a\u0001\u0003k\u0003D!a.\u0002<B1\u0011QNA?\u0003s\u00032\u0001QA^\t-\ti,a-\u0002\u0002\u0003\u0005)\u0011A\"\u0003\u0007}#s\u0007\u0003\u0005\u0002B\u0006-\u0006\u0019AAb\u0003!\u0019G.Y:t)\u0006<\u0007\u0007BAc\u0003\u0013\u0004B\u0001L\u0018\u0002HB\u0019\u0001)!3\u0005\u0017\u0005-\u0017qXA\u0001\u0002\u0003\u0015\ta\u0011\u0002\u0004?\u0012B\u0004bBAh\u0001\u0011\u0005\u0011\u0011[\u0001\u0016I\u0006$\u0018\rR3tKJL\u0017\r\\5{KN#(/Z1n+\u0011\t\u0019.a7\u0015\r\u0005U\u0017\u0011]Ar)\u0011\t9.!8\u0011\r\u00055\u0014QPAm!\r\u0001\u00151\u001c\u0003\b\u0003?\niM1\u0001D\u0011!\t\t-!4A\u0002\u0005}\u0007\u0003\u0002\u00170\u00033D\u0001\"a\u0004\u0002N\u0002\u0007\u0011\u0011\u0003\u0005\t\u0003K\fi\r1\u0001\u0002<\u0005Y\u0011N\u001c9viN#(/Z1n\u0001")
public class SerializerManager {
    private final Serializer defaultSerializer;
    private final SparkConf conf;
    private final KryoSerializer kryoSerializer;
    private final ClassTag<String> stringClassTag;
    private final Set<ClassTag<?>> primitiveAndPrimitiveArrayClassTags;
    private final boolean compressBroadcast;
    private final boolean compressShuffle;
    private final boolean compressRdds;
    private final boolean compressShuffleSpill;
    private CompressionCodec compressionCodec;
    private volatile boolean bitmap$0;

    private CompressionCodec compressionCodec$lzycompute() {
        SerializerManager serializerManager = this;
        synchronized (serializerManager) {
            if (!this.bitmap$0) {
                this.compressionCodec = CompressionCodec$.MODULE$.createCodec(this.conf);
                this.bitmap$0 = true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
            this.conf = null;
            return this.compressionCodec;
        }
    }

    private CompressionCodec compressionCodec() {
        return this.bitmap$0 ? this.compressionCodec : this.compressionCodec$lzycompute();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canUseKryo(ClassTag<?> ct) {
        if (this.primitiveAndPrimitiveArrayClassTags.contains(ct)) return true;
        ClassTag<?> classTag = ct;
        ClassTag<String> classTag2 = this.stringClassTag;
        if (classTag != null) {
            if (!classTag.equals(classTag2)) return false;
            return true;
        }
        if (classTag2 == null) return true;
        return false;
    }

    public Serializer getSerializer(ClassTag<?> ct) {
        return this.canUseKryo(ct) ? this.kryoSerializer : this.defaultSerializer;
    }

    public Serializer getSerializer(ClassTag<?> keyClassTag, ClassTag<?> valueClassTag) {
        return this.canUseKryo(keyClassTag) && this.canUseKryo(valueClassTag) ? this.kryoSerializer : this.defaultSerializer;
    }

    private boolean shouldCompress(BlockId blockId) {
        BlockId blockId2 = blockId;
        boolean bl = blockId2 instanceof ShuffleBlockId ? this.compressShuffle : (blockId2 instanceof BroadcastBlockId ? this.compressBroadcast : (blockId2 instanceof RDDBlockId ? this.compressRdds : (blockId2 instanceof TempLocalBlockId ? this.compressShuffleSpill : (blockId2 instanceof TempShuffleBlockId ? this.compressShuffle : false))));
        return bl;
    }

    public OutputStream wrapForCompression(BlockId blockId, OutputStream s) {
        return this.shouldCompress(blockId) ? this.compressionCodec().compressedOutputStream(s) : s;
    }

    public InputStream wrapForCompression(BlockId blockId, InputStream s) {
        return this.shouldCompress(blockId) ? this.compressionCodec().compressedInputStream(s) : s;
    }

    public <T> void dataSerializeStream(BlockId blockId, OutputStream outputStream, Iterator<T> values2, ClassTag<T> evidence$1) {
        BufferedOutputStream byteStream = new BufferedOutputStream(outputStream);
        SerializerInstance ser = this.getSerializer((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).newInstance();
        ser.serializeStream(this.wrapForCompression(blockId, byteStream)).writeAll(values2, evidence$1).close();
    }

    public <T> ChunkedByteBuffer dataSerialize(BlockId blockId, Iterator<T> values2, ClassTag<T> evidence$2) {
        return this.dataSerializeWithExplicitClassTag(blockId, values2, (ClassTag)Predef$.MODULE$.implicitly(evidence$2));
    }

    public ChunkedByteBuffer dataSerializeWithExplicitClassTag(BlockId blockId, Iterator<?> values2, ClassTag<?> classTag) {
        ChunkedByteBufferOutputStream bbos = new ChunkedByteBufferOutputStream(0x400000, (Function1<Object, ByteBuffer>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ByteBuffer apply(int x$1) {
                return ByteBuffer.allocate(x$1);
            }
        });
        BufferedOutputStream byteStream = new BufferedOutputStream(bbos);
        SerializerInstance ser = this.getSerializer(classTag).newInstance();
        ser.serializeStream(this.wrapForCompression(blockId, byteStream)).writeAll(values2, ClassTag$.MODULE$.apply(Object.class)).close();
        return bbos.toChunkedByteBuffer();
    }

    public <T> Iterator<T> dataDeserializeStream(BlockId blockId, InputStream inputStream, ClassTag<T> classTag) {
        BufferedInputStream stream = new BufferedInputStream(inputStream);
        return this.getSerializer(classTag).newInstance().deserializeStream(this.wrapForCompression(blockId, stream)).asIterator();
    }

    public SerializerManager(Serializer defaultSerializer, SparkConf conf) {
        this.defaultSerializer = defaultSerializer;
        this.conf = conf;
        this.kryoSerializer = new KryoSerializer(conf);
        this.stringClassTag = (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(String.class));
        Set primitiveClassTags = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ClassTag[]{ClassTag$.MODULE$.Boolean(), ClassTag$.MODULE$.Byte(), ClassTag$.MODULE$.Char(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Float(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.Null(), ClassTag$.MODULE$.Short()}));
        Set arrayClassTags = (Set)primitiveClassTags.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ClassTag<Object> apply(ClassTag<?> x$1) {
                return x$1.wrap();
            }
        }, Set$.MODULE$.canBuildFrom());
        this.primitiveAndPrimitiveArrayClassTags = (Set)primitiveClassTags.$plus$plus((GenTraversableOnce)arrayClassTags);
        this.compressBroadcast = conf.getBoolean("spark.broadcast.compress", true);
        this.compressShuffle = conf.getBoolean("spark.shuffle.compress", true);
        this.compressRdds = conf.getBoolean("spark.rdd.compress", false);
        this.compressShuffleSpill = conf.getBoolean("spark.shuffle.spill.compress", true);
    }
}

