/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.FIFOSchedulingAlgorithm;
import org.apache.spark.scheduler.FairSchedulingAlgorithm;
import org.apache.spark.scheduler.Schedulable;
import org.apache.spark.scheduler.SchedulingAlgorithm;
import org.apache.spark.scheduler.SchedulingMode$;
import org.apache.spark.scheduler.TaskSetManager;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u00055g!B\u0001\u0003\u0001\u0011Q!\u0001\u0002)p_2T!a\u0001\u0003\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0014\t\u0001Y\u0011#\u0006\t\u0003\u0019=i\u0011!\u0004\u0006\u0002\u001d\u0005)1oY1mC&\u0011\u0001#\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005I\u0019R\"\u0001\u0002\n\u0005Q\u0011!aC*dQ\u0016$W\u000f\\1cY\u0016\u0004\"AF\r\u000e\u0003]Q!\u0001\u0007\u0003\u0002\u0011%tG/\u001a:oC2L!AG\f\u0003\u000f1{wmZ5oO\"AA\u0004\u0001BC\u0002\u0013\u0005a$\u0001\u0005q_>dg*Y7f\u0007\u0001)\u0012a\b\t\u0003A\rr!\u0001D\u0011\n\u0005\tj\u0011A\u0002)sK\u0012,g-\u0003\u0002%K\t11\u000b\u001e:j]\u001eT!AI\u0007\t\u0011\u001d\u0002!\u0011!Q\u0001\n}\t\u0011\u0002]8pY:\u000bW.\u001a\u0011\t\u0011%\u0002!Q1A\u0005\u0002)\nab]2iK\u0012,H.\u001b8h\u001b>$W-F\u0001,!\ta#H\u0004\u0002.q9\u0011af\u000e\b\u0003_Yr!\u0001M\u001b\u000f\u0005E\"T\"\u0001\u001a\u000b\u0005Mj\u0012A\u0002\u001fs_>$h(C\u0001\n\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u00111\u0001B\u0005\u0003s\t\tabU2iK\u0012,H.\u001b8h\u001b>$W-\u0003\u0002<y\tq1k\u00195fIVd\u0017N\\4N_\u0012,'BA\u001d\u0003\u0011!q\u0004A!A!\u0002\u0013Y\u0013aD:dQ\u0016$W\u000f\\5oO6{G-\u001a\u0011\t\u0011\u0001\u0003!\u0011!Q\u0001\n\u0005\u000bA\"\u001b8ji6Kgn\u00155be\u0016\u0004\"\u0001\u0004\"\n\u0005\rk!aA%oi\"AQ\t\u0001B\u0001B\u0003%\u0011)\u0001\u0006j]&$x+Z5hQRDQa\u0012\u0001\u0005\u0002!\u000ba\u0001P5oSRtD#B%K\u00172k\u0005C\u0001\n\u0001\u0011\u0015ab\t1\u0001 \u0011\u0015Ic\t1\u0001,\u0011\u0015\u0001e\t1\u0001B\u0011\u0015)e\t1\u0001B\u0011\u001dy\u0005A1A\u0005\u0002A\u000b\u0001c]2iK\u0012,H.\u00192mKF+X-^3\u0016\u0003E\u00032AU-\u0012\u001b\u0005\u0019&B\u0001+V\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003-^\u000bA!\u001e;jY*\t\u0001,\u0001\u0003kCZ\f\u0017B\u0001.T\u0005U\u0019uN\\2veJ,g\u000e\u001e'j].,G-U;fk\u0016Da\u0001\u0018\u0001!\u0002\u0013\t\u0016!E:dQ\u0016$W\u000f\\1cY\u0016\fV/Z;fA!9a\f\u0001b\u0001\n\u0003y\u0016\u0001H:dQ\u0016$W\u000f\\1cY\u0016t\u0015-\\3U_N\u001b\u0007.\u001a3vY\u0006\u0014G.Z\u000b\u0002AB!!+Y\u0010\u0012\u0013\t\u00117KA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCBDa\u0001\u001a\u0001!\u0002\u0013\u0001\u0017!H:dQ\u0016$W\u000f\\1cY\u0016t\u0015-\\3U_N\u001b\u0007.\u001a3vY\u0006\u0014G.\u001a\u0011\t\u000f\u0019\u0004\u0001\u0019!C\u0001O\u00061q/Z5hQR,\u0012!\u0011\u0005\bS\u0002\u0001\r\u0011\"\u0001k\u0003)9X-[4ii~#S-\u001d\u000b\u0003W:\u0004\"\u0001\u00047\n\u00055l!\u0001B+oSRDqa\u001c5\u0002\u0002\u0003\u0007\u0011)A\u0002yIEBa!\u001d\u0001!B\u0013\t\u0015aB<fS\u001eDG\u000f\t\u0005\bg\u0002\u0001\r\u0011\"\u0001h\u0003!i\u0017N\\*iCJ,\u0007bB;\u0001\u0001\u0004%\tA^\u0001\r[&t7\u000b[1sK~#S-\u001d\u000b\u0003W^Dqa\u001c;\u0002\u0002\u0003\u0007\u0011\t\u0003\u0004z\u0001\u0001\u0006K!Q\u0001\n[&t7\u000b[1sK\u0002Bqa\u001f\u0001A\u0002\u0013\u0005q-\u0001\u0007sk:t\u0017N\\4UCN\\7\u000fC\u0004~\u0001\u0001\u0007I\u0011\u0001@\u0002!I,hN\\5oOR\u000b7o[:`I\u0015\fHCA6\u0000\u0011\u001dyG0!AA\u0002\u0005Cq!a\u0001\u0001A\u0003&\u0011)A\u0007sk:t\u0017N\\4UCN\\7\u000f\t\u0005\t\u0003\u000f\u0001\u0001\u0019!C\u0001O\u0006A\u0001O]5pe&$\u0018\u0010C\u0005\u0002\f\u0001\u0001\r\u0011\"\u0001\u0002\u000e\u0005a\u0001O]5pe&$\u0018p\u0018\u0013fcR\u00191.a\u0004\t\u0011=\fI!!AA\u0002\u0005Cq!a\u0005\u0001A\u0003&\u0011)A\u0005qe&|'/\u001b;zA!A\u0011q\u0003\u0001A\u0002\u0013\u0005q-A\u0004ti\u0006<W-\u00133\t\u0013\u0005m\u0001\u00011A\u0005\u0002\u0005u\u0011aC:uC\u001e,\u0017\nZ0%KF$2a[A\u0010\u0011!y\u0017\u0011DA\u0001\u0002\u0004\t\u0005bBA\u0012\u0001\u0001\u0006K!Q\u0001\tgR\fw-Z%eA!A\u0011q\u0005\u0001A\u0002\u0013\u0005a$\u0001\u0003oC6,\u0007\"CA\u0016\u0001\u0001\u0007I\u0011AA\u0017\u0003!q\u0017-\\3`I\u0015\fHcA6\u00020!Aq.!\u000b\u0002\u0002\u0003\u0007q\u0004C\u0004\u00024\u0001\u0001\u000b\u0015B\u0010\u0002\u000b9\fW.\u001a\u0011\t\u0013\u0005]\u0002\u00011A\u0005\u0002\u0005e\u0012A\u00029be\u0016tG/F\u0001J\u0011%\ti\u0004\u0001a\u0001\n\u0003\ty$\u0001\u0006qCJ,g\u000e^0%KF$2a[A!\u0011!y\u00171HA\u0001\u0002\u0004I\u0005bBA#\u0001\u0001\u0006K!S\u0001\ba\u0006\u0014XM\u001c;!\u0011%\tI\u0005\u0001a\u0001\n\u0003\tY%\u0001\u000euCN\\7+\u001a;TG\",G-\u001e7j]\u001e\fEnZ8sSRDW.\u0006\u0002\u0002NA\u0019!#a\u0014\n\u0007\u0005E#AA\nTG\",G-\u001e7j]\u001e\fEnZ8sSRDW\u000eC\u0005\u0002V\u0001\u0001\r\u0011\"\u0001\u0002X\u0005qB/Y:l'\u0016$8k\u00195fIVd\u0017N\\4BY\u001e|'/\u001b;i[~#S-\u001d\u000b\u0004W\u0006e\u0003\"C8\u0002T\u0005\u0005\t\u0019AA'\u0011!\ti\u0006\u0001Q!\n\u00055\u0013a\u0007;bg.\u001cV\r^*dQ\u0016$W\u000f\\5oO\u0006cwm\u001c:ji\"l\u0007\u0005C\u0004\u0002b\u0001!\t%a\u0019\u0002\u001d\u0005$GmU2iK\u0012,H.\u00192mKR\u00191.!\u001a\t\u000f\u0005\u001d\u0014q\fa\u0001#\u0005Y1o\u00195fIVd\u0017M\u00197f\u0011\u001d\tY\u0007\u0001C!\u0003[\n\u0011C]3n_Z,7k\u00195fIVd\u0017M\u00197f)\rY\u0017q\u000e\u0005\b\u0003O\nI\u00071\u0001\u0012\u0011\u001d\t\u0019\b\u0001C!\u0003k\nAcZ3u'\u000eDW\rZ;mC\ndWMQ=OC6,GcA\t\u0002x!9\u0011\u0011PA9\u0001\u0004y\u0012aD:dQ\u0016$W\u000f\\1cY\u0016t\u0015-\\3\t\u000f\u0005u\u0004\u0001\"\u0011\u0002\u0000\u0005aQ\r_3dkR|'\u000fT8tiR91.!!\u0002\u0006\u0006%\u0005bBAB\u0003w\u0002\raH\u0001\u000bKb,7-\u001e;pe&#\u0007bBAD\u0003w\u0002\raH\u0001\u0005Q>\u001cH\u000f\u0003\u0005\u0002\f\u0006m\u0004\u0019AAG\u0003\u0019\u0011X-Y:p]B\u0019!#a$\n\u0007\u0005E%A\u0001\nFq\u0016\u001cW\u000f^8s\u0019>\u001c8OU3bg>t\u0007bBAK\u0001\u0011\u0005\u0013qS\u0001\u0017G\",7m[*qK\u000e,H.\u0019;bE2,G+Y:lgR\u0011\u0011\u0011\u0014\t\u0004\u0019\u0005m\u0015bAAO\u001b\t9!i\\8mK\u0006t\u0007bBAQ\u0001\u0011\u0005\u00131U\u0001\u0016O\u0016$8k\u001c:uK\u0012$\u0016m]6TKR\fV/Z;f+\t\t)\u000b\u0005\u0004\u0002(\u0006E\u0016QW\u0007\u0003\u0003SSA!a+\u0002.\u00069Q.\u001e;bE2,'bAAX\u001b\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005M\u0016\u0011\u0016\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fE\u0002\u0013\u0003oK1!!/\u0003\u00059!\u0016m]6TKRl\u0015M\\1hKJDq!!0\u0001\t\u0003\ty,\u0001\u000bj]\u000e\u0014X-Y:f%Vtg.\u001b8h)\u0006\u001c8n\u001d\u000b\u0004W\u0006\u0005\u0007bBAb\u0003w\u0003\r!Q\u0001\bi\u0006\u001c8NT;n\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013\fA\u0003Z3de\u0016\f7/\u001a*v]:Lgn\u001a+bg.\u001cHcA6\u0002L\"9\u00111YAc\u0001\u0004\t\u0005")
public class Pool
implements Schedulable,
Logging {
    private final String poolName;
    private final Enumeration.Value schedulingMode;
    private final ConcurrentLinkedQueue<Schedulable> schedulableQueue;
    private final ConcurrentHashMap<String, Schedulable> schedulableNameToSchedulable;
    private int weight;
    private int minShare;
    private int runningTasks;
    private int priority;
    private int stageId;
    private String name;
    private Pool parent;
    private SchedulingAlgorithm taskSetSchedulingAlgorithm;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public String poolName() {
        return this.poolName;
    }

    @Override
    public Enumeration.Value schedulingMode() {
        return this.schedulingMode;
    }

    @Override
    public ConcurrentLinkedQueue<Schedulable> schedulableQueue() {
        return this.schedulableQueue;
    }

    public ConcurrentHashMap<String, Schedulable> schedulableNameToSchedulable() {
        return this.schedulableNameToSchedulable;
    }

    @Override
    public int weight() {
        return this.weight;
    }

    public void weight_$eq(int x$1) {
        this.weight = x$1;
    }

    @Override
    public int minShare() {
        return this.minShare;
    }

    public void minShare_$eq(int x$1) {
        this.minShare = x$1;
    }

    @Override
    public int runningTasks() {
        return this.runningTasks;
    }

    public void runningTasks_$eq(int x$1) {
        this.runningTasks = x$1;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    public void priority_$eq(int x$1) {
        this.priority = x$1;
    }

    @Override
    public int stageId() {
        return this.stageId;
    }

    public void stageId_$eq(int x$1) {
        this.stageId = x$1;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void name_$eq(String x$1) {
        this.name = x$1;
    }

    @Override
    public Pool parent() {
        return this.parent;
    }

    @Override
    public void parent_$eq(Pool x$1) {
        this.parent = x$1;
    }

    public SchedulingAlgorithm taskSetSchedulingAlgorithm() {
        return this.taskSetSchedulingAlgorithm;
    }

    public void taskSetSchedulingAlgorithm_$eq(SchedulingAlgorithm x$1) {
        this.taskSetSchedulingAlgorithm = x$1;
    }

    @Override
    public void addSchedulable(Schedulable schedulable) {
        Predef$.MODULE$.require(schedulable != null);
        this.schedulableQueue().add(schedulable);
        this.schedulableNameToSchedulable().put(schedulable.name(), schedulable);
        schedulable.parent_$eq(this);
    }

    @Override
    public void removeSchedulable(Schedulable schedulable) {
        this.schedulableQueue().remove(schedulable);
        this.schedulableNameToSchedulable().remove(schedulable.name());
    }

    @Override
    public Schedulable getSchedulableByName(String schedulableName) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            Schedulable schedulable;
            Object object = new Object();
            try {
                if (this.schedulableNameToSchedulable().containsKey(schedulableName)) {
                    return this.schedulableNameToSchedulable().get(schedulableName);
                }
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.schedulableQueue()).asScala()).foreach((Function1)new Serializable(this, schedulableName, object){
                    public static final long serialVersionUID = 0L;
                    private final String schedulableName$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(Schedulable schedulable) {
                        Schedulable sched = schedulable.getSchedulableByName(this.schedulableName$1);
                        if (sched == null) {
                            return;
                        }
                        throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)sched);
                    }
                    {
                        this.schedulableName$1 = schedulableName$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                schedulable = null;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                schedulable = (Schedulable)nonLocalReturnControl2.value();
            }
            return schedulable;
        }
        throw nonLocalReturnControl2;
    }

    @Override
    public void executorLost(String executorId, String host, ExecutorLossReason reason) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.schedulableQueue()).asScala()).foreach((Function1)new Serializable(this, executorId, host, reason){
            public static final long serialVersionUID = 0L;
            private final String executorId$1;
            private final String host$1;
            private final ExecutorLossReason reason$1;

            public final void apply(Schedulable x$1) {
                x$1.executorLost(this.executorId$1, this.host$1, this.reason$1);
            }
            {
                this.executorId$1 = executorId$1;
                this.host$1 = host$1;
                this.reason$1 = reason$1;
            }
        });
    }

    @Override
    public boolean checkSpeculatableTasks() {
        BooleanRef shouldRevive = BooleanRef.create((boolean)false);
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.schedulableQueue()).asScala()).foreach((Function1)new Serializable(this, shouldRevive){
            public static final long serialVersionUID = 0L;
            private final BooleanRef shouldRevive$1;

            public final void apply(Schedulable schedulable) {
                this.shouldRevive$1.elem |= schedulable.checkSpeculatableTasks();
            }
            {
                this.shouldRevive$1 = shouldRevive$1;
            }
        });
        return shouldRevive.elem;
    }

    @Override
    public ArrayBuffer<TaskSetManager> getSortedTaskSetQueue() {
        ObjectRef sortedTaskSetQueue = ObjectRef.create((Object)new ArrayBuffer());
        SchedulingAlgorithm schedulingAlgorithm = this.taskSetSchedulingAlgorithm();
        Seq sortedSchedulableQueue = (Seq)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.schedulableQueue()).asScala()).toSeq().sortWith((Function2)new Serializable(this, schedulingAlgorithm){
            public static final long serialVersionUID = 0L;
            private final SchedulingAlgorithm eta$0$1$1;

            public final boolean apply(Schedulable s1, Schedulable s2) {
                return this.eta$0$1$1.comparator(s1, s2);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
        sortedSchedulableQueue.foreach((Function1)new Serializable(this, sortedTaskSetQueue){
            public static final long serialVersionUID = 0L;
            private final ObjectRef sortedTaskSetQueue$1;

            public final ArrayBuffer<TaskSetManager> apply(Schedulable schedulable) {
                return ((ArrayBuffer)this.sortedTaskSetQueue$1.elem).$plus$plus$eq(schedulable.getSortedTaskSetQueue());
            }
            {
                this.sortedTaskSetQueue$1 = sortedTaskSetQueue$1;
            }
        });
        return (ArrayBuffer)sortedTaskSetQueue.elem;
    }

    public void increaseRunningTasks(int taskNum) {
        this.runningTasks_$eq(this.runningTasks() + taskNum);
        if (this.parent() != null) {
            this.parent().increaseRunningTasks(taskNum);
        }
    }

    public void decreaseRunningTasks(int taskNum) {
        this.runningTasks_$eq(this.runningTasks() - taskNum);
        if (this.parent() != null) {
            this.parent().decreaseRunningTasks(taskNum);
        }
    }

    public Pool(String poolName, Enumeration.Value schedulingMode, int initMinShare, int initWeight) {
        block4: {
            SchedulingAlgorithm schedulingAlgorithm;
            block3: {
                Enumeration.Value value2;
                block2: {
                    this.poolName = poolName;
                    this.schedulingMode = schedulingMode;
                    Logging$class.$init$(this);
                    this.schedulableQueue = new ConcurrentLinkedQueue();
                    this.schedulableNameToSchedulable = new ConcurrentHashMap();
                    this.weight = initWeight;
                    this.minShare = initMinShare;
                    this.runningTasks = 0;
                    this.priority = 0;
                    this.stageId = -1;
                    this.name = poolName;
                    this.parent = null;
                    value2 = schedulingMode;
                    Enumeration.Value value3 = SchedulingMode$.MODULE$.FAIR();
                    Enumeration.Value value4 = value2;
                    if (value3 != null ? !value3.equals(value4) : value4 != null) break block2;
                    schedulingAlgorithm = new FairSchedulingAlgorithm();
                    break block3;
                }
                Enumeration.Value value5 = SchedulingMode$.MODULE$.FIFO();
                Enumeration.Value value6 = value2;
                if (value5 != null ? !value5.equals(value6) : value6 != null) break block4;
                schedulingAlgorithm = new FIFOSchedulingAlgorithm();
            }
            this.taskSetSchedulingAlgorithm = schedulingAlgorithm;
            return;
        }
        String msg = "Unsupported scheduling mode: $schedulingMode. Use FAIR or FIFO instead.";
        throw new IllegalArgumentException(msg);
    }
}

