/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rpc.netty;

import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.client.StreamCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientBootstrap;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.sasl.SaslClientBootstrap;
import org.apache.spark.network.sasl.SaslServerBootstrap;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.NoOpRpcHandler;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.server.TransportServerBootstrap;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointAddress;
import org.apache.spark.rpc.RpcEndpointAddress$;
import org.apache.spark.rpc.RpcEndpointNotFoundException;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcEnvFileServer;
import org.apache.spark.rpc.RpcEnvStoppedException;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.rpc.netty.Dispatcher;
import org.apache.spark.rpc.netty.NettyRpcEndpointRef;
import org.apache.spark.rpc.netty.NettyRpcEnv$;
import org.apache.spark.rpc.netty.NettyRpcHandler;
import org.apache.spark.rpc.netty.NettyStreamManager;
import org.apache.spark.rpc.netty.OneWayOutboxMessage;
import org.apache.spark.rpc.netty.Outbox;
import org.apache.spark.rpc.netty.OutboxMessage;
import org.apache.spark.rpc.netty.RequestMessage;
import org.apache.spark.rpc.netty.RpcEndpointVerifier;
import org.apache.spark.rpc.netty.RpcEndpointVerifier$;
import org.apache.spark.rpc.netty.RpcFailure;
import org.apache.spark.rpc.netty.RpcOutboxMessage;
import org.apache.spark.serializer.JavaSerializerInstance;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r\u001dh!B\u0001\u0003\u0001\ta!a\u0003(fiRL(\u000b]2F]ZT!a\u0001\u0003\u0002\u000b9,G\u000f^=\u000b\u0005\u00151\u0011a\u0001:qG*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bE\u0001\"AD\b\u000e\u0003\u0011I!\u0001\u0005\u0003\u0003\rI\u00038-\u00128w!\t\u0011R#D\u0001\u0014\u0015\t!b!\u0001\u0005j]R,'O\\1m\u0013\t12CA\u0004M_\u001e<\u0017N\\4\t\u0011a\u0001!Q1A\u0005\u0002i\tAaY8oM\u000e\u0001Q#A\u000e\u0011\u0005qiR\"\u0001\u0004\n\u0005y1!!C*qCJ\\7i\u001c8g\u0011!\u0001\u0003A!A!\u0002\u0013Y\u0012!B2p]\u001a\u0004\u0003\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002-)\fg/Y*fe&\fG.\u001b>fe&s7\u000f^1oG\u0016\u0004\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0004\u0002\u0015M,'/[1mSj,'/\u0003\u0002)K\t1\"*\u0019<b'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018J\\:uC:\u001cW\r\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0003\u0011Awn\u001d;\u0011\u00051\u0012dBA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er\u0013A\u0002)sK\u0012,g-\u0003\u00024i\t11\u000b\u001e:j]\u001eT!!\r\u0018\t\u0011Y\u0002!\u0011!Q\u0001\n]\nqb]3dkJLG/_'b]\u0006<WM\u001d\t\u00039aJ!!\u000f\u0004\u0003\u001fM+7-\u001e:jifl\u0015M\\1hKJDQa\u000f\u0001\u0005\u0002q\na\u0001P5oSRtD#B\u001f@\u0001\u0006\u0013\u0005C\u0001 \u0001\u001b\u0005\u0011\u0001\"\u0002\r;\u0001\u0004Y\u0002\"\u0002\u0012;\u0001\u0004\u0019\u0003\"\u0002\u0016;\u0001\u0004Y\u0003\"\u0002\u001c;\u0001\u00049\u0004\u0002\u0003#\u0001\u0005\u0004%\tAA#\u0002\u001bQ\u0014\u0018M\\:q_J$8i\u001c8g+\u00051\u0005CA$M\u001b\u0005A%BA%K\u0003\u0011)H/\u001b7\u000b\u0005-3\u0011a\u00028fi^|'o[\u0005\u0003\u001b\"\u0013Q\u0002\u0016:b]N\u0004xN\u001d;D_:4\u0007BB(\u0001A\u0003%a)\u0001\bue\u0006t7\u000f]8si\u000e{gN\u001a\u0011\t\u000fE\u0003!\u0019!C\u0005%\u0006QA-[:qCR\u001c\u0007.\u001a:\u0016\u0003M\u0003\"A\u0010+\n\u0005U\u0013!A\u0003#jgB\fGo\u00195fe\"1q\u000b\u0001Q\u0001\nM\u000b1\u0002Z5ta\u0006$8\r[3sA!9\u0011\f\u0001b\u0001\n\u0013Q\u0016!D:ue\u0016\fW.T1oC\u001e,'/F\u0001\\!\tqD,\u0003\u0002^\u0005\t\u0011b*\u001a;usN#(/Z1n\u001b\u0006t\u0017mZ3s\u0011\u0019y\u0006\u0001)A\u00057\u0006q1\u000f\u001e:fC6l\u0015M\\1hKJ\u0004\u0003bB1\u0001\u0005\u0004%IAY\u0001\u0011iJ\fgn\u001d9peR\u001cuN\u001c;fqR,\u0012a\u0019\t\u0003I\u0016l\u0011AS\u0005\u0003M*\u0013\u0001\u0003\u0016:b]N\u0004xN\u001d;D_:$X\r\u001f;\t\r!\u0004\u0001\u0015!\u0003d\u0003E!(/\u00198ta>\u0014HoQ8oi\u0016DH\u000f\t\u0005\u0006U\u0002!Ia[\u0001\u0017GJ,\u0017\r^3DY&,g\u000e\u001e\"p_R\u001cHO]1qgR\tA\u000eE\u0002ncNl\u0011A\u001c\u0006\u0003\u0013>T\u0011\u0001]\u0001\u0005U\u00064\u0018-\u0003\u0002s]\n!A*[:u!\t!x/D\u0001v\u0015\t1(*\u0001\u0004dY&,g\u000e^\u0005\u0003qV\u0014\u0001\u0004\u0016:b]N\u0004xN\u001d;DY&,g\u000e\u001e\"p_R\u001cHO]1q\u0011\u001dQ\bA1A\u0005\nm\fQb\u00197jK:$h)Y2u_JLX#\u0001?\u0011\u0005Ql\u0018B\u0001@v\u0005Y!&/\u00198ta>\u0014Ho\u00117jK:$h)Y2u_JL\bbBA\u0001\u0001\u0001\u0006I\u0001`\u0001\u000fG2LWM\u001c;GC\u000e$xN]=!\u0011)\t)\u0001\u0001a\u0001\u0002\u0004%Ia_\u0001\u0014M&dW\rR8x]2|\u0017\r\u001a$bGR|'/\u001f\u0005\f\u0003\u0013\u0001\u0001\u0019!a\u0001\n\u0013\tY!A\fgS2,Gi\\<oY>\fGMR1di>\u0014\u0018p\u0018\u0013fcR!\u0011QBA\n!\ri\u0013qB\u0005\u0004\u0003#q#\u0001B+oSRD\u0011\"!\u0006\u0002\b\u0005\u0005\t\u0019\u0001?\u0002\u0007a$\u0013\u0007C\u0004\u0002\u001a\u0001\u0001\u000b\u0015\u0002?\u0002)\u0019LG.\u001a#po:dw.\u00193GC\u000e$xN]=!Q\u0011\t9\"!\b\u0011\u00075\ny\"C\u0002\u0002\"9\u0012\u0001B^8mCRLG.\u001a\u0005\n\u0003K\u0001!\u0019!C\u0001\u0003O\t\u0001\u0003^5nK>,HoU2iK\u0012,H.\u001a:\u0016\u0005\u0005%\u0002\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=b.\u0001\u0006d_:\u001cWO\u001d:f]RLA!a\r\u0002.\tA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\u0011\u0005]\u0002\u0001)A\u0005\u0003S\t\u0011\u0003^5nK>,HoU2iK\u0012,H.\u001a:!\u0011)\tY\u0004\u0001b\u0001\n\u0003\u0011\u0011QH\u0001\u0019G2LWM\u001c;D_:tWm\u0019;j_:,\u00050Z2vi>\u0014XCAA !\u0011\tY#!\u0011\n\t\u0005\r\u0013Q\u0006\u0002\u0013)\"\u0014X-\u00193Q_>dW\t_3dkR|'\u000f\u0003\u0005\u0002H\u0001\u0001\u000b\u0011BA \u0003e\u0019G.[3oi\u000e{gN\\3di&|g.\u0012=fGV$xN\u001d\u0011\t\u0017\u0005-\u0003\u00011AA\u0002\u0013%\u0011QJ\u0001\u0007g\u0016\u0014h/\u001a:\u0016\u0005\u0005=\u0003\u0003BA)\u0003+j!!a\u0015\u000b\u0007\u0005-#*\u0003\u0003\u0002X\u0005M#a\u0004+sC:\u001c\bo\u001c:u'\u0016\u0014h/\u001a:\t\u0017\u0005m\u0003\u00011AA\u0002\u0013%\u0011QL\u0001\u000bg\u0016\u0014h/\u001a:`I\u0015\fH\u0003BA\u0007\u0003?B!\"!\u0006\u0002Z\u0005\u0005\t\u0019AA(\u0011!\t\u0019\u0007\u0001Q!\n\u0005=\u0013aB:feZ,'\u000f\t\u0015\u0005\u0003C\ni\u0002C\u0005\u0002j\u0001\u0011\r\u0011\"\u0003\u0002l\u000591\u000f^8qa\u0016$WCAA7!\u0011\ty'!\u001e\u000e\u0005\u0005E$\u0002BA:\u0003[\ta!\u0019;p[&\u001c\u0017\u0002BA<\u0003c\u0012Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007\u0002CA>\u0001\u0001\u0006I!!\u001c\u0002\u0011M$x\u000e\u001d9fI\u0002B\u0011\"a \u0001\u0005\u0004%I!!!\u0002\u0011=,HOY8yKN,\"!a!\u0011\u0011\u0005-\u0012QQAE\u0003\u001fKA!a\"\u0002.\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u00079\tY)C\u0002\u0002\u000e\u0012\u0011!B\u00159d\u0003\u0012$'/Z:t!\rq\u0014\u0011S\u0005\u0004\u0003'\u0013!AB(vi\n|\u0007\u0010\u0003\u0005\u0002\u0018\u0002\u0001\u000b\u0011BAB\u0003%yW\u000f\u001e2pq\u0016\u001c\b\u0005\u0003\u0005\u0002\u001c\u0002!\tAAAO\u00031\u0011X-\\8wK>+HOY8y)\u0011\ti!a(\t\u0011\u0005\u0005\u0016\u0011\u0014a\u0001\u0003\u0013\u000bq!\u00193ee\u0016\u001c8\u000fC\u0004\u0002&\u0002!\t!a*\u0002\u0017M$\u0018M\u001d;TKJ4XM\u001d\u000b\u0005\u0003\u001b\tI\u000b\u0003\u0005\u0002,\u0006\r\u0006\u0019AAW\u0003\u0011\u0001xN\u001d;\u0011\u00075\ny+C\u0002\u00022:\u00121!\u00138u\u0011)\t\t\u000b\u0001EC\u0002\u0013\u0005\u0013QW\u000b\u0003\u0003\u0013C!\"!/\u0001\u0011\u0003\u0005\u000b\u0015BAE\u0003!\tG\r\u001a:fgN\u0004\u0003\u0006BA\\\u0003{\u0003B!a0\u0002J6\u0011\u0011\u0011\u0019\u0006\u0005\u0003\u0007\f)-\u0001\u0006b]:|G/\u0019;j_:T!!a2\u0002\u000b)\fg/\u0019=\n\t\u0005-\u0017\u0011\u0019\u0002\t\u001dVdG.\u00192mK\"9\u0011q\u001a\u0001\u0005B\u0005E\u0017!D:fiV\u0004XI\u001c3q_&tG\u000f\u0006\u0004\u0002T\u0006e\u0017Q\u001c\t\u0004\u001d\u0005U\u0017bAAl\t\tq!\u000b]2F]\u0012\u0004x.\u001b8u%\u00164\u0007bBAn\u0003\u001b\u0004\raK\u0001\u0005]\u0006lW\r\u0003\u0005\u0002`\u00065\u0007\u0019AAq\u0003!)g\u000e\u001a9pS:$\bc\u0001\b\u0002d&\u0019\u0011Q\u001d\u0003\u0003\u0017I\u00038-\u00128ea>Lg\u000e\u001e\u0005\b\u0003S\u0004A\u0011AAv\u0003i\t7/\u001f8d'\u0016$X\u000f]#oIB|\u0017N\u001c;SK\u001a\u0014\u00150\u0016*J)\u0011\ti/a>\u0011\r\u0005=\u00181_Aj\u001b\t\t\tPC\u0002\u000209JA!!>\u0002r\n1a)\u001e;ve\u0016Dq!!?\u0002h\u0002\u00071&A\u0002ve&Dq!!@\u0001\t\u0003\ny0\u0001\u0003ti>\u0004H\u0003BA\u0007\u0005\u0003A\u0001Ba\u0001\u0002|\u0002\u0007\u00111[\u0001\fK:$\u0007o\\5oiJ+g\rC\u0004\u0003\b\u0001!IA!\u0003\u0002\u0019A|7\u000f\u001e+p\u001fV$(m\u001c=\u0015\r\u00055!1\u0002B\u000b\u0011!\u0011iA!\u0002A\u0002\t=\u0011\u0001\u0003:fG\u0016Lg/\u001a:\u0011\u0007y\u0012\t\"C\u0002\u0003\u0014\t\u00111CT3uif\u0014\u0006oY#oIB|\u0017N\u001c;SK\u001aD\u0001Ba\u0006\u0003\u0006\u0001\u0007!\u0011D\u0001\b[\u0016\u001c8/Y4f!\rq$1D\u0005\u0004\u0005;\u0011!!D(vi\n|\u00070T3tg\u0006<W\r\u0003\u0005\u0003\"\u0001!\tA\u0001B\u0012\u0003\u0011\u0019XM\u001c3\u0015\t\u00055!Q\u0005\u0005\t\u0005/\u0011y\u00021\u0001\u0003(A\u0019aH!\u000b\n\u0007\t-\"A\u0001\bSKF,Xm\u001d;NKN\u001c\u0018mZ3\t\u0011\t=\u0002\u0001\"\u0001\u0003\u0005c\tAb\u0019:fCR,7\t\\5f]R$BAa\r\u0003:A\u0019AO!\u000e\n\u0007\t]ROA\bUe\u0006t7\u000f]8si\u000ec\u0017.\u001a8u\u0011!\t\tK!\fA\u0002\u0005%\u0005\u0002\u0003B\u001f\u0001\u0011\u0005!Aa\u0010\u0002\u0007\u0005\u001c8.\u0006\u0003\u0003B\t-CC\u0002B\"\u0005[\u0012y\u0007\u0006\u0003\u0003F\tu\u0003CBAx\u0003g\u00149\u0005\u0005\u0003\u0003J\t-C\u0002\u0001\u0003\t\u0005\u001b\u0012YD1\u0001\u0003P\t\tA+\u0005\u0003\u0003R\t]\u0003cA\u0017\u0003T%\u0019!Q\u000b\u0018\u0003\u000f9{G\u000f[5oOB\u0019QF!\u0017\n\u0007\tmcFA\u0002B]fD!Ba\u0018\u0003<\u0005\u0005\t9\u0001B1\u0003))g/\u001b3f]\u000e,G%\r\t\u0007\u0005G\u0012IGa\u0012\u000e\u0005\t\u0015$b\u0001B4]\u00059!/\u001a4mK\u000e$\u0018\u0002\u0002B6\u0005K\u0012\u0001b\u00117bgN$\u0016m\u001a\u0005\t\u0005/\u0011Y\u00041\u0001\u0003(!A!\u0011\u000fB\u001e\u0001\u0004\u0011\u0019(A\u0004uS6,w.\u001e;\u0011\u00079\u0011)(C\u0002\u0003x\u0011\u0011!B\u00159d)&lWm\\;u\u0011!\u0011Y\b\u0001C\u0001\u0005\tu\u0014!C:fe&\fG.\u001b>f)\u0011\u0011yHa#\u0011\t\t\u0005%qQ\u0007\u0003\u0005\u0007S1A!\"p\u0003\rq\u0017n\\\u0005\u0005\u0005\u0013\u0013\u0019I\u0001\u0006CsR,')\u001e4gKJD\u0001B!$\u0003z\u0001\u0007!qK\u0001\bG>tG/\u001a8u\u0011!\u0011\t\n\u0001C\u0001\u0005\tM\u0015a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016,BA!&\u0003\u001cR1!q\u0013BR\u0005K#BA!'\u0003\u001eB!!\u0011\nBN\t!\u0011iEa$C\u0002\t=\u0003B\u0003BP\u0005\u001f\u000b\t\u0011q\u0001\u0003\"\u0006QQM^5eK:\u001cW\r\n\u001a\u0011\r\t\r$\u0011\u000eBM\u0011\u001d1(q\u0012a\u0001\u0005gA\u0001Ba*\u0003\u0010\u0002\u0007!qP\u0001\u0006Ef$Xm\u001d\u0005\b\u0005\u0007\u0001A\u0011\tBV)\u0011\t\u0019N!,\t\u0011\u0005}'\u0011\u0016a\u0001\u0003CDqA!-\u0001\t\u0003\u0012\u0019,\u0001\u0005tQV$Hm\\<o)\t\ti\u0001C\u0004\u00038\u0002!\tEa-\u0002!\u0005<\u0018-\u001b;UKJl\u0017N\\1uS>t\u0007b\u0002B^\u0001\u0011%!1W\u0001\bG2,\u0017M\\;q\u0011\u001d\u0011\t\n\u0001C!\u0005\u007f+BA!1\u0003FR!!1\u0019Bd!\u0011\u0011IE!2\u0005\u0011\t5#Q\u0018b\u0001\u0005\u001fB\u0001B!3\u0003>\u0002\u0007!1Z\u0001\u0016I\u0016\u001cXM]5bY&T\u0018\r^5p]\u0006\u001bG/[8o!\u0015i#Q\u001aBb\u0013\r\u0011yM\f\u0002\n\rVt7\r^5p]BBqAa5\u0001\t\u0003\u0012).\u0001\u0006gS2,7+\u001a:wKJ,\"Aa6\u0011\u00079\u0011I.C\u0002\u0003\\\u0012\u0011\u0001C\u00159d\u000b:4h)\u001b7f'\u0016\u0014h/\u001a:\t\u000f\t}\u0007\u0001\"\u0011\u0003b\u0006Yq\u000e]3o\u0007\"\fgN\\3m)\u0011\u0011\u0019Oa<\u0011\t\t\u0015(1^\u0007\u0003\u0005OTAA!;\u0003\u0004\u0006A1\r[1o]\u0016d7/\u0003\u0003\u0003n\n\u001d(a\u0005*fC\u0012\f'\r\\3CsR,7\t[1o]\u0016d\u0007bBA}\u0005;\u0004\ra\u000b\u0005\b\u0005g\u0004A\u0011\u0002B{\u00039!wn\u001e8m_\u0006$7\t\\5f]R$bAa\r\u0003x\ne\bB\u0002\u0016\u0003r\u0002\u00071\u0006\u0003\u0005\u0002,\nE\b\u0019AAW\r\u0019\u0011i\u0010\u0001\u0003\u0003\u0000\n\u0019b)\u001b7f\t><h\u000e\\8bI\u000eC\u0017M\u001c8fYN1!1`B\u0001\u0005G\u0004Baa\u0001\u0004\n5\u00111Q\u0001\u0006\u0004\u0007\u000fy\u0017\u0001\u00027b]\u001eLAaa\u0003\u0004\u0006\t1qJ\u00196fGRD1ba\u0004\u0003|\n\u0005\t\u0015!\u0003\u0003d\u000611o\\;sG\u0016Dqa\u000fB~\t\u0003\u0019\u0019\u0002\u0006\u0003\u0004\u0016\re\u0001\u0003BB\f\u0005wl\u0011\u0001\u0001\u0005\t\u0007\u001f\u0019\t\u00021\u0001\u0003d\"a1Q\u0004B~\u0001\u0004\u0005\r\u0011\"\u0003\u0004 \u0005)QM\u001d:peV\u00111\u0011\u0005\t\u0005\u0007G\u0019\u0019D\u0004\u0003\u0004&\r=b\u0002BB\u0014\u0007[i!a!\u000b\u000b\u0007\r-\u0012$\u0001\u0004=e>|GOP\u0005\u0002_%\u00191\u0011\u0007\u0018\u0002\u000fA\f7m[1hK&!1QGB\u001c\u0005%!\u0006N]8xC\ndWMC\u0002\u000429BAba\u000f\u0003|\u0002\u0007\t\u0019!C\u0005\u0007{\t\u0011\"\u001a:s_J|F%Z9\u0015\t\u000551q\b\u0005\u000b\u0003+\u0019I$!AA\u0002\r\u0005\u0002\"CB\"\u0005w\u0004\u000b\u0015BB\u0011\u0003\u0019)'O]8sA!\"1\u0011IA\u000f\u0011!\u0019IEa?\u0005\u0002\r-\u0013\u0001C:fi\u0016\u0013(o\u001c:\u0015\t\u000551Q\n\u0005\t\u0007\u001f\u001a9\u00051\u0001\u0004\"\u0005\tQ\r\u0003\u0005\u0004T\tmH\u0011IB+\u0003\u0011\u0011X-\u00193\u0015\t\u000556q\u000b\u0005\t\u00073\u001a\t\u00061\u0001\u0003\u0000\u0005\u0019Am\u001d;\t\u0011\ru#1 C!\u0005g\u000bQa\u00197pg\u0016D\u0001b!\u0019\u0003|\u0012\u000531M\u0001\u0007SN|\u0005/\u001a8\u0015\u0005\r\u0015\u0004cA\u0017\u0004h%\u00191\u0011\u000e\u0018\u0003\u000f\t{w\u000e\\3b]\u001a11Q\u000e\u0001\u0005\u0007_\u0012ACR5mK\u0012{wO\u001c7pC\u0012\u001c\u0015\r\u001c7cC\u000e\\7CBB6\u0007\u0003\u0019\t\bE\u0002u\u0007gJ1a!\u001ev\u00059\u0019FO]3b[\u000e\u000bG\u000e\u001c2bG.D1b!\u001f\u0004l\t\u0005\t\u0015!\u0003\u0004|\u0005!1/\u001b8l!\u0011\u0011)o! \n\t\r}$q\u001d\u0002\u0014/JLG/\u00192mK\nKH/Z\"iC:tW\r\u001c\u0005\f\u0007\u001f\u0019YG!A!\u0002\u0013\u0019)\u0002\u0003\u0006w\u0007W\u0012\t\u0011)A\u0005\u0005gAqaOB6\t\u0003\u00199\t\u0006\u0005\u0004\n\u000e-5QRBH!\u0011\u00199ba\u001b\t\u0011\re4Q\u0011a\u0001\u0007wB\u0001ba\u0004\u0004\u0006\u0002\u00071Q\u0003\u0005\bm\u000e\u0015\u0005\u0019\u0001B\u001a\u0011!\u0019\u0019ja\u001b\u0005B\rU\u0015AB8o\t\u0006$\u0018\r\u0006\u0004\u0002\u000e\r]51\u0014\u0005\b\u00073\u001b\t\n1\u0001,\u0003!\u0019HO]3b[&#\u0007\u0002CBO\u0007#\u0003\rAa \u0002\u0007\t,h\r\u0003\u0005\u0004\"\u000e-D\u0011IBR\u0003)ygnQ8na2,G/\u001a\u000b\u0005\u0003\u001b\u0019)\u000bC\u0004\u0004\u001a\u000e}\u0005\u0019A\u0016\t\u0011\r%61\u000eC!\u0007W\u000b\u0011b\u001c8GC&dWO]3\u0015\r\u000551QVBX\u0011\u001d\u0019Ija*A\u0002-B\u0001b!-\u0004(\u0002\u00071\u0011E\u0001\u0006G\u0006,8/Z\u0004\t\u0007k\u0013\u0001\u0012\u0001\u0002\u00048\u0006Ya*\u001a;usJ\u00038-\u00128w!\rq4\u0011\u0018\u0004\b\u0003\tA\tAAB^'\u0015\u0019Il!0\u0012!\ri3qX\u0005\u0004\u0007\u0003t#AB!osJ+g\rC\u0004<\u0007s#\ta!2\u0015\u0005\r]\u0006bCBe\u0007s\u0013\r\u0011\"\u0001\u0003\u0007\u0017\f!bY;se\u0016tG/\u00128w+\t\u0019i\rE\u0003\u0004P\u000eMW(\u0004\u0002\u0004R*\u0011\u0011JL\u0005\u0005\u0007+\u001c\tNA\bEs:\fW.[2WCJL\u0017M\u00197f\u0011%\u0019In!/!\u0002\u0013\u0019i-A\u0006dkJ\u0014XM\u001c;F]Z\u0004\u0003bCBo\u0007s\u0013\r\u0011\"\u0001\u0003\u0007?\fQbY;se\u0016tGo\u00117jK:$XCABq!\u0019\u0019yma5\u00034!I1Q]B]A\u0003%1\u0011]\u0001\u000fGV\u0014(/\u001a8u\u00072LWM\u001c;!\u0001")
public class NettyRpcEnv
extends RpcEnv
implements Logging {
    private final SparkConf conf;
    public final JavaSerializerInstance org$apache$spark$rpc$netty$NettyRpcEnv$$javaSerializerInstance;
    private final String host;
    private final SecurityManager securityManager;
    private final TransportConf transportConf;
    private final Dispatcher dispatcher;
    private final NettyStreamManager streamManager;
    private final TransportContext transportContext;
    private final TransportClientFactory clientFactory;
    private volatile TransportClientFactory fileDownloadFactory;
    private final ScheduledExecutorService timeoutScheduler;
    private final ThreadPoolExecutor clientConnectionExecutor;
    private volatile TransportServer server;
    private final AtomicBoolean stopped;
    private final ConcurrentHashMap<RpcAddress, Outbox> outboxes;
    @Nullable
    private RpcAddress address;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    private RpcAddress address$lzycompute() {
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            if (!this.bitmap$0) {
                this.address = this.server() == null ? null : new RpcAddress(this.host, this.server().getPort());
                this.bitmap$0 = true;
            }
            return this.address;
        }
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public SparkConf conf() {
        return this.conf;
    }

    public TransportConf transportConf() {
        return this.transportConf;
    }

    private Dispatcher dispatcher() {
        return this.dispatcher;
    }

    private NettyStreamManager streamManager() {
        return this.streamManager;
    }

    private TransportContext transportContext() {
        return this.transportContext;
    }

    private List<TransportClientBootstrap> createClientBootstraps() {
        return this.securityManager.isAuthenticationEnabled() ? Arrays.asList((Object[])new TransportClientBootstrap[]{new SaslClientBootstrap(this.transportConf(), "", (SecretKeyHolder)this.securityManager, this.securityManager.isSaslEncryptionEnabled())}) : Collections.emptyList();
    }

    private TransportClientFactory clientFactory() {
        return this.clientFactory;
    }

    private TransportClientFactory fileDownloadFactory() {
        return this.fileDownloadFactory;
    }

    private void fileDownloadFactory_$eq(TransportClientFactory x$1) {
        this.fileDownloadFactory = x$1;
    }

    public ScheduledExecutorService timeoutScheduler() {
        return this.timeoutScheduler;
    }

    public ThreadPoolExecutor clientConnectionExecutor() {
        return this.clientConnectionExecutor;
    }

    private TransportServer server() {
        return this.server;
    }

    private void server_$eq(TransportServer x$1) {
        this.server = x$1;
    }

    private AtomicBoolean stopped() {
        return this.stopped;
    }

    private ConcurrentHashMap<RpcAddress, Outbox> outboxes() {
        return this.outboxes;
    }

    public void removeOutbox(RpcAddress address) {
        Outbox outbox = this.outboxes().remove(address);
        if (outbox != null) {
            outbox.stop();
        }
    }

    public void startServer(int port) {
        List bootstraps = this.securityManager.isAuthenticationEnabled() ? Arrays.asList((Object[])new TransportServerBootstrap[]{new SaslServerBootstrap(this.transportConf(), (SecretKeyHolder)this.securityManager)}) : Collections.emptyList();
        this.server_$eq(this.transportContext().createServer(this.host, port, bootstraps));
        this.dispatcher().registerRpcEndpoint(RpcEndpointVerifier$.MODULE$.NAME(), new RpcEndpointVerifier(this, this.dispatcher()));
    }

    @Override
    public RpcAddress address() {
        return this.bitmap$0 ? this.address : this.address$lzycompute();
    }

    @Override
    public RpcEndpointRef setupEndpoint(String name, RpcEndpoint endpoint) {
        return this.dispatcher().registerRpcEndpoint(name, endpoint);
    }

    @Override
    public Future<RpcEndpointRef> asyncSetupEndpointRefByURI(String uri) {
        RpcEndpointAddress addr = RpcEndpointAddress$.MODULE$.apply(uri);
        NettyRpcEndpointRef endpointRef = new NettyRpcEndpointRef(this.conf(), addr, this);
        NettyRpcEndpointRef verifier = new NettyRpcEndpointRef(this.conf(), new RpcEndpointAddress(addr.rpcAddress(), RpcEndpointVerifier$.MODULE$.NAME()), this);
        return verifier.ask(new RpcEndpointVerifier.CheckExistence(endpointRef.name()), ClassTag$.MODULE$.Boolean()).flatMap((Function1)new Serializable(this, uri, endpointRef){
            public static final long serialVersionUID = 0L;
            private final String uri$1;
            private final NettyRpcEndpointRef endpointRef$1;

            public final Future<NettyRpcEndpointRef> apply(boolean find) {
                return find ? Future$.MODULE$.successful((Object)this.endpointRef$1) : Future$.MODULE$.failed((Throwable)new RpcEndpointNotFoundException(this.uri$1));
            }
            {
                this.uri$1 = uri$1;
                this.endpointRef$1 = endpointRef$1;
            }
        }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    @Override
    public void stop(RpcEndpointRef endpointRef) {
        Predef$.MODULE$.require(endpointRef instanceof NettyRpcEndpointRef);
        this.dispatcher().stop(endpointRef);
    }

    private void postToOutbox(NettyRpcEndpointRef receiver, OutboxMessage message) {
        if (receiver.client() == null) {
            Outbox targetOutbox;
            Outbox outbox;
            Predef$.MODULE$.require(receiver.address() != null, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Cannot send message to client endpoint with no listen address.";
                }
            });
            Outbox outbox2 = this.outboxes().get(receiver.address());
            if (outbox2 == null) {
                Outbox newOutbox = new Outbox(this, receiver.address());
                Outbox oldOutbox = this.outboxes().putIfAbsent(receiver.address(), newOutbox);
                outbox = oldOutbox == null ? newOutbox : oldOutbox;
            } else {
                outbox = targetOutbox = outbox2;
            }
            if (this.stopped().get()) {
                this.outboxes().remove(receiver.address());
                targetOutbox.stop();
            } else {
                targetOutbox.send(message);
            }
        } else {
            message.sendWith(receiver.client());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(RequestMessage message) {
        RpcAddress remoteAddr;
        RpcAddress rpcAddress = remoteAddr = message.receiver().address();
        RpcAddress rpcAddress2 = this.address();
        if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
            try {
                this.dispatcher().postOneWayMessage(message);
                return;
            }
            catch (RpcEnvStoppedException rpcEnvStoppedException) {
                this.logWarning((Function0<String>)new Serializable(this, rpcEnvStoppedException){
                    public static final long serialVersionUID = 0L;
                    private final RpcEnvStoppedException e$1;

                    public final String apply() {
                        return this.e$1.getMessage();
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
                return;
            }
        } else {
            this.postToOutbox(message.receiver(), new OneWayOutboxMessage(this.serialize(message)));
            return;
        }
    }

    public TransportClient createClient(RpcAddress address) {
        return this.clientFactory().createClient(address.host(), address.port());
    }

    public <T> Future<T> ask(RequestMessage message, RpcTimeout timeout, ClassTag<T> evidence$1) {
        Promise promise = Promise$.MODULE$.apply();
        RpcAddress remoteAddr = message.receiver().address();
        try {
            RpcAddress rpcAddress = remoteAddr;
            RpcAddress rpcAddress2 = this.address();
            if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
                Promise p = Promise$.MODULE$.apply();
                p.future().onComplete((Function1)new Serializable(this, promise){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ NettyRpcEnv $outer;
                    private final Promise promise$1;

                    public final void apply(Try<Object> x0$1) {
                        Try<Object> try_;
                        block4: {
                            block3: {
                                block2: {
                                    try_ = x0$1;
                                    if (!(try_ instanceof Success)) break block2;
                                    Success success = (Success)try_;
                                    Object response = success.value();
                                    this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$onSuccess$1(response, this.promise$1);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                if (!(try_ instanceof Failure)) break block4;
                                Failure failure = (Failure)try_;
                                Throwable e = failure.exception();
                                this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(e, this.promise$1);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            return;
                        }
                        throw new MatchError(try_);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.promise$1 = promise$1;
                    }
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
                this.dispatcher().postLocalMessage(message, (Promise<Object>)p);
            } else {
                RpcOutboxMessage rpcMessage = new RpcOutboxMessage(this.serialize(message), (Function1<Throwable, BoxedUnit>)new Serializable(this, promise){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ NettyRpcEnv $outer;
                    private final Promise promise$1;

                    public final void apply(Throwable e) {
                        this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(e, this.promise$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.promise$1 = promise$1;
                    }
                }, (Function2<TransportClient, ByteBuffer, BoxedUnit>)new Serializable(this, promise){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ NettyRpcEnv $outer;
                    private final Promise promise$1;

                    public final void apply(TransportClient client, ByteBuffer response) {
                        this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$onSuccess$1(this.$outer.deserialize(client, response, ClassTag$.MODULE$.Any()), this.promise$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.promise$1 = promise$1;
                    }
                });
                this.postToOutbox(message.receiver(), rpcMessage);
                promise.future().onFailure((PartialFunction)new Serializable(this, rpcMessage){
                    public static final long serialVersionUID = 0L;
                    private final RpcOutboxMessage rpcMessage$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        BoxedUnit boxedUnit;
                        A1 A1 = x1;
                        if (A1 instanceof TimeoutException) {
                            this.rpcMessage$1.onTimeout();
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return (B1)boxedUnit;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = throwable instanceof TimeoutException ? true : true;
                        return bl;
                    }
                    {
                        this.rpcMessage$1 = rpcMessage$1;
                    }
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            }
            ScheduledFuture<?> timeoutCancelable = this.timeoutScheduler().schedule(new Runnable(this, timeout, promise){
                private final /* synthetic */ NettyRpcEnv $outer;
                private final RpcTimeout timeout$1;
                private final Promise promise$1;

                public void run() {
                    this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(new TimeoutException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot receive any reply in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timeout$1.duration()}))), this.promise$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timeout$1 = timeout$1;
                    this.promise$1 = promise$1;
                }
            }, timeout.duration().toNanos(), TimeUnit.NANOSECONDS);
            promise.future().onComplete((Function1)new Serializable(this, timeoutCancelable){
                public static final long serialVersionUID = 0L;
                private final ScheduledFuture timeoutCancelable$1;

                public final boolean apply(Try<Object> v) {
                    return this.timeoutCancelable$1.cancel(true);
                }
                {
                    this.timeoutCancelable$1 = timeoutCancelable$1;
                }
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return promise.future().mapTo(evidence$1).recover(timeout.addMessageIfTimeout(), (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    public ByteBuffer serialize(Object content) {
        return this.org$apache$spark$rpc$netty$NettyRpcEnv$$javaSerializerInstance.serialize(content, ClassTag$.MODULE$.Any());
    }

    public <T> T deserialize(TransportClient client, ByteBuffer bytes, ClassTag<T> evidence$2) {
        return (T)NettyRpcEnv$.MODULE$.currentClient().withValue((Object)client, (Function0)new Serializable(this, bytes, evidence$2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyRpcEnv $outer;
            public final ByteBuffer bytes$1;
            public final ClassTag evidence$2$1;

            public final T apply() {
                return this.$outer.deserialize(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deserialize$1 $outer;

                    public final T apply() {
                        return this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$anonfun$$$outer().org$apache$spark$rpc$netty$NettyRpcEnv$$javaSerializerInstance.deserialize(this.$outer.bytes$1, this.$outer.evidence$2$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ NettyRpcEnv org$apache$spark$rpc$netty$NettyRpcEnv$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bytes$1 = bytes$1;
                this.evidence$2$1 = evidence$2$1;
            }
        });
    }

    @Override
    public RpcEndpointRef endpointRef(RpcEndpoint endpoint) {
        return this.dispatcher().getRpcEndpointRef(endpoint);
    }

    @Override
    public void shutdown() {
        this.cleanup();
    }

    @Override
    public void awaitTermination() {
        this.dispatcher().awaitTermination();
    }

    private void cleanup() {
        if (this.stopped().compareAndSet(false, true)) {
            for (Outbox outbox : this.outboxes().values()) {
                this.outboxes().remove(outbox.address());
                outbox.stop();
            }
            Object object = this.timeoutScheduler() == null ? BoxedUnit.UNIT : this.timeoutScheduler().shutdownNow();
            if (this.dispatcher() != null) {
                this.dispatcher().stop();
            }
            if (this.server() != null) {
                this.server().close();
            }
            if (this.clientFactory() != null) {
                this.clientFactory().close();
            }
            Object object2 = this.clientConnectionExecutor() == null ? BoxedUnit.UNIT : this.clientConnectionExecutor().shutdownNow();
            if (this.fileDownloadFactory() != null) {
                this.fileDownloadFactory().close();
            }
            return;
        }
    }

    @Override
    public <T> T deserialize(Function0<T> deserializationAction) {
        return (T)NettyRpcEnv$.MODULE$.currentEnv().withValue((Object)this, deserializationAction);
    }

    @Override
    public RpcEnvFileServer fileServer() {
        return this.streamManager();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ReadableByteChannel openChannel(String uri) {
        URI parsedUri = new URI(uri);
        Predef$.MODULE$.require(parsedUri.getHost() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Host name must be defined.";
            }
        });
        Predef$.MODULE$.require(parsedUri.getPort() > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Port must be defined.";
            }
        });
        Predef$.MODULE$.require(parsedUri.getPath() != null && new StringOps(Predef$.MODULE$.augmentString(parsedUri.getPath())).nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Path must be defined.";
            }
        });
        Pipe pipe2 = Pipe.open();
        FileDownloadChannel source = new FileDownloadChannel(this, pipe2.source());
        try {
            TransportClient client = this.downloadClient(parsedUri.getHost(), parsedUri.getPort());
            FileDownloadCallback callback = new FileDownloadCallback(this, pipe2.sink(), source, client);
            client.stream(parsedUri.getPath(), (StreamCallback)callback);
            return source;
        }
        catch (Exception exception2) {
            void var4_4;
            void var3_3;
            var3_3.sink().close();
            var4_4.close();
            throw exception2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TransportClient downloadClient(String host, int port) {
        BoxedUnit boxedUnit;
        if (this.fileDownloadFactory() != null) {
            boxedUnit = BoxedUnit.UNIT;
            return this.fileDownloadFactory().createClient(host, port);
        }
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            BoxedUnit boxedUnit2;
            if (this.fileDownloadFactory() == null) {
                String module = "files";
                String prefix = "spark.rpc.io.";
                SparkConf clone2 = this.conf().clone();
                Predef$.MODULE$.refArrayOps((Object[])this.conf().getAll()).foreach((Function1)new Serializable(this, module, prefix, clone2){
                    public static final long serialVersionUID = 0L;
                    private final String module$1;
                    private final String prefix$1;
                    private final SparkConf clone$1;

                    public final Object apply(Tuple2<String, String> x0$2) {
                        Tuple2<String, String> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Object object;
                            String key = (String)tuple2._1();
                            String value2 = (String)tuple2._2();
                            if (key.startsWith(this.prefix$1)) {
                                String opt = key.substring(this.prefix$1.length());
                                object = this.clone$1.setIfMissing(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark.", ".io.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.module$1, opt})), value2);
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit = object;
                            return boxedUnit;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.module$1 = module$1;
                        this.prefix$1 = prefix$1;
                        this.clone$1 = clone$1;
                    }
                });
                int ioThreads = clone2.getInt("spark.files.io.threads", 1);
                TransportConf downloadConf = SparkTransportConf$.MODULE$.fromSparkConf(clone2, module, ioThreads);
                TransportContext downloadContext = new TransportContext(downloadConf, (RpcHandler)new NoOpRpcHandler(), true);
                this.fileDownloadFactory_$eq(downloadContext.createClientFactory(this.createClientBootstraps()));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit2;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl20 : MonitorExitStatement: MONITOREXIT : nettyRpcEnv
            boxedUnit = boxedUnit3;
            return this.fileDownloadFactory().createClient(host, port);
        }
    }

    public final void org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(Throwable e, Promise promise$1) {
        if (!promise$1.tryFailure(e)) {
            this.logWarning((Function0<String>)new Serializable(this, e){
                public static final long serialVersionUID = 0L;
                private final Throwable e$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignored failure: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$2}));
                }
                {
                    this.e$2 = e$2;
                }
            });
        }
    }

    public final void org$apache$spark$rpc$netty$NettyRpcEnv$$onSuccess$1(Object reply, Promise promise$1) {
        Object object = reply;
        if (object instanceof RpcFailure) {
            RpcFailure rpcFailure = (RpcFailure)object;
            Throwable e = rpcFailure.e();
            this.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (promise$1.trySuccess(object)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logWarning((Function0<String>)new Serializable(this, reply){
                    public static final long serialVersionUID = 0L;
                    private final Object reply$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignored message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.reply$1}));
                    }
                    {
                        this.reply$1 = reply$1;
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public NettyRpcEnv(SparkConf conf, JavaSerializerInstance javaSerializerInstance, String host, SecurityManager securityManager) {
        this.conf = conf;
        this.org$apache$spark$rpc$netty$NettyRpcEnv$$javaSerializerInstance = javaSerializerInstance;
        this.host = host;
        this.securityManager = securityManager;
        super(conf);
        Logging$class.$init$(this);
        this.transportConf = SparkTransportConf$.MODULE$.fromSparkConf(conf.clone().set("spark.rpc.io.numConnectionsPerPeer", "1"), "rpc", conf.getInt("spark.rpc.io.threads", 0));
        this.dispatcher = new Dispatcher(this);
        this.streamManager = new NettyStreamManager(this);
        this.transportContext = new TransportContext(this.transportConf(), (RpcHandler)new NettyRpcHandler(this.dispatcher(), this, this.streamManager()));
        this.clientFactory = this.transportContext().createClientFactory(this.createClientBootstraps());
        this.timeoutScheduler = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("netty-rpc-env-timeout");
        this.clientConnectionExecutor = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("netty-rpc-connection", conf.getInt("spark.rpc.connect.threads", 64), ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3());
        this.stopped = new AtomicBoolean(false);
        this.outboxes = new ConcurrentHashMap();
    }

    public class FileDownloadChannel
    implements ReadableByteChannel {
        public final ReadableByteChannel org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$source;
        private volatile Throwable error;
        public final /* synthetic */ NettyRpcEnv $outer;

        private Throwable error() {
            return this.error;
        }

        private void error_$eq(Throwable x$1) {
            this.error = x$1;
        }

        public void setError(Throwable e) {
            this.error_$eq(e);
            this.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$source.close();
        }

        @Override
        public int read(ByteBuffer dst) {
            Try try_ = Try$.MODULE$.apply((Function0)new Serializable(this, dst){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileDownloadChannel $outer;
                private final ByteBuffer dst$1;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$source.read(this.dst$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.dst$1 = dst$1;
                }
            });
            if (try_ instanceof Success) {
                int bytesRead;
                Success success = (Success)try_;
                int n = bytesRead = BoxesRunTime.unboxToInt((Object)success.value());
                return n;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable readErr = failure.exception();
                if (this.error() == null) {
                    throw readErr;
                }
                throw this.error();
            }
            throw new MatchError((Object)try_);
        }

        @Override
        public void close() {
            this.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$source.close();
        }

        @Override
        public boolean isOpen() {
            return this.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$source.isOpen();
        }

        public /* synthetic */ NettyRpcEnv org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$$outer() {
            return this.$outer;
        }

        public FileDownloadChannel(NettyRpcEnv $outer, ReadableByteChannel source) {
            this.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$source = source;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class FileDownloadCallback
    implements StreamCallback {
        private final WritableByteChannel sink;
        private final FileDownloadChannel source;
        public final /* synthetic */ NettyRpcEnv $outer;

        public void onData(String streamId, ByteBuffer buf) {
            while (buf.remaining() > 0) {
                this.sink.write(buf);
            }
        }

        public void onComplete(String streamId) {
            this.sink.close();
        }

        public void onFailure(String streamId, Throwable cause) {
            this.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadCallback$$$outer().logDebug((Function0<String>)new Serializable(this, streamId){
                public static final long serialVersionUID = 0L;
                private final String streamId$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error downloading stream ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.streamId$1}));
                }
                {
                    this.streamId$1 = streamId$1;
                }
            }, cause);
            this.source.setError(cause);
            this.sink.close();
        }

        public /* synthetic */ NettyRpcEnv org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadCallback$$$outer() {
            return this.$outer;
        }

        public FileDownloadCallback(NettyRpcEnv $outer, WritableByteChannel sink, FileDownloadChannel source, TransportClient client) {
            this.sink = sink;
            this.source = source;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

