/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import java.io.IOException;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class CreateIndexResponse
extends AcknowledgedResponse {
    private boolean shardsAcked;

    protected CreateIndexResponse() {
    }

    protected CreateIndexResponse(boolean acknowledged, boolean shardsAcked) {
        super(acknowledged);
        assert (acknowledged || !shardsAcked);
        this.shardsAcked = shardsAcked;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.readAcknowledged(in);
        this.shardsAcked = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.writeAcknowledged(out);
        out.writeBoolean(this.shardsAcked);
    }

    public boolean isShardsAcked() {
        return this.shardsAcked;
    }

    public void addCustomFields(XContentBuilder builder) throws IOException {
        builder.field("shards_acknowledged", this.isShardsAcked());
    }
}

