/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.visualizer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import edu.neu.ccs.pyramid.configuration.Config;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.client.PreBuiltTransportClient;

public class VisualizerConfig {
    private final File inputFile;
    private final File classFile;
    private final int numClassesInModel;
    private final String esIndexName;
    private final String ngramFields;
    private final File resourcesDir;
    private final Client client;

    public VisualizerConfig(Config config) throws IOException {
        Preconditions.checkNotNull((Object)config);
        ObjectMapper mapper = new ObjectMapper();
        this.inputFile = new File(config.getString("input.file"));
        this.checkFileExists(this.inputFile);
        File dataConfigFile = new File(this.inputFile.getParentFile(), config.getString("data.config.name"));
        Map dataConfig = (Map)mapper.readValue(dataConfigFile, (TypeReference)new TypeReference<Map<String, Object>>(){});
        this.esIndexName = dataConfig.get("index.indexName") == null ? "ohsumed_20000" : (String)dataConfig.get("index.indexName");
        this.ngramFields = (String)dataConfig.get("index.ngramExtractionFields");
        File dataInfoFile = new File(this.inputFile.getParentFile(), config.getString("data.info.name"));
        this.numClassesInModel = mapper.readTree(dataInfoFile).path("numClassesInModel").asInt(23);
        this.classFile = new File(config.getString("class.file"));
        this.resourcesDir = new File(config.getString("resources.dir"));
        this.checkFileExists(this.classFile);
        Settings settings = Settings.builder().put("cluster.name", "fijielasticsearch").build();
        this.client = new PreBuiltTransportClient(settings, new Class[0]);
    }

    private void checkFileExists(File file) throws IOException {
        if (!file.isFile()) {
            throw new IllegalStateException(file.getCanonicalPath() + "is not a file");
        }
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public File getClassFile() {
        return this.classFile;
    }

    public int getNumClassesInModel() {
        return this.numClassesInModel;
    }

    public String getEsIndexName() {
        return this.esIndexName;
    }

    public File getInputFileBaseDir() {
        return this.inputFile.getParentFile();
    }

    public String getNgramFields() {
        return this.ngramFields;
    }

    public File getResourcesDir() {
        return this.resourcesDir;
    }

    public Client getClient() {
        return this.client;
    }
}

