/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.visualizer;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.neu.ccs.pyramid.configuration.Config;
import edu.neu.ccs.pyramid.visualizer.VisualizerConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.elasticsearch.action.get.GetResponse;

public class Visualizer {
    private final VisualizerConfig config;

    public Visualizer(VisualizerConfig config) {
        this.config = config;
    }

    public void visualize() throws IOException {
        String outputFileName = "viewer";
        String indPerformanceName = "individual_performance";
        String topName = "top_features";
        String configName = "data_config";
        String dataName = "data_info";
        String modelName = "model_config";
        String performanceName = "performance";
        File inputTop = new File(this.config.getInputFileBaseDir(), "top_features.json");
        File outputPath = new File(this.config.getInputFileBaseDir(), "top_features.html");
        this.createTopFeatureHTML(inputTop, outputPath);
        File inputIndPer = new File(this.config.getInputFileBaseDir(), "individual_performance.json");
        File inputAllPer = new File(this.config.getInputFileBaseDir(), "performance.json");
        outputPath = new File(this.config.getInputFileBaseDir(), "individual_performance.html");
        this.createIndPerHTML(inputIndPer, inputAllPer, outputPath);
        File inputData = new File(this.config.getInputFileBaseDir(), "data_info.json");
        File inputModel = new File(this.config.getInputFileBaseDir(), "model_config.json");
        File inputConfig = new File(this.config.getInputFileBaseDir(), "data_config.json");
        outputPath = new File(this.config.getInputFileBaseDir(), "metadata.html");
        this.createMetaDataHTML(inputData, inputModel, inputConfig, outputPath);
        HashMap<String, String> classDescription = new HashMap<String, String>();
        for (String line : FileUtils.readLines((File)this.config.getClassFile(), (String)"UTF-8")) {
            String[] lineInfo = (line = line.trim()).split("\\t");
            if (lineInfo.length <= 1) continue;
            String className = lineInfo[0];
            String classDesc = lineInfo[1];
            classDescription.put(className, classDesc);
        }
        List<String> skipJsonFiles = Arrays.asList("data_config.json", "data_info.json", "model_config.json", "top_features.json", "performance.json", "individual_performance.json");
        if (this.config.getInputFile().isFile()) {
            this.parse(this.config.getInputFile(), new File(this.config.getInputFileBaseDir(), "viewer_" + this.config.getInputFile().getName().substring(0, this.config.getInputFile().getName().lastIndexOf(46)) + ".html"), this.config.getNgramFields(), classDescription);
        } else {
            for (File f : this.config.getInputFileBaseDir().listFiles()) {
                String fileName = f.getName();
                if (skipJsonFiles.contains(fileName)) continue;
                outputPath = new File(this.config.getInputFileBaseDir(), "viewer_" + f.getName().substring(0, f.getName().lastIndexOf(46)) + ".html");
                this.parse(f, outputPath, this.config.getNgramFields(), classDescription);
            }
        }
    }

    private void parse(File input_json_file, File outputFileName, String fields, Map<String, String> classDescription) throws IOException {
        List<Object> outputData = this.createTable(this.loadJson(input_json_file, new TypeReference<List<Object>>(){}), fields, classDescription);
        String output = this.getResourcesFileAsString("pre-data.html") + this.getJsonString(outputData) + this.getResourcesFileAsString("post-data.txt");
        this.writeStringToFile(outputFileName, output);
    }

    private List<Object> createTable(List<Object> data, String fields, Map<String, String> classDescription) throws IOException {
        int line_count = 0;
        ArrayList<Object> output = new ArrayList<Object>();
        for (Object rowData : data) {
            Object labelClassIndex;
            Map row = (Map)rowData;
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            ++line_count;
            ArrayList<Object> r = new ArrayList<Object>();
            HashMap idLabels = new HashMap();
            idLabels.put("id", row.get("id"));
            idLabels.put("internalId", row.get("internalId"));
            idLabels.put("internalLabels", row.get("internalLabels"));
            idLabels.put("feedbackSelect", "none");
            idLabels.put("feedbackText", "");
            ArrayList<Object> internalLabels = new ArrayList<Object>();
            HashSet releLabels = new HashSet();
            int rowSize = ((List)row.get("labels")).size();
            for (int i = 0; i < rowSize; ++i) {
                HashMap label = new HashMap();
                label.put(((List)row.get("internalLabels")).get(i), ((List)row.get("labels")).get(i));
                internalLabels.add(label);
                releLabels.add(((List)row.get("labels")).get(i));
            }
            ArrayList predictions = new ArrayList();
            HashSet pres = new HashSet();
            int rowSize2 = ((List)row.get("prediction")).size();
            for (int i = 0; i < rowSize2; ++i) {
                Iterator label = new HashMap();
                label.put(((List)row.get("internalPrediction")).get(i), ((List)row.get("prediction")).get(i));
                predictions.add(label);
                pres.add(((List)row.get("prediction")).get(i));
            }
            idLabels.put("predictions", predictions);
            HashSet intersections = new HashSet(releLabels);
            intersections.retainAll(pres);
            HashSet unions = new HashSet(releLabels);
            unions.addAll(pres);
            if (unions.size() == 0) {
                idLabels.put("overlap", "N/A");
            } else {
                idLabels.put("overlap", String.format("%.2f", (double)intersections.size() / (double)unions.size()));
            }
            if (releLabels.size() == 0) {
                idLabels.put("recall", "N/A");
            } else {
                idLabels.put("recall", String.format("%.2f", -((double)intersections.size()) / (double)releLabels.size()));
            }
            if (pres.size() == 0) {
                idLabels.put("precision", "N/A");
            } else {
                idLabels.put("precision", (double)intersections.size() / (double)pres.size());
            }
            oneRow.put("probForPredictedLabels", row.get("probForPredictedLabels"));
            oneRow.put("predictedRanking", new ArrayList());
            for (Map label : (List)row.get("predictedRanking")) {
                List curInternalPrediction = (List)row.get("internalPrediction");
                List curInternalLabels = (List)row.get("internalLabels");
                if (curInternalLabels.contains(labelClassIndex = label.get("classIndex")) && curInternalPrediction.contains(labelClassIndex)) {
                    label.put("type", "TP");
                } else if (!curInternalLabels.contains(labelClassIndex) && curInternalPrediction.contains(labelClassIndex)) {
                    label.put("type", "FP");
                } else if (!curInternalLabels.contains(labelClassIndex) && !curInternalPrediction.contains(labelClassIndex)) {
                    label.put("type", "FN");
                } else {
                    label.put("type", "");
                }
                r.add(this.includesLabel(label.get("className"), internalLabels));
                ((List)oneRow.get("predictedRanking")).add(label);
            }
            for (Map labels : (List)row.get("predictedLabelSetRanking")) {
                labels.put("types", new ArrayList());
                List curInternalLabels = (List)row.get("internalLabels");
                List curInternalPrediction = (List)row.get("internalPrediction");
                labelClassIndex = ((List)labels.get("internalLabels")).iterator();
                while (labelClassIndex.hasNext()) {
                    Object index = labelClassIndex.next();
                    if (curInternalLabels.contains(index) && curInternalPrediction.contains(index)) {
                        ((List)labels.get("types")).add("TP");
                        continue;
                    }
                    if (!curInternalLabels.contains(index) && curInternalPrediction.contains(index)) {
                        ((List)labels.get("types")).add("FP");
                        continue;
                    }
                    if (curInternalLabels.contains(index) && !curInternalPrediction.contains(index)) {
                        ((List)labels.get("types")).add("FN");
                        continue;
                    }
                    ((List)labels.get("types")).add("");
                }
            }
            oneRow.put("predictedLabelSetRanking", row.get("predictedLabelSetRanking"));
            double sumOfR = 0.0;
            double sumOfPrec = 0.0;
            int last = 0;
            for (int i = 0; i < r.size(); ++i) {
                if (!r.get(i).equals(new Integer(1))) continue;
                sumOfPrec += (sumOfR += (double)((Integer)r.get(i)).intValue()) / (double)(i + 1);
                last = i + 1;
            }
            if (releLabels.size() == 0) {
                idLabels.put("ap", "N/A");
            } else {
                idLabels.put("ap", String.format("%.2f", sumOfPrec / (double)releLabels.size()));
            }
            if (sumOfR < (double)releLabels.size()) {
                idLabels.put("rankoffullrecall", "N/A");
            } else {
                idLabels.put("rankoffullrecall", last);
            }
            oneRow.put("idLabels", idLabels);
            GetResponse res = (GetResponse)this.config.getClient().prepareGet(this.config.getEsIndexName(), "document", (String)row.get("id")).execute().actionGet();
            String keys = fields;
            oneRow.put("text", new HashMap());
            oneRow.put("others", new HashMap());
            for (String key : res.getSourceAsMap().keySet()) {
                if (keys.equals(key)) {
                    ((Map)oneRow.get("text")).put(key, ((String)res.getSourceAsMap().get(key)).replace("<", "&lt").replace(">", "&gt"));
                    continue;
                }
                ((Map)oneRow.get("others")).put(key, (String)res.getSourceAsMap().get(key));
            }
            this.createTFPNColumns(row, line_count, oneRow, classDescription);
            output.add(oneRow);
        }
        return output;
    }

    private void createTFPNColumns(Map<String, Object> row, int line_count, Map<String, Object> oneRow, Map<String, String> classDescription) throws IOException {
        ArrayList tmpDict = new ArrayList();
        HashSet labelSet = new HashSet();
        oneRow.put("TP", new ArrayList());
        for (Map clas : (List)row.get("classScoreCalculations")) {
            List curInternalLabels = (List)row.get("internalLabels");
            List curInternalPrediction = (List)row.get("internalPrediction");
            Object internalClassIndex = clas.get("internalClassIndex");
            if (!curInternalLabels.contains(internalClassIndex) || !curInternalPrediction.contains(internalClassIndex)) continue;
            ((List)oneRow.get("TP")).add(this.writeClass(row.get("id"), line_count, clas, classDescription));
            oneRow.put("TP", oneRow.get("TP"));
        }
    }

    private Object writeClass(Object docId, int line_count, Map<String, Object> clas, Map<String, String> classDescription) throws IOException {
        HashMap<String, Object> oneClass = new HashMap<String, Object>();
        oneClass.put("id", clas.get("internalClassIndex"));
        String name = (String)clas.get("className");
        name = classDescription.containsKey(name) ? name + " : " + classDescription.get(name) : name + " : MISSING DESCRIPTION";
        oneClass.put("name", name);
        oneClass.put("classProbability", clas.get("classProbability"));
        oneClass.put("totalScore", clas.get("classScore"));
        int start = 0;
        if (!((Map)((List)clas.get("rules")).get(0)).containsKey("checks")) {
            oneClass.put("prior", ((Map)((List)clas.get("rules")).get(0)).get("score"));
            start = 1;
        }
        oneClass.put("rules", new ArrayList());
        ArrayList allPos = new ArrayList();
        String field = "";
        int size = ((List)clas.get("rules")).size();
        for (int i = start; i < size; ++i) {
            List<Object> writeRuleResult = this.writeRule(docId, line_count, i, (Map)((List)clas.get("rules")).get(i));
            Object oneRule = writeRuleResult.get(0);
            Object pos = writeRuleResult.get(1);
            field = (String)writeRuleResult.get(2);
            ((List)oneClass.get("rules")).add(oneRule);
            oneClass.put("rules", oneClass.get("rules"));
            allPos.addAll((List)pos);
        }
        oneClass.put("allPos", allPos.stream().map(s -> s.toString()).collect(Collectors.toList()));
        oneClass.put("field", field);
        return oneClass;
    }

    private List<Object> writeRule(Object docId, int line_count, int i, Map<String, Object> rule) throws IOException {
        HashMap<String, Object> oneRule = new HashMap<String, Object>();
        oneRule.put("score", rule.get("score"));
        oneRule.put("checks", new ArrayList());
        ArrayList<Object> allPos = new ArrayList<Object>();
        String field = "";
        for (Map check : (List)rule.get("checks")) {
            HashMap checkOneRule = new HashMap();
            List<Object> pos = new ArrayList();
            if (new Double(0.0).equals(check.get("feature value")) || !((Map)check.get("feature")).containsKey("ngram")) continue;
            pos = this.getPositions(docId, ((Map)check.get("feature")).get("field"), ((Map)check.get("feature")).get("ngram"), ((Map)check.get("feature")).get("slop"), ((Map)check.get("feature")).get("inOrder"));
            if (((Map)check.get("feature")).containsKey("ngram")) {
                checkOneRule.put("name", ((Map)check.get("feature")).get("name"));
                checkOneRule.put("index", ((Map)check.get("feature")).get("index"));
            } else {
                checkOneRule.put("ngram", ((Map)check.get("feature")).get("ngram"));
                checkOneRule.put("index", ((Map)check.get("feature")).get("index"));
                checkOneRule.put("field", ((Map)check.get("feature")).get("field"));
                checkOneRule.put("slop", ((Map)check.get("feature")).get("slop"));
                field = (String)checkOneRule.get("field");
            }
            checkOneRule.put("value", check.get("feature value"));
            checkOneRule.put("relation", check.get("relation"));
            checkOneRule.put("threshold", check.get("threshold"));
            checkOneRule.put("highlights", pos.stream().map(q -> String.valueOf(q)).collect(Collectors.toList()));
            allPos.addAll(pos);
            ((List)oneRule.get("checks")).add(checkOneRule);
            oneRule.put("checks", oneRule.get("checks"));
        }
        return Arrays.asList(oneRule, allPos, field);
    }

    private List<Object> newSpanTerm(String terms, String field) {
        ArrayList<Object> allSpans = new ArrayList<Object>();
        for (String term : terms.split("\\s+")) {
            HashMap spanTerm = new HashMap();
            HashMap<String, String> internalSpanTerm = new HashMap<String, String>();
            internalSpanTerm.put(field, term);
            spanTerm.put("span_term", internalSpanTerm);
            allSpans.add(spanTerm);
        }
        return allSpans;
    }

    private List<Integer> getPositions(Object docId, Object field, Object keywords, Object slop, Object in_order) throws IOException {
        System.out.println(docId + " " + field + " " + keywords + " " + slop + " " + in_order);
        URL url = new URL("http://localhost:9200/ohsumed_20000/document/_search");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.addRequestProperty("Content-Type", "application/POST");
        String clauses = this.getJsonString(this.newSpanTerm((String)keywords, (String)field));
        String body = "{\"explain\":\"false\",                              \"query\":{                                  \"filtered\":{                                      \"query\":{                                          \"span_near\": {                                              \"clauses\":" + clauses + ",                                              \"slop\":" + slop.toString() + ",                                              \"in_order\":" + in_order.toString() + ",                                              \"collect_payloads\": false}},                                      \"filter\":{\"ids\":{\"values\":[\"" + docId + "\"]}}}},                              \"highlight\":{\"fields\":{\"" + field + "\":{}}},                              \"size\":1}";
        System.out.println(body);
        conn.setRequestProperty("Content-Length", Integer.toString(body.length()));
        conn.getOutputStream().write(body.getBytes("UTF-8"));
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder result = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            result.append(line);
        }
        JsonFactory factory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(factory);
        Map hits = (Map)mapper.readValue(result.toString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        ArrayList<Integer> positions = new ArrayList<Integer>();
        if (hits.get("hits") != null && ((Map)hits.get("hits")).containsKey("hits")) {
            for (String hlField : ((Map)((Map)((List)((Map)hits.get("hits")).get("hits")).get(0)).get("highlight")).keySet()) {
                String text = (String)((Map)((Map)((List)((Map)hits.get("hits")).get("hits")).get(0)).get("_source")).get(hlField);
                List highlights = (List)((Map)((Map)((List)((Map)hits.get("hits")).get("hits")).get(0)).get("highlight")).get(hlField);
                for (String HL : highlights) {
                    String cleanHL = HL.replaceAll("<em>", "");
                    int baseindex = text.indexOf(cleanHL = cleanHL.replaceAll("</em>", ""));
                    if (baseindex == -1) continue;
                    while (HL.indexOf("<em>") != -1) {
                        int start = HL.indexOf("<em>") + baseindex;
                        HL = HL.replace("<em>", "");
                        int end = HL.indexOf("</em>") + baseindex;
                        HL = HL.replace("</em>", "");
                        positions.add(start);
                        positions.add(end);
                    }
                }
            }
        }
        return positions;
    }

    private Object includesLabel(Object label, List<Object> labels) {
        for (Object lbObj : labels) {
            Map lb = (Map)lbObj;
            for (Object key : lb.keySet()) {
                if (!label.equals(lb.get(key))) continue;
                return 1;
            }
        }
        return 0;
    }

    private void createMetaDataHTML(File inputData, File inputModel, File inputConfig, File outputPath) throws IOException {
        Object inputD = null;
        Object inputM = null;
        Object inputC = null;
        HashMap<String, Object> outputData = new HashMap<String, Object>();
        if (inputData.isFile()) {
            inputD = this.loadJson(inputData, new TypeReference<Object>(){});
        }
        if (inputModel.isFile()) {
            inputM = this.loadJson(inputData, new TypeReference<Object>(){});
        }
        if (inputConfig.isFile()) {
            inputC = this.loadJson(inputData, new TypeReference<Object>(){});
        }
        outputData.put("data", inputD);
        outputData.put("model", inputM);
        outputData.put("config", inputC);
        String output = this.getResourcesFileAsString("pre-md-data.html") + this.getJsonString(outputData) + this.getResourcesFileAsString("post-data.txt");
        this.writeStringToFile(outputPath, output);
    }

    private void createIndPerHTML(File inputIndPer, File inputAllPer, File outputPath) throws IOException {
        if (inputIndPer.isFile()) {
            String output = this.getResourcesFileAsString("pre-ind-data-part1.html") + "[" + this.readFileAsString(inputAllPer) + "]" + this.getResourcesFileAsString("pre-ind-data-part2.txt") + this.readFileAsString(inputIndPer) + this.getResourcesFileAsString("post-data.txt");
            this.writeStringToFile(outputPath, output);
        }
    }

    private void createTopFeatureHTML(File inputFile, File outputFile) throws IOException {
        String output = "";
        try {
            List<Map<String, Object>> inputData = this.loadJson(inputFile, new TypeReference<List<Map<String, Object>>>(){});
            List<Object> outputData = this.createNewJsonForTopFeatures(inputData);
            String outputJson = this.getJsonString(outputData);
            output = this.getResourcesFileAsString("pre-tf-data.html") + outputJson + this.getResourcesFileAsString("post-data.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
            output = this.getResourcesFileAsString("pre-tf-data.html") + this.getResourcesFileAsString("post-data.txt");
        }
        FileUtils.writeStringToFile((File)outputFile, (String)output, (String)"UTF-8");
    }

    private void writeStringToFile(File file, String data) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)data, (String)"UTF-8");
    }

    private String readFileAsString(File file) throws IOException {
        return FileUtils.readFileToString((File)file, (String)"UTF-8");
    }

    private List<Object> createNewJsonForTopFeatures(List<Map<String, Object>> inputData) {
        ArrayList<Object> outputData = new ArrayList<Object>();
        outputData.add(new ArrayList());
        outputData.add(new ArrayList());
        HashMap<String, Integer> indexes = new HashMap<String, Integer>();
        for (Map<String, Object> clas : inputData) {
            ArrayList<Object> feature = new ArrayList<Object>();
            feature.add(clas.get("classIndex"));
            feature.add(clas.get("className"));
            ArrayList fds = new ArrayList();
            for (Map fd : (List)clas.get("featureDistributions")) {
                ArrayList<Object> distribution = new ArrayList<Object>();
                String name = ((Map)fd.get("feature")).containsKey("ngram") ? (String)((Map)fd.get("feature")).get("ngram") : (String)((Map)fd.get("feature")).get("name");
                distribution.add(name);
                distribution.add(new ArrayList());
                distribution.add(fd.get("totalCount"));
                for (String occu : (List)fd.get("occurrence")) {
                    ArrayList<Object> occurence = new ArrayList<Object>();
                    String[] res = occu.split(":");
                    String className = res[0];
                    String[] r = res[1].split("/");
                    if (!indexes.containsKey(className)) {
                        ArrayList<String> c = new ArrayList<String>();
                        c.add(className);
                        c.add(r[1]);
                        ((List)outputData.get(0)).add(c);
                        indexes.put(className, ((List)outputData.get(0)).size() - 1);
                    }
                    occurence.add(indexes.get(className));
                    occurence.add(r[0]);
                    ((List)distribution.get(1)).add(occurence);
                }
                fds.add(distribution);
            }
            feature.add(fds);
            ((List)outputData.get(1)).add(feature);
        }
        return outputData;
    }

    private <T> T loadJson(File file, TypeReference<T> typeRef) throws IOException {
        JsonFactory factory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(factory);
        return (T)mapper.readValue(file, typeRef);
    }

    private void storeJson(File jsonFile, Map<?, ?> data) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue(jsonFile, data);
    }

    private String getJsonString(Object data) throws IOException {
        return new ObjectMapper().writeValueAsString(data);
    }

    private String getResourcesFileAsString(String fileName) throws IOException {
        return FileUtils.readFileToString((File)new File(this.config.getResourcesDir(), fileName), (String)"UTF-8");
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.err.println("Requires name of the config file as the first argument");
            System.exit(1);
        }
        Visualizer visualizer = new Visualizer(new VisualizerConfig(new Config(args[0])));
        visualizer.visualize();
    }
}

