/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Translator<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<T, Integer> objToIndex = new HashMap<T, Integer>();
    private Map<Integer, T> indexToObj = new HashMap<Integer, T>();
    private int startIndex;
    private int currentIndex;

    public Translator(int startIndex) {
        this.startIndex = startIndex;
        this.currentIndex = startIndex;
    }

    public Translator() {
        this(0);
    }

    public synchronized void add(T obj) {
        if (!this.objToIndex.containsKey(obj)) {
            this.objToIndex.put(obj, this.currentIndex);
            this.indexToObj.put(this.currentIndex, obj);
            ++this.currentIndex;
        }
    }

    public synchronized void addAll(Collection<T> all) {
        all.forEach(this::add);
    }

    public int getIndex(T obj) {
        return this.objToIndex.get(obj);
    }

    public T getObj(int index) {
        return this.indexToObj.get(index);
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int size() {
        return this.indexToObj.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Translator{");
        sb.append("indexToObj=").append(this.indexToObj);
        sb.append('}');
        return sb.toString();
    }
}

