/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.util;

import java.util.concurrent.atomic.AtomicInteger;

public class ProgressBar {
    private String barStart = "[";
    private String barEnd = "]";
    private String arrowBody = "=";
    private String arrowEnd = ">";
    private int width = 50;
    private AtomicInteger currentCount = new AtomicInteger(0);
    private int total;

    public ProgressBar(int total) {
        this.total = total;
    }

    public synchronized void incrementAndPrint() {
        int current = this.currentCount.incrementAndGet();
        if (Math.floor((double)current / (double)this.total * 100.0) > Math.floor(((double)current - 1.0) / (double)this.total * 100.0)) {
            this.printProcessBar((int)Math.floor((double)current / (double)this.total * 100.0));
        }
    }

    private void printProcessBar(int percent) {
        int i;
        int processWidth = percent * this.width / 100;
        System.out.print("\r" + this.barStart);
        for (i = 0; i < processWidth; ++i) {
            System.out.print(this.arrowBody);
        }
        System.out.print(this.arrowEnd);
        for (i = processWidth; i < this.width; ++i) {
            System.out.print(" ");
        }
        System.out.print(this.barEnd + percent + "%");
    }
}

