/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Grid {
    public static List<Double> uniform(double min, double max, int num) {
        if (min > max || num < 1) {
            throw new IllegalArgumentException("min> max ||num<1");
        }
        ArrayList<Double> values = new ArrayList<Double>();
        if (num == 1) {
            if (min != max) {
                throw new IllegalArgumentException("num = 1 but min!=max");
            }
            values.add(min);
            return values;
        }
        double interval = (max - min) / (double)(num - 1);
        for (int i = 0; i < num; ++i) {
            values.add(min + (double)i * interval);
        }
        return values;
    }

    public static List<Double> uniformDecreasing(double min, double max, int num) {
        List<Double> list = Grid.uniform(min, max, num);
        ArrayList<Double> des = new ArrayList<Double>();
        for (int i = 0; i < list.size(); ++i) {
            des.add(list.get(list.size() - i - 1));
        }
        return des;
    }

    public static List<Double> logUniform(double min, double max, int num) {
        if (min > max || num < 1 || min < 0.0) {
            throw new IllegalArgumentException("min> max ||num<1");
        }
        return Grid.uniform(Math.log(min), Math.log(max), num).stream().map(Math::exp).collect(Collectors.toList());
    }
}

