/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.util;

import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;

public class EmpiricalCDF {
    private double min;
    private double max;
    private int numBins;
    private int totalCount;
    private int[] counts;
    private int[] cumulativeCounts;
    private double[] thresholds;
    private double[] probabilities;

    public EmpiricalCDF(List<Double> list, double globalMin, double globalMax, int numBins) {
        int i;
        this.numBins = numBins;
        int numIntervals = numBins + 1;
        this.min = globalMin;
        this.max = globalMax;
        double length = (this.max - this.min) / (double)numBins;
        this.thresholds = new double[numIntervals];
        this.probabilities = new double[numIntervals];
        this.counts = new int[numIntervals];
        for (Double value : list) {
            int intervalIndex;
            int n = intervalIndex = EmpiricalCDF.getIntervalIndex(value, this.min, length, numIntervals);
            this.counts[n] = this.counts[n] + 1;
        }
        this.cumulativeCounts = new int[numIntervals];
        for (i = 0; i < this.cumulativeCounts.length; ++i) {
            int n = i;
            this.cumulativeCounts[n] = this.cumulativeCounts[n] + this.counts[i];
            if (i == 0) continue;
            int n2 = i;
            this.cumulativeCounts[n2] = this.cumulativeCounts[n2] + this.cumulativeCounts[i - 1];
        }
        for (i = 0; i < numIntervals; ++i) {
            this.thresholds[i] = this.min + length * (double)i;
        }
        this.totalCount = list.size();
        for (i = 0; i < numIntervals; ++i) {
            this.probabilities[i] = (double)this.cumulativeCounts[i] / (double)this.totalCount;
        }
    }

    public EmpiricalCDF(List<Double> list, int numBins) {
        this(list, list.stream().mapToDouble(i -> i).min().getAsDouble(), list.stream().mapToDouble(i -> i).max().getAsDouble(), numBins);
    }

    public EmpiricalCDF(List<Double> list) {
        this(list, 100);
    }

    private static int getIntervalIndex(double featureValue, double minFeature, double intervalLength, int numIntervals) {
        int ceil = (int)Math.ceil((featureValue - minFeature) / intervalLength);
        if (ceil > numIntervals - 1) {
            ceil = numIntervals - 1;
        }
        int intervalIndex = ceil <= 0 ? 0 : ceil;
        return intervalIndex;
    }

    public static double distance(EmpiricalCDF cdf1, EmpiricalCDF cdf2) {
        if (cdf1.numBins != cdf2.numBins || cdf1.min != cdf2.min || cdf1.max != cdf2.max) {
            throw new IllegalArgumentException("cdf1.numBins!=cdf2.numBins || cdf1.min!=cdf2.min ||cdf1.max!=cdf2.max");
        }
        return IntStream.range(0, cdf1.numBins + 1).mapToDouble(i -> Math.abs(cdf1.probabilities[i] - cdf2.probabilities[i])).max().getAsDouble();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EmpiricalCDF{");
        sb.append("min=").append(this.min);
        sb.append(", max=").append(this.max);
        sb.append(", numBins=").append(this.numBins);
        sb.append(", totalCount=").append(this.totalCount);
        sb.append(", counts=").append(Arrays.toString(this.counts));
        sb.append(", cumulativeCounts=").append(Arrays.toString(this.cumulativeCounts));
        sb.append(", thresholds=").append(Arrays.toString(this.thresholds));
        sb.append(", probabilities=").append(Arrays.toString(this.probabilities));
        sb.append('}');
        return sb.toString();
    }
}

