/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.util;

import java.util.Comparator;
import java.util.PriorityQueue;

public class BoundedBlockPriorityQueue<E> {
    private PriorityQueue<E> queue;
    private int maxCapacity;
    private Comparator<E> comparator;

    public BoundedBlockPriorityQueue(int maxCapacity, Comparator<E> comparator) {
        this.maxCapacity = maxCapacity;
        this.comparator = comparator;
        this.queue = new PriorityQueue<E>(comparator);
    }

    public synchronized void add(E e) {
        if (this.queue.size() == this.maxCapacity) {
            E head = this.queue.peek();
            if (this.comparator.compare(head, e) < 0) {
                this.queue.poll();
                this.queue.add(e);
            }
        } else {
            this.queue.add(e);
        }
    }

    public E poll() {
        return this.queue.poll();
    }

    public int size() {
        return this.queue.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BoundedBlockPriorityQueue{");
        sb.append("queue=").append(this.queue);
        sb.append('}');
        return sb.toString();
    }
}

