/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.util;

import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;

public class BernoulliDistribution
implements Serializable {
    private double p;
    private double logP;
    private double logOneMinusP;

    public BernoulliDistribution(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p should be within 0 and 1. Given p = " + p);
        }
        this.p = p;
        this.logP = Math.log(p);
        this.logOneMinusP = Math.log(1.0 - p);
    }

    public double probability(double value) {
        boolean condition;
        boolean bl = condition = value == 0.0 || value == 1.0;
        if (!condition) {
            throw new IllegalArgumentException("value should be 1 or 0");
        }
        if (value == 1.0) {
            return this.p;
        }
        return 1.0 - this.p;
    }

    public double logProbability(int value) {
        boolean condition;
        boolean bl = condition = value == 0 || value == 1;
        if (!condition) {
            throw new IllegalArgumentException("value should be 1 or 0");
        }
        if (value == 1) {
            return this.logP;
        }
        return this.logOneMinusP;
    }

    public int sample() {
        double d = ThreadLocalRandom.current().nextDouble();
        if (d < this.p) {
            return 1;
        }
        return 0;
    }

    public double getP() {
        return this.p;
    }
}

