/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.simulation;

import edu.neu.ccs.pyramid.dataset.ClfDataSet;
import edu.neu.ccs.pyramid.dataset.ClfDataSetBuilder;
import edu.neu.ccs.pyramid.util.Sampling;
import org.apache.commons.math3.distribution.NormalDistribution;

public class ClassificationSynthesizer {
    private int numDataPoints;
    private double noiseMean;
    private double noiseSD;
    private int numFeatures;
    private NormalDistribution noise;

    public ClfDataSet multivarLine() {
        ClfDataSet dataSet = ClfDataSetBuilder.getBuilder().numDataPoints(this.numDataPoints).numFeatures(this.numFeatures).numClasses(2).dense(true).missingValue(false).build();
        for (int i = 0; i < this.numDataPoints; ++i) {
            for (int j = 0; j < this.numFeatures; ++j) {
                double featureValue = Sampling.doubleUniform(0.0, 1.0);
                dataSet.setFeatureValue(i, j, featureValue);
            }
            double sum = 0.0;
            for (int j = 0; j < this.numFeatures; ++j) {
                sum += dataSet.getRow(i).get(j);
            }
            if ((sum += this.noise.sample()) >= (double)this.numFeatures / 2.0) {
                dataSet.setLabel(i, 1);
                continue;
            }
            dataSet.setLabel(i, 0);
        }
        return dataSet;
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static class Builder {
        private int numDataPoints = 100;
        private double noiseMean = 0.0;
        private double noiseSD = 0.001;
        private int numFeatures = 2;

        public Builder setNumDataPoints(int numDataPoints) {
            this.numDataPoints = numDataPoints;
            return this;
        }

        public Builder setNoiseMean(double noiseMean) {
            this.noiseMean = noiseMean;
            return this;
        }

        public Builder setNoiseSD(double noiseSD) {
            this.noiseSD = noiseSD;
            return this;
        }

        public Builder setNumFeatures(int numFeatures) {
            this.numFeatures = numFeatures;
            return this;
        }

        public ClassificationSynthesizer build() {
            ClassificationSynthesizer classificationSynthesizer = new ClassificationSynthesizer();
            classificationSynthesizer.numDataPoints = this.numDataPoints;
            classificationSynthesizer.noiseMean = this.noiseMean;
            classificationSynthesizer.noiseSD = this.noiseSD;
            classificationSynthesizer.noise = new NormalDistribution(this.noiseMean, this.noiseSD);
            classificationSynthesizer.numFeatures = this.numFeatures;
            return classificationSynthesizer;
        }
    }
}

