/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.regression.regression_tree;

import edu.neu.ccs.pyramid.dataset.DataSet;
import edu.neu.ccs.pyramid.regression.Regressor;
import edu.neu.ccs.pyramid.regression.RegressorFactory;
import edu.neu.ccs.pyramid.regression.regression_tree.AverageOutputCalculator;
import edu.neu.ccs.pyramid.regression.regression_tree.LeafOutputCalculator;
import edu.neu.ccs.pyramid.regression.regression_tree.RegTreeConfig;
import edu.neu.ccs.pyramid.regression.regression_tree.RegTreeTrainer;

public class RegTreeFactory
implements RegressorFactory {
    private RegTreeConfig regTreeConfig;
    private LeafOutputCalculator leafOutputCalculator;

    public RegTreeFactory(RegTreeConfig regTreeConfig) {
        this.regTreeConfig = regTreeConfig;
        this.leafOutputCalculator = new AverageOutputCalculator();
    }

    public void setLeafOutputCalculator(LeafOutputCalculator leafOutputCalculator) {
        this.leafOutputCalculator = leafOutputCalculator;
    }

    @Override
    public Regressor fit(DataSet dataSet, double[] labels) {
        return RegTreeTrainer.fit(this.regTreeConfig, dataSet, labels, this.leafOutputCalculator);
    }

    @Override
    public Regressor fit(DataSet dataSet, double[] labels, double[] weights) {
        return RegTreeTrainer.fit(this.regTreeConfig, dataSet, labels, weights, this.leafOutputCalculator);
    }
}

