/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.regression.regression_tree;

public class RegTreeConfig {
    private int numSplitIntervals = 100;
    private int maxNumLeaves = 2;
    private int minDataPerLeaf = 0;
    private int randomLevel = 1;

    public RegTreeConfig setMaxNumLeaves(int maxNumLeaves) {
        this.maxNumLeaves = maxNumLeaves;
        return this;
    }

    public RegTreeConfig setMinDataPerLeaf(int minDataPerLeaf) {
        this.minDataPerLeaf = minDataPerLeaf;
        return this;
    }

    public RegTreeConfig setNumSplitIntervals(int numSplitIntervals) {
        if (numSplitIntervals <= 1) {
            throw new IllegalArgumentException("numSplitIntervals must be greater than 2");
        }
        this.numSplitIntervals = numSplitIntervals;
        return this;
    }

    public RegTreeConfig setRandomLevel(int randomLevel) {
        if (randomLevel < 1) {
            throw new IllegalArgumentException("random level should be at least 1");
        }
        this.randomLevel = randomLevel;
        return this;
    }

    int getMaxNumLeaves() {
        return this.maxNumLeaves;
    }

    int getMinDataPerLeaf() {
        return this.minDataPerLeaf;
    }

    int getNumSplitIntervals() {
        return this.numSplitIntervals;
    }

    int getRandomLevel() {
        return this.randomLevel;
    }
}

