/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.regression.regression_tree;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import edu.neu.ccs.pyramid.feature.Feature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@JsonSerialize(using=Serializer.class)
class Checks {
    List<Integer> featureIndices = new ArrayList<Integer>();
    List<Feature> features = new ArrayList<Feature>();
    List<Double> thresholds = new ArrayList<Double>();
    List<Boolean> directions = new ArrayList<Boolean>();
    List<Double> values = new ArrayList<Double>();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.featureIndices.size(); ++i) {
            int featureIndex = this.featureIndices.get(i);
            Feature featureName = this.features.get(i);
            double threshold = this.thresholds.get(i);
            double featureValue = this.values.get(i);
            boolean direction = this.directions.get(i);
            sb.append("feature ").append(featureIndex).append("(").append(featureName).append(")").append(" ");
            if (direction) {
                sb.append(featureValue).append("<=").append(threshold).append(", ");
                continue;
            }
            sb.append(featureValue).append(">").append(threshold).append(", ");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Checks that = (Checks)o;
        if (!this.directions.equals(that.directions)) {
            return false;
        }
        if (!this.featureIndices.equals(that.featureIndices)) {
            return false;
        }
        if (!this.features.equals(that.features)) {
            return false;
        }
        if (!this.thresholds.equals(that.thresholds)) {
            return false;
        }
        return this.values.equals(that.values);
    }

    public int hashCode() {
        int result = this.featureIndices.hashCode();
        result = 31 * result + this.features.hashCode();
        result = 31 * result + this.thresholds.hashCode();
        result = 31 * result + this.directions.hashCode();
        result = 31 * result + this.values.hashCode();
        return result;
    }

    public Checks copy() {
        Checks copy = new Checks();
        for (int i = 0; i < this.featureIndices.size(); ++i) {
            copy.featureIndices.add(this.featureIndices.get(i));
            copy.features.add(this.features.get(i));
            copy.thresholds.add(this.thresholds.get(i));
            copy.directions.add(this.directions.get(i));
            copy.values.add(this.values.get(i));
        }
        return copy;
    }

    public static class Serializer
    extends JsonSerializer<Checks> {
        public void serialize(Checks checks, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            jsonGenerator.writeStartArray();
            for (int i = 0; i < checks.featureIndices.size(); ++i) {
                int featureIndex = checks.featureIndices.get(i);
                Feature feature = checks.features.get(i);
                double threshold = checks.thresholds.get(i);
                double featureValue = checks.values.get(i);
                boolean direction = checks.directions.get(i);
                jsonGenerator.writeStartObject();
                jsonGenerator.writeObjectField("feature", (Object)feature);
                jsonGenerator.writeNumberField("feature value", featureValue);
                jsonGenerator.writeFieldName("relation");
                if (direction) {
                    jsonGenerator.writeString("<=");
                } else {
                    jsonGenerator.writeString(">");
                }
                jsonGenerator.writeNumberField("threshold", threshold);
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
        }
    }
}

