/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.regression.linear_regression;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorView;

public class Weights
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int numFeatures;
    private transient Vector weightVector;
    private double[] serializableWeights;

    public Weights(int numFeatures) {
        this.numFeatures = numFeatures;
        this.weightVector = new DenseVector(numFeatures + 1);
        this.serializableWeights = new double[numFeatures + 1];
    }

    public Weights(int numFeatures, Vector weightVector) {
        this.numFeatures = numFeatures;
        if (weightVector.size() != numFeatures + 1) {
            throw new IllegalArgumentException("weightVector.size()!=(numFeatures + 1)");
        }
        this.weightVector = weightVector;
        this.serializableWeights = new double[numFeatures + 1];
    }

    public Vector getWeights() {
        return this.weightVector;
    }

    public void setWeightVector(Vector weightVector) {
        this.weightVector = weightVector;
    }

    public Vector getWeightsWithoutBias() {
        int length = this.numFeatures;
        return new VectorView(this.weightVector, 1, length);
    }

    public double getBias() {
        return this.weightVector.get(0);
    }

    public void setBias(double bias) {
        this.weightVector.set(0, bias);
    }

    public void setWeight(int featureIndex, double weight) {
        this.weightVector.set(featureIndex + 1, weight);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        for (int i = 0; i < this.serializableWeights.length; ++i) {
            this.serializableWeights[i] = this.weightVector.get(i);
        }
        out.writeInt(this.numFeatures);
        out.writeObject(this.serializableWeights);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.numFeatures = in.readInt();
        this.serializableWeights = (double[])in.readObject();
        this.weightVector = new DenseVector(this.numFeatures + 1);
        for (int i = 0; i < this.serializableWeights.length; ++i) {
            this.weightVector.set(i, this.serializableWeights[i]);
        }
    }

    void serialize(File file) throws Exception {
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);){
            objectOutputStream.writeObject(this);
        }
    }

    /*
     * Exception decompiling
     */
    public static Weights deserialize(File file) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        return "Weights{, numFeatures=" + this.numFeatures + ", weightVector=" + this.weightVector + '}';
    }
}

