/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.regression.linear_regression;

import edu.neu.ccs.pyramid.feature.FeatureList;
import edu.neu.ccs.pyramid.regression.Regressor;
import edu.neu.ccs.pyramid.regression.linear_regression.Weights;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.mahout.math.Vector;

public class LinearRegression
implements Regressor {
    private static final long serialVersionUID = 1L;
    private Weights weights;
    private FeatureList featureList;

    public LinearRegression(int numFeatures) {
        this.weights = new Weights(numFeatures);
    }

    public LinearRegression(int numFeatures, Vector weightVector) {
        this.weights = new Weights(numFeatures, weightVector);
    }

    public Weights getWeights() {
        return this.weights;
    }

    @Override
    public double predict(Vector vector) {
        double score = 0.0;
        score += this.weights.getBias();
        return score += this.weights.getWeightsWithoutBias().dot(vector);
    }

    public double predictWithoutBias(Vector vector) {
        return this.weights.getWeightsWithoutBias().dot(vector);
    }

    public LinearRegression deepCopy() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this);
        oos.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        LinearRegression linearRegression = (LinearRegression)ois.readObject();
        oos.close();
        ois.close();
        return linearRegression;
    }

    @Override
    public FeatureList getFeatureList() {
        return this.featureList;
    }

    void setFeatureList(FeatureList featureList) {
        this.featureList = featureList;
    }
}

