/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.regression.lad_boost;

import edu.neu.ccs.pyramid.dataset.DataSet;
import edu.neu.ccs.pyramid.dataset.RegDataSet;
import edu.neu.ccs.pyramid.optimization.gradient_boosting.GBOptimizer;
import edu.neu.ccs.pyramid.optimization.gradient_boosting.GradientBoosting;
import edu.neu.ccs.pyramid.regression.ConstantRegressor;
import edu.neu.ccs.pyramid.regression.RegressorFactory;
import edu.neu.ccs.pyramid.util.MathUtil;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LADBoostOptimizer
extends GBOptimizer {
    private static final Logger logger = LogManager.getLogger();
    private double[] labels;

    public LADBoostOptimizer(GradientBoosting boosting, DataSet dataSet, RegressorFactory factory, double[] weights, double[] labels) {
        super(boosting, dataSet, factory, weights);
        this.labels = labels;
    }

    public LADBoostOptimizer(GradientBoosting boosting, DataSet dataSet, RegressorFactory factory, double[] labels) {
        super(boosting, dataSet, factory);
        this.labels = labels;
    }

    public LADBoostOptimizer(GradientBoosting boosting, RegDataSet dataSet, RegressorFactory factory) {
        this(boosting, dataSet, factory, dataSet.getLabels());
    }

    @Override
    protected void addPriors() {
        double median = MathUtil.weightedMedian(this.labels, this.weights);
        ConstantRegressor constant = new ConstantRegressor(median);
        this.boosting.getEnsemble(0).add(constant);
    }

    @Override
    protected double[] gradient(int ensembleIndex) {
        return IntStream.range(0, this.dataSet.getNumDataPoints()).parallel().mapToDouble(i -> MathUtil.sign(this.labels[i] - (double)this.scoreMatrix.getScoresForData(i)[0])).toArray();
    }

    @Override
    protected void initializeOthers() {
    }

    @Override
    protected void updateOthers() {
    }
}

