/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.regression;

import edu.neu.ccs.pyramid.dataset.DataSet;
import edu.neu.ccs.pyramid.feature.FeatureList;
import java.io.Serializable;
import java.util.stream.IntStream;
import org.apache.mahout.math.Vector;

public interface Regressor
extends Serializable {
    public double predict(Vector var1);

    public FeatureList getFeatureList();

    default public double[] predict(DataSet dataSet) {
        return IntStream.range(0, dataSet.getNumDataPoints()).parallel().mapToDouble(i -> this.predict(dataSet.getRow(i))).toArray();
    }

    default public double[] predict(DataSet dataSet, boolean parallel) {
        IntStream intStream = IntStream.range(0, dataSet.getNumDataPoints());
        if (parallel) {
            intStream = intStream.parallel();
        }
        return intStream.mapToDouble(i -> this.predict(dataSet.getRow(i))).toArray();
    }
}

