/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.optimization.gradient_boosting;

import edu.neu.ccs.pyramid.feature.FeatureList;
import edu.neu.ccs.pyramid.optimization.gradient_boosting.Ensemble;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.mahout.math.Vector;

public class GradientBoosting
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int numEnsembles;
    protected List<Ensemble> ensembles;
    protected FeatureList featureList;

    public GradientBoosting(int numEnsembles) {
        this.numEnsembles = numEnsembles;
        this.ensembles = new ArrayList<Ensemble>();
        for (int k = 0; k < numEnsembles; ++k) {
            this.ensembles.add(new Ensemble());
        }
    }

    public int getNumEnsembles() {
        return this.numEnsembles;
    }

    public Ensemble getEnsemble(int ensembleIndex) {
        return this.ensembles.get(ensembleIndex);
    }

    public double score(Vector vector, int ensembleIndex) {
        return this.ensembles.get(ensembleIndex).score(vector);
    }

    public double[] scores(Vector vector) {
        double[] scores = new double[this.numEnsembles];
        for (int k = 0; k < this.numEnsembles; ++k) {
            scores[k] = this.score(vector, k);
        }
        return scores;
    }

    public FeatureList getFeatureList() {
        return this.featureList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GradientBoosting{");
        sb.append("numEnsembles=").append(this.numEnsembles);
        sb.append(", ensembles=").append(this.ensembles);
        sb.append('}');
        return sb.toString();
    }
}

