/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.optimization.gradient_boosting;

import edu.neu.ccs.pyramid.regression.Regressor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.mahout.math.Vector;

public class Ensemble
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<Regressor> regressors = new ArrayList<Regressor>();

    public void add(Regressor regressor) {
        this.regressors.add(regressor);
    }

    public Regressor get(int index) {
        return this.regressors.get(index);
    }

    public List<Regressor> getRegressors() {
        return this.regressors;
    }

    public double score(Vector vector) {
        double res = 0.0;
        for (Regressor regressor : this.regressors) {
            res += regressor.predict(vector);
        }
        return res;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Ensemble{");
        sb.append("regressors=").append(this.regressors);
        sb.append('}');
        return sb.toString();
    }
}

