/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.optimization;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Terminator {
    private static final Logger logger = LogManager.getLogger();
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;
    private List<Double> history;
    private int stableCounter = 0;
    private double relativeEpsilon = 0.001;
    private double absoluteEpsilon = 0.001;
    private int maxStableIterations = 5;
    private int maxIteration = 10000;
    private boolean forceTerminated = false;
    private Mode mode = Mode.STANDARD;
    private Goal goal = Goal.UNDEFINED;
    private boolean allowNaN = false;
    private boolean allowInfinite = false;
    private Operation operation = Operation.AND;
    private int minIterations = 0;

    public Terminator() {
        this.history = new ArrayList<Double>();
    }

    public void add(double value) {
        if (Double.isInfinite(value) && !this.allowInfinite) {
            throw new RuntimeException("value is infinite");
        }
        if (Double.isNaN(value) && !this.allowNaN) {
            throw new RuntimeException("value is NaN");
        }
        if (!this.isMoveValid(value) && logger.isWarnEnabled()) {
            logger.warn("goal = " + (Object)((Object)this.goal) + ", min = " + this.min + ", max = " + this.max + ", current value = " + value);
        }
        this.history.add(value);
        if (value > this.max) {
            this.max = value;
        }
        if (value < this.min) {
            this.min = value;
        }
        if (this.history.size() >= 2) {
            double previous = this.history.get(this.history.size() - 2);
            boolean condition1 = Math.abs(value - previous) <= this.relativeEpsilon * Math.abs(previous);
            boolean condition2 = Math.abs(value - previous) <= this.absoluteEpsilon;
            switch (this.operation) {
                case AND: {
                    if (condition1 && condition2) {
                        ++this.stableCounter;
                        break;
                    }
                    this.stableCounter = 0;
                    break;
                }
                case OR: {
                    if (condition1 || condition2) {
                        ++this.stableCounter;
                        break;
                    }
                    this.stableCounter = 0;
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("iteration = " + this.history.size());
            logger.debug("mode = " + (Object)((Object)this.getMode()));
            logger.debug("goal = " + (Object)((Object)this.getGoal()));
            logger.debug("value = " + this.getLastValue());
            logger.debug("previous value = " + this.getPreviousValue());
            logger.debug("min value = " + this.getMinValue());
            logger.debug("max value = " + this.getMaxValue());
            logger.debug("stable iterations = " + this.getStableIterations());
            logger.debug("is converged = " + this.isConverged());
            logger.debug("should terminate = " + this.shouldTerminate());
        }
    }

    public void setAllowNaN(boolean allowNaN) {
        this.allowNaN = allowNaN;
    }

    public void setAllowInfinite(boolean allowInfinite) {
        this.allowInfinite = allowInfinite;
    }

    public double getMaxValue() {
        return this.max;
    }

    public double getMinValue() {
        return this.min;
    }

    public int getStableIterations() {
        return this.stableCounter;
    }

    public boolean shouldTerminate() {
        boolean ter = false;
        if (this.history.size() < this.minIterations) {
            return false;
        }
        switch (this.mode) {
            case STANDARD: {
                ter = this.isConverged() || this.history.size() >= this.maxIteration || this.forceTerminated;
                break;
            }
            case FINISH_MAX_ITER: {
                ter = this.history.size() >= this.maxIteration;
            }
        }
        return ter;
    }

    public boolean isConverged() {
        return this.stableCounter >= this.maxStableIterations;
    }

    public int getNumIterations() {
        return this.history.size();
    }

    public List<Double> getHistory() {
        return this.history;
    }

    public double getLastValue() {
        return this.history.get(this.history.size() - 1);
    }

    public double getPreviousValue() {
        if (this.history.size() < 2) {
            return Double.NaN;
        }
        return this.history.get(this.history.size() - 2);
    }

    public Terminator setRelativeEpsilon(double relativeEpsilon) {
        this.relativeEpsilon = relativeEpsilon;
        return this;
    }

    public double getRelativeEpsilon() {
        return this.relativeEpsilon;
    }

    public double getAbsoluteEpsilon() {
        return this.absoluteEpsilon;
    }

    public Terminator setAbsoluteEpsilon(double absoluteEpsilon) {
        this.absoluteEpsilon = absoluteEpsilon;
        return this;
    }

    public Terminator setOperation(Operation operation) {
        this.operation = operation;
        return this;
    }

    public Terminator setMaxStableIterations(int maxStableIterations) {
        this.maxStableIterations = maxStableIterations;
        return this;
    }

    public Terminator setMinIterations(int minIterations) {
        this.minIterations = minIterations;
        return this;
    }

    public int getMaxIteration() {
        return this.maxIteration;
    }

    public Terminator setMaxIteration(int maxIteration) {
        this.maxIteration = maxIteration;
        return this;
    }

    public void forceTerminate() {
        this.forceTerminated = true;
    }

    public Mode getMode() {
        return this.mode;
    }

    public Terminator setMode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public Goal getGoal() {
        return this.goal;
    }

    public Terminator setGoal(Goal goal) {
        this.goal = goal;
        return this;
    }

    private boolean isMoveValid(double value) {
        boolean valid;
        switch (this.goal) {
            case MINIMIZE: {
                valid = value <= this.min;
                break;
            }
            case MAXIMIZE: {
                valid = value >= this.max;
                break;
            }
            case UNDEFINED: {
                valid = true;
                break;
            }
            default: {
                valid = true;
            }
        }
        return valid;
    }

    public static enum Operation {
        AND,
        OR;

    }

    public static enum Goal {
        MINIMIZE,
        MAXIMIZE,
        UNDEFINED;

    }

    public static enum Mode {
        STANDARD,
        FINISH_MAX_ITER;

    }
}

