/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.optimization;

import edu.neu.ccs.pyramid.optimization.BackTrackingLineSearcher;
import edu.neu.ccs.pyramid.optimization.GradientValueOptimizer;
import edu.neu.ccs.pyramid.optimization.Optimizable;
import edu.neu.ccs.pyramid.optimization.Optimizer;
import org.apache.mahout.math.Vector;

public class GradientDescent
extends GradientValueOptimizer
implements Optimizer {
    private BackTrackingLineSearcher lineSearcher;

    public GradientDescent(Optimizable.ByGradientValue function) {
        super(function);
        this.lineSearcher = new BackTrackingLineSearcher(function);
    }

    public BackTrackingLineSearcher getLineSearcher() {
        return this.lineSearcher;
    }

    @Override
    public void iterate() {
        Vector gradient = this.function.getGradient();
        Vector direction = gradient.times(-1.0);
        this.lineSearcher.moveAlongDirection(direction);
        this.terminator.add(this.function.getValue());
    }
}

