/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.optimization;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EarlyStopper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<Double> values;
    private List<Integer> iterations;
    private double bestValue;
    private int bestIteration = -1;
    private Goal goal;
    private int patience = 5;
    private int patienceUses = 0;
    private boolean shouldStop = false;
    private int minimumIterations = 20;

    public EarlyStopper(Goal goal, int patience) {
        this.goal = goal;
        this.patience = patience;
        this.bestValue = goal == Goal.MAXIMIZE ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        this.values = new ArrayList<Double>();
        this.iterations = new ArrayList<Integer>();
    }

    public void setMinimumIterations(int minimumIterations) {
        this.minimumIterations = minimumIterations;
    }

    public void add(int iteration, double value) {
        if (!this.shouldStop) {
            this.values.add(value);
            this.iterations.add(iteration);
            boolean better = this.isBetter(value);
            if (better) {
                this.updateWithProgress(iteration, value);
            } else {
                this.updateWithoutProgress(iteration);
            }
        }
    }

    public int getBestIteration() {
        return this.bestIteration;
    }

    public boolean shouldStop() {
        return this.shouldStop;
    }

    public double getBestValue() {
        return this.bestValue;
    }

    private boolean isBetter(double value) {
        if (this.goal == Goal.MAXIMIZE && value > this.bestValue) {
            return true;
        }
        return this.goal == Goal.MINIMIZE && value < this.bestValue;
    }

    private void updateWithProgress(int iteration, double value) {
        this.bestIteration = iteration;
        this.bestValue = value;
        this.patienceUses = 0;
    }

    private void updateWithoutProgress(int iteration) {
        ++this.patienceUses;
        if (this.patienceUses >= this.patience && iteration >= this.minimumIterations) {
            this.shouldStop = true;
        }
    }

    public String history() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.iterations.size(); ++i) {
            stringBuilder.append(this.iterations.get(i)).append(":");
            stringBuilder.append(this.values.get(i));
            if (this.iterations.get(i) == this.bestIteration) {
                stringBuilder.append("[best]");
            }
            if (i == this.iterations.size() - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public static enum Goal {
        MAXIMIZE,
        MINIMIZE;

    }
}

