/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.optimization;

import edu.neu.ccs.pyramid.optimization.BackTrackingLineSearcher;
import edu.neu.ccs.pyramid.optimization.GradientValueOptimizer;
import edu.neu.ccs.pyramid.optimization.Optimizable;
import edu.neu.ccs.pyramid.optimization.Optimizer;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;

public class ConjugateGradientDescent
extends GradientValueOptimizer
implements Optimizer {
    private BackTrackingLineSearcher lineSearcher;
    private Vector oldP;
    private Vector oldGradient;

    public ConjugateGradientDescent(Optimizable.ByGradientValue function) {
        super(function);
        this.lineSearcher = new BackTrackingLineSearcher(function);
        this.oldGradient = new DenseVector(function.getGradient());
        this.oldP = this.oldGradient.times(-1.0);
    }

    @Override
    public void iterate() {
        Vector newP;
        Vector direction = this.oldP;
        this.lineSearcher.moveAlongDirection(direction);
        Vector newGradient = this.function.getGradient();
        double beta = newGradient.dot(newGradient) / this.oldGradient.dot(this.oldGradient);
        this.oldP = newP = this.oldP.times(beta).minus(newGradient);
        this.oldGradient = newGradient;
        this.terminator.add(this.function.getValue());
    }

    public BackTrackingLineSearcher getLineSearcher() {
        return this.lineSearcher;
    }
}

