/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.multilabel_classification.thresholding;

import edu.neu.ccs.pyramid.eval.FMeasure;
import edu.neu.ccs.pyramid.eval.Precision;
import edu.neu.ccs.pyramid.eval.Recall;

public class BinaryFMeasureTuner {
    public static double tuneThreshold(double[] probabilities, int[] labels, double beta) {
        double bestThreshold = 0.0;
        double bestFBeta = Double.NEGATIVE_INFINITY;
        for (int a = 0; a <= 100; ++a) {
            double recall;
            double threshold = (double)a * 0.01;
            int[] pred = BinaryFMeasureTuner.predictionByThreshold(probabilities, threshold);
            double precision = Precision.precision(labels, pred, 1);
            double fBeta = FMeasure.fBeta(precision, recall = Recall.recall(labels, pred, 1), beta);
            if (!(fBeta > bestFBeta)) continue;
            bestThreshold = threshold;
            bestFBeta = fBeta;
        }
        return bestThreshold;
    }

    private static int[] predictionByThreshold(double[] probabilities, double threshold) {
        int[] pred = new int[probabilities.length];
        for (int i = 0; i < probabilities.length; ++i) {
            if (!(probabilities[i] > threshold)) continue;
            pred[i] = 1;
        }
        return pred;
    }
}

