/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.multilabel_classification.multi_label_logistic_regression;

import edu.neu.ccs.pyramid.classification.logistic_regression.Weights;
import edu.neu.ccs.pyramid.dataset.LabelTranslator;
import edu.neu.ccs.pyramid.dataset.MultiLabel;
import edu.neu.ccs.pyramid.dataset.MultiLabelClfDataSet;
import edu.neu.ccs.pyramid.feature.FeatureList;
import edu.neu.ccs.pyramid.multilabel_classification.MultiLabelClassifier;
import edu.neu.ccs.pyramid.util.MathUtil;
import java.io.File;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.mahout.math.Vector;

public class MLLogisticRegression
implements MultiLabelClassifier,
MultiLabelClassifier.ClassScoreEstimator {
    private static final long serialVersionUID = 1L;
    private int numClasses;
    private int numFeatures;
    private Weights weights;
    private boolean featureExtraction = false;
    private FeatureList featureList;
    private LabelTranslator labelTranslator;
    private List<MultiLabel> assignments;

    public MLLogisticRegression(int numClasses, int numFeatures, List<MultiLabel> assignments) {
        this.numClasses = numClasses;
        this.numFeatures = numFeatures;
        this.weights = new Weights(numClasses, numFeatures);
        this.assignments = assignments;
    }

    public MLLogisticRegression(int numClasses, int numFeatures, List<MultiLabel> assignments, Vector weightVector) {
        this.numClasses = numClasses;
        this.numFeatures = numFeatures;
        this.weights = new Weights(numClasses, numFeatures, weightVector);
        this.assignments = assignments;
    }

    public List<MultiLabel> getAssignments() {
        return this.assignments;
    }

    public boolean featureExtraction() {
        return this.featureExtraction;
    }

    public void setFeatureExtraction(boolean featureExtraction) {
        this.featureExtraction = featureExtraction;
    }

    public Weights getWeights() {
        return this.weights;
    }

    public int getNumFeatures() {
        return this.numFeatures;
    }

    @Override
    public int getNumClasses() {
        return this.numClasses;
    }

    @Override
    public MultiLabel predict(Vector vector) {
        double maxScore = Double.NEGATIVE_INFINITY;
        MultiLabel prediction = null;
        double[] classeScores = this.predictClassScores(vector);
        for (MultiLabel assignment : this.assignments) {
            double score = this.calAssignmentScore(assignment, classeScores);
            if (!(score > maxScore)) continue;
            maxScore = score;
            prediction = assignment;
        }
        return prediction;
    }

    @Override
    public double predictClassScore(Vector dataPoint, int k) {
        double score = 0.0;
        score += this.weights.getBiasForClass(k);
        return score += this.weights.getWeightsWithoutBiasForClass(k).dot(dataPoint);
    }

    @Override
    public double[] predictClassScores(Vector dataPoint) {
        double[] scores = new double[this.numClasses];
        for (int k = 0; k < this.numClasses; ++k) {
            scores[k] = this.predictClassScore(dataPoint, k);
        }
        return scores;
    }

    public double predictAssignmentProb(Vector vector, MultiLabel assignment) {
        if (!this.assignments.contains(assignment)) {
            return 0.0;
        }
        double[] classScores = this.predictClassScores(vector);
        double[] assignmentScores = new double[this.assignments.size()];
        for (int i = 0; i < this.assignments.size(); ++i) {
            assignmentScores[i] = this.calAssignmentScore(this.assignments.get(i), classScores);
        }
        double logNumerator = this.calAssignmentScore(assignment, classScores);
        double logDenominator = MathUtil.logSumExp(assignmentScores);
        double pro = Math.exp(logNumerator - logDenominator);
        return pro;
    }

    double[] predictAssignmentProbs(Vector vector) {
        double[] classScores = this.predictClassScores(vector);
        double[] assignmentScores = new double[this.assignments.size()];
        for (int i = 0; i < this.assignments.size(); ++i) {
            assignmentScores[i] = this.calAssignmentScore(this.assignments.get(i), classScores);
        }
        double logDenominator = MathUtil.logSumExp(assignmentScores);
        double[] assignmentProbs = new double[this.assignments.size()];
        for (int i = 0; i < this.assignments.size(); ++i) {
            double pro;
            double logNumerator = assignmentScores[i];
            assignmentProbs[i] = pro = Math.exp(logNumerator - logDenominator);
        }
        return assignmentProbs;
    }

    public double[] predictClassProbs(Vector vector) {
        double[] assignmentProbs = this.predictAssignmentProbs(vector);
        double[] classProbs = new double[this.numClasses];
        for (int a = 0; a < this.assignments.size(); ++a) {
            MultiLabel assignment = this.assignments.get(a);
            double prob = assignmentProbs[a];
            for (Integer label : assignment.getMatchedLabels()) {
                double oldProb = classProbs[label];
                classProbs[label.intValue()] = oldProb + prob;
            }
        }
        return classProbs;
    }

    public double predictClassProb(Vector vector, int classIndex) {
        return this.predictClassProbs(vector)[classIndex];
    }

    double calAssignmentScore(MultiLabel assignment, double[] classScores) {
        double score = 0.0;
        for (Integer label : assignment.getMatchedLabels()) {
            score += classScores[label];
        }
        return score;
    }

    double[] calAssignmentScores(double[] classScores) {
        double[] scores = new double[this.assignments.size()];
        for (int a = 0; a < scores.length; ++a) {
            scores[a] = this.calAssignmentScore(this.assignments.get(a), classScores);
        }
        return scores;
    }

    double[] calAssignmentProbs(double[] assignmentScores) {
        int numAssignments = this.assignments.size();
        double[] assignmentProbs = new double[numAssignments];
        double logDenominator = MathUtil.logSumExp(assignmentScores);
        for (int a = 0; a < numAssignments; ++a) {
            double pro;
            double logNumerator = assignmentScores[a];
            assignmentProbs[a] = pro = Math.exp(logNumerator - logDenominator);
        }
        return assignmentProbs;
    }

    double logLikelihood(Vector vector, MultiLabel multiLabel) {
        double[] classScores = this.predictClassScores(vector);
        int numAssignments = this.assignments.size();
        double[] assignmentScores = this.calAssignmentScores(classScores);
        double logDenominator = MathUtil.logSumExp(assignmentScores);
        double logNumerator = this.calAssignmentScore(multiLabel, classScores);
        return logNumerator - logDenominator;
    }

    double dataSetLogLikelihood(MultiLabelClfDataSet dataSet) {
        MultiLabel[] multiLabels = dataSet.getMultiLabels();
        return IntStream.range(0, dataSet.getNumDataPoints()).parallel().mapToDouble(i -> this.logLikelihood(dataSet.getRow(i), multiLabels[i])).sum();
    }

    /*
     * Exception decompiling
     */
    public static MLLogisticRegression deserialize(File file) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    double[] calClassProbs(double[] assignmentProbs) {
        double[] classProbs = new double[this.numClasses];
        int numAssignments = this.assignments.size();
        for (int a = 0; a < numAssignments; ++a) {
            MultiLabel assignment = this.assignments.get(a);
            double prob = assignmentProbs[a];
            for (Integer label : assignment.getMatchedLabels()) {
                int n = label;
                classProbs[n] = classProbs[n] + prob;
            }
        }
        return classProbs;
    }

    @Override
    public FeatureList getFeatureList() {
        return this.featureList;
    }

    public void setFeatureList(FeatureList featureList) {
        this.featureList = featureList;
    }

    @Override
    public LabelTranslator getLabelTranslator() {
        return this.labelTranslator;
    }

    public void setLabelTranslator(LabelTranslator labelTranslator) {
        this.labelTranslator = labelTranslator;
    }
}

