/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.multilabel_classification.imlgb;

import edu.neu.ccs.pyramid.regression.regression_tree.LeafOutputCalculator;

public class IMLGBLeafOutputCalculator
implements LeafOutputCalculator {
    private int numClasses;

    public IMLGBLeafOutputCalculator(int numClasses) {
        this.numClasses = numClasses;
    }

    @Override
    public double getLeafOutput(double[] probabilities, double[] labels) {
        double numerator = 0.0;
        double denominator = 0.0;
        for (int i = 0; i < probabilities.length; ++i) {
            double label = labels[i];
            numerator += label * probabilities[i];
            denominator += Math.abs(label) * (1.0 - Math.abs(label)) * probabilities[i];
        }
        double out = denominator == 0.0 ? 0.0 : (double)(this.numClasses - 1) * numerator / ((double)this.numClasses * denominator);
        if (out > 2.0) {
            out = 2.0;
        }
        if (out < -2.0) {
            out = -2.0;
        }
        if (Double.isNaN(out)) {
            throw new RuntimeException("leaf value is NaN");
        }
        if (Double.isInfinite(out)) {
            throw new RuntimeException("leaf value is Infinite");
        }
        return out;
    }
}

