/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.multilabel_classification.hmlgb;

import edu.neu.ccs.pyramid.dataset.LabelTranslator;
import edu.neu.ccs.pyramid.dataset.MultiLabel;
import edu.neu.ccs.pyramid.feature.FeatureList;
import edu.neu.ccs.pyramid.multilabel_classification.MultiLabelClassifier;
import edu.neu.ccs.pyramid.regression.Regressor;
import edu.neu.ccs.pyramid.util.MathUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.mahout.math.Vector;

public class HMLGradientBoosting
implements MultiLabelClassifier,
MultiLabelClassifier.ClassScoreEstimator {
    private static final long serialVersionUID = 2L;
    private List<List<Regressor>> regressors;
    private int numClasses;
    private List<MultiLabel> assignments;
    private FeatureList featureList;
    private LabelTranslator labelTranslator;

    public HMLGradientBoosting(int numClasses, List<MultiLabel> assignments) {
        this.numClasses = numClasses;
        this.assignments = assignments;
        this.regressors = new ArrayList<List<Regressor>>(this.numClasses);
        for (int k = 0; k < this.numClasses; ++k) {
            ArrayList regressorsClassK = new ArrayList();
            this.regressors.add(regressorsClassK);
        }
    }

    @Override
    public int getNumClasses() {
        return this.numClasses;
    }

    void addRegressor(Regressor regressor, int k) {
        this.regressors.get(k).add(regressor);
    }

    List<MultiLabel> getAssignments() {
        return this.assignments;
    }

    @Override
    public MultiLabel predict(Vector vector) {
        double maxScore = Double.NEGATIVE_INFINITY;
        MultiLabel prediction = null;
        double[] classeScores = this.predictClassScores(vector);
        for (MultiLabel assignment : this.assignments) {
            double score = this.calAssignmentScore(assignment, classeScores);
            if (!(score > maxScore)) continue;
            maxScore = score;
            prediction = assignment;
        }
        return prediction;
    }

    public double predictAssignmentProb(Vector vector, MultiLabel assignment) {
        if (!this.assignments.contains(assignment)) {
            return 0.0;
        }
        double[] classScores = this.predictClassScores(vector);
        double[] assignmentScores = new double[this.assignments.size()];
        for (int i = 0; i < this.assignments.size(); ++i) {
            assignmentScores[i] = this.calAssignmentScore(this.assignments.get(i), classScores);
        }
        double logNumerator = this.calAssignmentScore(assignment, classScores);
        double logDenominator = MathUtil.logSumExp(assignmentScores);
        double pro = Math.exp(logNumerator - logDenominator);
        return pro;
    }

    double[] predictAssignmentProbs(Vector vector) {
        double[] classScores = this.predictClassScores(vector);
        double[] assignmentScores = new double[this.assignments.size()];
        for (int i = 0; i < this.assignments.size(); ++i) {
            assignmentScores[i] = this.calAssignmentScore(this.assignments.get(i), classScores);
        }
        double logDenominator = MathUtil.logSumExp(assignmentScores);
        double[] assignmentProbs = new double[this.assignments.size()];
        for (int i = 0; i < this.assignments.size(); ++i) {
            double pro;
            double logNumerator = assignmentScores[i];
            assignmentProbs[i] = pro = Math.exp(logNumerator - logDenominator);
        }
        return assignmentProbs;
    }

    public double[] predictClassProbs(Vector vector) {
        double[] assignmentProbs = this.predictAssignmentProbs(vector);
        double[] classProbs = new double[this.numClasses];
        for (int a = 0; a < this.assignments.size(); ++a) {
            MultiLabel assignment = this.assignments.get(a);
            double prob = assignmentProbs[a];
            for (Integer label : assignment.getMatchedLabels()) {
                double oldProb = classProbs[label];
                classProbs[label.intValue()] = oldProb + prob;
            }
        }
        return classProbs;
    }

    public double predictClassProb(Vector vector, int classIndex) {
        return this.predictClassProbs(vector)[classIndex];
    }

    @Override
    public double predictClassScore(Vector vector, int k) {
        List<Regressor> regressorsClassK = this.regressors.get(k);
        double score = 0.0;
        for (Regressor regressor : regressorsClassK) {
            score += regressor.predict(vector);
        }
        return score;
    }

    @Override
    public double[] predictClassScores(Vector vector) {
        int numClasses = this.numClasses;
        double[] scores = new double[numClasses];
        for (int k = 0; k < numClasses; ++k) {
            scores[k] = this.predictClassScore(vector, k);
        }
        return scores;
    }

    double calAssignmentScore(MultiLabel assignment, double[] classScores) {
        double score = 0.0;
        for (Integer label : assignment.getMatchedLabels()) {
            score += classScores[label];
        }
        return score;
    }

    public List<Regressor> getRegressors(int k) {
        return this.regressors.get(k);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int k = 0; k < this.numClasses; ++k) {
            sb.append("for class ").append(k).append("\n");
            List<Regressor> trees = this.getRegressors(k);
            for (int i = 0; i < trees.size(); ++i) {
                sb.append("tree ").append(i).append(":");
                sb.append(trees.get(i).toString());
            }
        }
        return sb.toString();
    }

    @Override
    public void serialize(String file) throws Exception {
        this.serialize(new File(file));
    }

    @Override
    public void serialize(File file) throws Exception {
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);){
            objectOutputStream.writeObject(this);
        }
    }

    public static HMLGradientBoosting deserialize(String file) throws Exception {
        return HMLGradientBoosting.deserialize(new File(file));
    }

    /*
     * Exception decompiling
     */
    public static HMLGradientBoosting deserialize(File file) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public FeatureList getFeatureList() {
        return this.featureList;
    }

    void setFeatureList(FeatureList featureList) {
        this.featureList = featureList;
    }

    @Override
    public LabelTranslator getLabelTranslator() {
        return this.labelTranslator;
    }

    void setLabelTranslator(LabelTranslator labelTranslator) {
        this.labelTranslator = labelTranslator;
    }
}

