/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.multilabel_classification.hmlgb;

import edu.neu.ccs.pyramid.dataset.MultiLabelClfDataSet;
import edu.neu.ccs.pyramid.util.Sampling;
import java.util.stream.IntStream;

public class HMLGBConfig {
    private MultiLabelClfDataSet dataSet;
    private double learningRate;
    private int numLeaves;
    private int minDataPerLeaf;
    private int[] activeFeatures;
    private int[] activeDataPoints;
    private int numSplitIntervals;
    private boolean usePrior;

    boolean usePrior() {
        return this.usePrior;
    }

    MultiLabelClfDataSet getDataSet() {
        return this.dataSet;
    }

    double getLearningRate() {
        return this.learningRate;
    }

    int getNumLeaves() {
        return this.numLeaves;
    }

    int getMinDataPerLeaf() {
        return this.minDataPerLeaf;
    }

    int[] getActiveFeatures() {
        return this.activeFeatures;
    }

    void setActiveFeatures(int[] activeFeatures) {
        this.activeFeatures = activeFeatures;
    }

    int[] getActiveDataPoints() {
        return this.activeDataPoints;
    }

    void setActiveDataPoints(int[] activeDataPoints) {
        this.activeDataPoints = activeDataPoints;
    }

    int getNumSplitIntervals() {
        return this.numSplitIntervals;
    }

    private HMLGBConfig(Builder builder) {
        this.dataSet = builder.dataSet;
        this.learningRate = builder.learningRate;
        this.numLeaves = builder.numLeaves;
        this.minDataPerLeaf = builder.minDataPerLeaf;
        double dataSamplingRate = builder.dataSamplingRate;
        double featureSamplingRate = builder.featureSamplingRate;
        this.numSplitIntervals = builder.numSplitIntervals;
        this.usePrior = builder.usePrior;
        int numDataPoints = this.dataSet.getNumDataPoints();
        this.activeDataPoints = dataSamplingRate == 1.0 ? IntStream.range(0, numDataPoints).toArray() : Sampling.sampleByPercentage(numDataPoints, dataSamplingRate);
        this.activeFeatures = featureSamplingRate == 1.0 ? IntStream.range(0, this.dataSet.getNumFeatures()).toArray() : Sampling.sampleByPercentage(this.dataSet.getNumFeatures(), featureSamplingRate);
    }

    public static class Builder {
        private MultiLabelClfDataSet dataSet;
        int numLeaves = 2;
        double learningRate = 1.0;
        int minDataPerLeaf = 1;
        double dataSamplingRate = 1.0;
        double featureSamplingRate = 1.0;
        private int numSplitIntervals = 100;
        boolean usePrior = true;

        public Builder(MultiLabelClfDataSet dataSet) {
            this.dataSet = dataSet;
        }

        public Builder numLeaves(int numLeaves) {
            this.numLeaves = numLeaves;
            return this;
        }

        public Builder learningRate(double learningRate) {
            this.learningRate = learningRate;
            return this;
        }

        public Builder minDataPerLeaf(int minDataPerLeaf) {
            this.minDataPerLeaf = minDataPerLeaf;
            return this;
        }

        public Builder dataSamplingRate(double dataSamplingRate) {
            this.dataSamplingRate = dataSamplingRate;
            return this;
        }

        public Builder featureSamplingRate(double featureSamplingRate) {
            this.featureSamplingRate = featureSamplingRate;
            return this;
        }

        public Builder numSplitIntervals(int numSplitIntervals) {
            this.numSplitIntervals = numSplitIntervals;
            return this;
        }

        public Builder usePrior(boolean usePrior) {
            this.usePrior = usePrior;
            return this;
        }

        public HMLGBConfig build() {
            return new HMLGBConfig(this);
        }
    }
}

