/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.multilabel_classification.crf;

import edu.neu.ccs.pyramid.multilabel_classification.crf.CRFInspector;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorView;

public class Weights
implements Serializable {
    private static final long serialVersionUID = 3L;
    private int numFeatures;
    private int numClasses;
    private int numWeightsForFeatures;
    private int numWeightsForLabels;
    private transient Vector weightVector;
    private double[] serializableWeights;

    public Weights(int numClasses, int numFeatures) {
        this.numClasses = numClasses;
        this.numFeatures = numFeatures;
        this.numWeightsForFeatures = (numFeatures + 1) * numClasses;
        this.numWeightsForLabels = numClasses * (numClasses - 1) / 2 * 4;
        this.weightVector = new DenseVector(this.numWeightsForFeatures + this.numWeightsForLabels);
        this.serializableWeights = new double[this.numWeightsForFeatures + this.numWeightsForLabels];
    }

    public Weights deepCopy() {
        Weights copy = new Weights(this.numClasses, this.numFeatures);
        copy.weightVector = new DenseVector(this.weightVector);
        return copy;
    }

    public int getClassIndex(int parameterIndex) {
        return parameterIndex / (this.numFeatures + 1);
    }

    public int getFeatureIndex(int parameterIndex) {
        return parameterIndex - this.getClassIndex(parameterIndex) * (this.numFeatures + 1) - 1;
    }

    public int totalSize() {
        return this.weightVector.size();
    }

    public void setWeightVector(Vector weightVector) {
        if (weightVector.size() != this.numWeightsForFeatures + this.numWeightsForLabels) {
            throw new IllegalArgumentException("given vector size is wrong: " + weightVector.size());
        }
        this.weightVector = weightVector;
    }

    public Vector getAllWeights() {
        return this.weightVector;
    }

    public Vector getAllLabelPairWeights() {
        return new VectorView(this.weightVector, this.numWeightsForFeatures, this.numWeightsForLabels);
    }

    public Vector getWeightsForClass(int k) {
        int start = (this.numFeatures + 1) * k;
        int length = this.numFeatures + 1;
        return new VectorView(this.weightVector, start, length);
    }

    public Vector getWeightsWithoutBiasForClass(int k) {
        int start = (this.numFeatures + 1) * k + 1;
        int length = this.numFeatures;
        return new VectorView(this.weightVector, start, length);
    }

    public double getBiasForClass(int k) {
        int start = (this.numFeatures + 1) * k;
        return this.weightVector.get(start);
    }

    public double getWeightForIndex(int index) {
        return this.weightVector.get(index);
    }

    public int getNumWeightsForFeatures() {
        return this.numWeightsForFeatures;
    }

    public int getNumWeightsForLabels() {
        return this.numWeightsForLabels;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Weights{\n");
        for (int k = 0; k < this.numClasses; ++k) {
            sb.append("for class ").append(k).append(":").append("\n");
            sb.append("bias = " + this.getBiasForClass(k)).append(",");
            sb.append("weights = " + this.getWeightsWithoutBiasForClass(k)).append("\n");
        }
        int start = this.numWeightsForFeatures;
        for (int l1 = 0; l1 < this.numClasses; ++l1) {
            for (int l2 = l1 + 1; l2 < this.numClasses; ++l2) {
                sb.append("label pair weights: (" + l1 + ", " + l2 + ")\t");
                sb.append("W(0,0): " + this.weightVector.get(start) + "\tW(1,0): " + this.weightVector.get(start + 1) + "\tW(0,1): " + this.weightVector.get(start + 2) + "\tW(1,1): " + this.weightVector.get(start + 3));
                sb.append("\n");
                start += 4;
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public List<CRFInspector.PairWeight> printPairWeights() {
        ArrayList<CRFInspector.PairWeight> list = new ArrayList<CRFInspector.PairWeight>();
        int start = this.numWeightsForFeatures;
        for (int l1 = 0; l1 < this.numClasses; ++l1) {
            for (int l2 = l1 + 1; l2 < this.numClasses; ++l2) {
                list.add(new CRFInspector.PairWeight(l1, l2, false, false, this.weightVector.get(start)));
                list.add(new CRFInspector.PairWeight(l1, l2, true, false, this.weightVector.get(start + 1)));
                list.add(new CRFInspector.PairWeight(l1, l2, false, true, this.weightVector.get(start + 2)));
                list.add(new CRFInspector.PairWeight(l1, l2, true, true, this.weightVector.get(start + 3)));
                start += 4;
            }
        }
        return list;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        for (int i = 0; i < this.serializableWeights.length; ++i) {
            this.serializableWeights[i] = this.weightVector.get(i);
        }
        out.writeInt(this.numClasses);
        out.writeInt(this.numFeatures);
        out.writeInt(this.numWeightsForFeatures);
        out.writeInt(this.numWeightsForLabels);
        out.writeObject(this.serializableWeights);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.numClasses = in.readInt();
        this.numFeatures = in.readInt();
        this.numWeightsForFeatures = in.readInt();
        this.numWeightsForLabels = in.readInt();
        this.serializableWeights = (double[])in.readObject();
        this.weightVector = new DenseVector(this.numWeightsForFeatures + this.numWeightsForLabels);
        for (int i = 0; i < this.serializableWeights.length; ++i) {
            this.weightVector.set(i, this.serializableWeights[i]);
        }
    }

    void serialize(File file) throws Exception {
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);){
            objectOutputStream.writeObject(this);
        }
    }

    /*
     * Exception decompiling
     */
    public static Weights deserialize(File file) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

