/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.multilabel_classification.crf;

import edu.neu.ccs.pyramid.dataset.MultiLabel;
import edu.neu.ccs.pyramid.dataset.MultiLabelClfDataSet;
import edu.neu.ccs.pyramid.eval.SafeDivide;
import edu.neu.ccs.pyramid.multilabel_classification.crf.CMLCRF;
import edu.neu.ccs.pyramid.multilabel_classification.crf.KLLoss;
import edu.neu.ccs.pyramid.optimization.GradientDescent;
import edu.neu.ccs.pyramid.optimization.GradientValueOptimizer;
import edu.neu.ccs.pyramid.optimization.LBFGS;
import edu.neu.ccs.pyramid.optimization.Terminator;
import edu.neu.ccs.pyramid.util.MathUtil;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NoiseOptimizer {
    private static final Logger logger = LogManager.getLogger();
    private MultiLabelClfDataSet dataSet;
    private CMLCRF crf;
    private double[][] targets;
    private double[][] transformProbs;
    private List<MultiLabel> combinations;
    private double variance;
    private double[][] probabilities;
    private Terminator terminator;
    private String optimizer = "LBFGS";
    private double[] alphas;

    public NoiseOptimizer(MultiLabelClfDataSet dataSet, CMLCRF crf, double variance) {
        this.dataSet = dataSet;
        this.variance = variance;
        this.crf = crf;
        this.combinations = crf.getSupportCombinations();
        this.targets = new double[dataSet.getNumDataPoints()][this.combinations.size()];
        this.probabilities = new double[dataSet.getNumDataPoints()][this.combinations.size()];
        this.transformProbs = new double[dataSet.getNumDataPoints()][this.combinations.size()];
        this.alphas = new double[dataSet.getNumClasses()];
        Arrays.fill(this.alphas, 0.9);
        this.updateTransformProbs();
        this.updateProbabilities();
        this.terminator = new Terminator();
        if (logger.isDebugEnabled()) {
            logger.debug("finish constructor");
        }
    }

    public void setOptimizer(String optimizer) {
        this.optimizer = optimizer;
    }

    private void updateProbabilities(int dataPointIndex) {
        this.probabilities[dataPointIndex] = this.crf.predictCombinationProbs(this.dataSet.getRow(dataPointIndex));
    }

    private void updateProbabilities() {
        if (logger.isDebugEnabled()) {
            logger.debug("start updateProbabilities()");
        }
        IntStream.range(0, this.dataSet.getNumDataPoints()).parallel().forEach(this::updateProbabilities);
        if (logger.isDebugEnabled()) {
            logger.debug("finish updateProbabilities()");
        }
    }

    private void updateTransformProbs() {
        IntStream.range(0, this.dataSet.getNumDataPoints()).parallel().forEach(this::updateTransformProbs);
    }

    private void updateTransformProbs(int dataPoint) {
        for (int c = 0; c < this.combinations.size(); ++c) {
            this.updateTransformProb(dataPoint, c);
        }
    }

    private void updateTransformProb(int dataPoint, int comIndex) {
        MultiLabel candidate;
        MultiLabel labels = this.dataSet.getMultiLabels()[dataPoint];
        if (labels.isSubsetOf(candidate = this.combinations.get(comIndex))) {
            double prod = 1.0;
            for (int l : candidate.getMatchedLabels()) {
                if (labels.matchClass(l)) {
                    prod *= this.alphas[l];
                    continue;
                }
                prod *= 1.0 - this.alphas[l];
            }
            this.transformProbs[dataPoint][comIndex] = prod;
        } else {
            this.transformProbs[dataPoint][comIndex] = 0.0;
        }
    }

    private void updateAlphas() {
        IntStream.range(0, this.dataSet.getNumClasses()).parallel().forEach(this::updateAlpha);
    }

    private void updateAlpha(int classIndex) {
        double numerator = 0.0;
        double denominator = 0.0;
        MultiLabel[] multiLabels = this.dataSet.getMultiLabels();
        for (int c = 0; c < this.combinations.size(); ++c) {
            if (!this.combinations.get(c).matchClass(classIndex)) continue;
            for (int i = 0; i < this.dataSet.getNumDataPoints(); ++i) {
                MultiLabel multiLabel = multiLabels[i];
                denominator += this.targets[i][c];
                if (!multiLabel.matchClass(classIndex)) continue;
                numerator += this.targets[i][c];
            }
        }
        this.alphas[classIndex] = SafeDivide.divide(numerator, denominator, 1.0);
    }

    private void updateTargets(int dataPointIndex) {
        double[] probs = this.probabilities[dataPointIndex];
        double[] product = new double[probs.length];
        double[] s = this.transformProbs[dataPointIndex];
        for (int j = 0; j < probs.length; ++j) {
            product[j] = probs[j] * s[j];
        }
        double denominator = MathUtil.arraySum(product);
        for (int j = 0; j < probs.length; ++j) {
            this.targets[dataPointIndex][j] = product[j] / denominator;
        }
    }

    public void optimize() {
        while (!this.terminator.shouldTerminate()) {
            this.iterate();
        }
    }

    public Terminator getTerminator() {
        return this.terminator;
    }

    public void iterate() {
        this.updateTargets();
        System.out.println("finish updateTargets ");
        System.out.println("objective = " + this.objective());
        this.updateAlphas();
        System.out.println("finish updateAlphas ");
        System.out.println("objective = " + this.objective());
        this.updateTransformProbs();
        System.out.println("finish updateTransformProbs ");
        System.out.println("objective = " + this.objective());
        this.updateModel();
        System.out.println("finish updateModel ");
        System.out.println("objective = " + this.objective());
        this.updateProbabilities();
        System.out.println("finish updateProbabilities ");
        double objective = this.objective();
        System.out.println("objective = " + objective);
        this.terminator.add(objective);
        System.out.println("alphas = " + Arrays.toString(this.alphas));
    }

    public void iteratePartial(int modelIterations) {
        this.updateTargets();
        System.out.println("finish updateTargets ");
        System.out.println("objective = " + this.objective());
        this.updateAlphas();
        System.out.println("finish updateAlphas ");
        System.out.println("objective = " + this.objective());
        this.updateTransformProbs();
        System.out.println("finish updateTransformProbs ");
        System.out.println("objective = " + this.objective());
        this.updateModelPartial(modelIterations);
        System.out.println("finish updateModel ");
        System.out.println("objective = " + this.objective());
        this.updateProbabilities();
        System.out.println("finish updateProbabilities ");
        double objective = this.objective();
        System.out.println("objective = " + objective);
        this.terminator.add(objective);
        System.out.println("alphas = " + Arrays.toString(this.alphas));
    }

    private void updateTargets() {
        if (logger.isDebugEnabled()) {
            logger.debug("start updateTargets()");
        }
        IntStream.range(0, this.dataSet.getNumDataPoints()).parallel().forEach(this::updateTargets);
        if (logger.isDebugEnabled()) {
            logger.debug("finish updateTargets()");
        }
    }

    private void updateModel() {
        if (logger.isDebugEnabled()) {
            logger.debug("start updateModel()");
        }
        KLLoss klLoss = new KLLoss(this.crf, this.dataSet, this.targets, this.variance);
        GradientValueOptimizer opt = null;
        switch (this.optimizer) {
            case "LBFGS": {
                opt = new LBFGS(klLoss);
                break;
            }
            case "GD": {
                opt = new GradientDescent(klLoss);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown");
            }
        }
        opt.optimize();
        if (logger.isDebugEnabled()) {
            logger.debug("finish updateModel()");
        }
    }

    private void updateModelPartial(int modelIterations) {
        if (logger.isDebugEnabled()) {
            logger.debug("start updateModelPartial()");
        }
        KLLoss klLoss = new KLLoss(this.crf, this.dataSet, this.targets, this.variance);
        GradientValueOptimizer opt = null;
        switch (this.optimizer) {
            case "LBFGS": {
                opt = new LBFGS(klLoss);
                break;
            }
            case "GD": {
                opt = new GradientDescent(klLoss);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown");
            }
        }
        opt.getTerminator().setMaxIteration(modelIterations);
        opt.optimize();
        if (logger.isDebugEnabled()) {
            logger.debug("finish updateModelPartial()");
        }
    }

    private double objective(int dataPointIndex) {
        double sum = 0.0;
        double[] p = this.probabilities[dataPointIndex];
        double[] s = this.transformProbs[dataPointIndex];
        for (int j = 0; j < p.length; ++j) {
            sum += p[j] * s[j];
        }
        return -Math.log(sum);
    }

    public double objective() {
        if (logger.isDebugEnabled()) {
            logger.debug("start objective()");
        }
        double obj = IntStream.range(0, this.dataSet.getNumDataPoints()).parallel().mapToDouble(this::objective).sum();
        if (logger.isDebugEnabled()) {
            logger.debug("finish obj");
        }
        double penalty = this.penalty();
        if (logger.isDebugEnabled()) {
            logger.debug("finish penalty");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("finish objective()");
        }
        return obj + penalty;
    }

    public String objectiveDetail() {
        double obj = IntStream.range(0, this.dataSet.getNumDataPoints()).parallel().mapToDouble(this::objective).sum();
        double penalty = this.penalty();
        StringBuilder sb = new StringBuilder();
        sb.append("empirical loss = " + obj).append("\n");
        sb.append("regularization penalty = " + penalty).append("\n");
        sb.append("total objective = " + (obj + penalty)).append("\n");
        return sb.toString();
    }

    private double penalty() {
        KLLoss klLoss = new KLLoss(this.crf, this.dataSet, this.targets, this.variance);
        return klLoss.getPenalty();
    }
}

