/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.multilabel_classification.crf;

import edu.neu.ccs.pyramid.dataset.MultiLabel;
import edu.neu.ccs.pyramid.dataset.MultiLabelClfDataSet;
import edu.neu.ccs.pyramid.multilabel_classification.MLScorer;
import edu.neu.ccs.pyramid.multilabel_classification.crf.CMLCRF;
import edu.neu.ccs.pyramid.multilabel_classification.crf.KLLoss;
import edu.neu.ccs.pyramid.optimization.GradientDescent;
import edu.neu.ccs.pyramid.optimization.GradientValueOptimizer;
import edu.neu.ccs.pyramid.optimization.LBFGS;
import edu.neu.ccs.pyramid.optimization.Terminator;
import edu.neu.ccs.pyramid.util.MathUtil;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogRiskOptimizer {
    private static final Logger logger = LogManager.getLogger();
    private MultiLabelClfDataSet dataSet;
    private CMLCRF crf;
    private double[][] targets;
    private List<MultiLabel> combinations;
    private double[][] scores;
    private double variance;
    private double[][] probabilities;
    private MLScorer mlScorer;
    private boolean expScore = false;
    private boolean multiplyScore = false;
    private double scoreMultiplier = 1.0;
    private Terminator terminator;
    private String optimizer = "LBFGS";

    public LogRiskOptimizer(MultiLabelClfDataSet dataSet, MLScorer mlScorer, CMLCRF crf, double variance, boolean expScore, boolean multiplyScore, double scoreMultiplier, double power) {
        this.dataSet = dataSet;
        this.variance = variance;
        this.crf = crf;
        this.mlScorer = mlScorer;
        this.combinations = crf.getSupportCombinations();
        this.scores = new double[dataSet.getNumDataPoints()][this.combinations.size()];
        for (int i = 0; i < dataSet.getNumDataPoints(); ++i) {
            for (int j = 0; j < this.combinations.size(); ++j) {
                double f;
                MultiLabel truth = dataSet.getMultiLabels()[i];
                MultiLabel combination = this.combinations.get(j);
                this.scores[i][j] = f = mlScorer.score(dataSet.getNumClasses(), truth, combination);
                if (expScore) {
                    this.scores[i][j] = Math.exp(this.scores[i][j]);
                }
                if (multiplyScore) {
                    this.scores[i][j] = this.scores[i][j] * scoreMultiplier;
                }
                this.scores[i][j] = Math.pow(this.scores[i][j], power);
            }
        }
        this.targets = new double[dataSet.getNumDataPoints()][this.combinations.size()];
        this.probabilities = new double[dataSet.getNumDataPoints()][this.combinations.size()];
        this.updateProbabilities();
        this.terminator = new Terminator();
        if (logger.isDebugEnabled()) {
            logger.debug("finish constructor");
        }
        double sum = 0.0;
        for (int i = 0; i < dataSet.getNumDataPoints(); ++i) {
            sum += MathUtil.arraySum(this.scores[i]);
        }
    }

    public void setOptimizer(String optimizer) {
        this.optimizer = optimizer;
    }

    private void updateProbabilities(int dataPointIndex) {
        this.probabilities[dataPointIndex] = this.crf.predictCombinationProbs(this.dataSet.getRow(dataPointIndex));
    }

    private void updateProbabilities() {
        if (logger.isDebugEnabled()) {
            logger.debug("start updateProbabilities()");
        }
        IntStream.range(0, this.dataSet.getNumDataPoints()).parallel().forEach(this::updateProbabilities);
        if (logger.isDebugEnabled()) {
            logger.debug("finish updateProbabilities()");
        }
    }

    private void updateTargets(int dataPointIndex) {
        double[] probs = this.probabilities[dataPointIndex];
        double[] product = new double[probs.length];
        double[] s = this.scores[dataPointIndex];
        for (int j = 0; j < probs.length; ++j) {
            product[j] = probs[j] * s[j];
        }
        double denominator = MathUtil.arraySum(product);
        for (int j = 0; j < probs.length; ++j) {
            this.targets[dataPointIndex][j] = product[j] / denominator;
        }
    }

    public void optimize() {
        while (!this.terminator.shouldTerminate()) {
            this.iterate();
        }
    }

    public Terminator getTerminator() {
        return this.terminator;
    }

    public void iterate() {
        this.updateTargets();
        this.updateModel();
        this.updateProbabilities();
        double objective = this.objective();
        System.out.println("objective = " + objective);
        this.terminator.add(objective);
    }

    public void iteratePartial() {
        this.updateTargets();
        this.updateModelPartial();
        this.updateProbabilities();
    }

    private void updateTargets() {
        if (logger.isDebugEnabled()) {
            logger.debug("start updateTargets()");
        }
        IntStream.range(0, this.dataSet.getNumDataPoints()).parallel().forEach(this::updateTargets);
        if (logger.isDebugEnabled()) {
            logger.debug("finish updateTargets()");
        }
    }

    private void updateModel() {
        if (logger.isDebugEnabled()) {
            logger.debug("start updateModel()");
        }
        KLLoss klLoss = new KLLoss(this.crf, this.dataSet, this.targets, this.variance);
        GradientValueOptimizer opt = null;
        switch (this.optimizer) {
            case "LBFGS": {
                opt = new LBFGS(klLoss);
                break;
            }
            case "GD": {
                opt = new GradientDescent(klLoss);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown");
            }
        }
        opt.optimize();
        if (logger.isDebugEnabled()) {
            logger.debug("finish updateModel()");
        }
    }

    private void updateModelPartial() {
        if (logger.isDebugEnabled()) {
            logger.debug("start updateModelPartial()");
        }
        KLLoss klLoss = new KLLoss(this.crf, this.dataSet, this.targets, this.variance);
        GradientValueOptimizer opt = null;
        switch (this.optimizer) {
            case "LBFGS": {
                opt = new LBFGS(klLoss);
                break;
            }
            case "GD": {
                opt = new GradientDescent(klLoss);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown");
            }
        }
        opt.getTerminator().setMaxIteration(10);
        opt.optimize();
        if (logger.isDebugEnabled()) {
            logger.debug("finish updateModelPartial()");
        }
    }

    private double objective(int dataPointIndex) {
        double sum = 0.0;
        double[] p = this.probabilities[dataPointIndex];
        double[] s = this.scores[dataPointIndex];
        for (int j = 0; j < p.length; ++j) {
            sum += p[j] * s[j];
        }
        return -Math.log(sum);
    }

    public double objective() {
        if (logger.isDebugEnabled()) {
            logger.debug("start objective()");
        }
        double obj = IntStream.range(0, this.dataSet.getNumDataPoints()).parallel().mapToDouble(this::objective).sum();
        if (logger.isDebugEnabled()) {
            logger.debug("finish obj");
        }
        double penalty = this.penalty();
        if (logger.isDebugEnabled()) {
            logger.debug("finish penalty");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("finish objective()");
        }
        return obj + penalty;
    }

    public String objectiveDetail() {
        double obj = IntStream.range(0, this.dataSet.getNumDataPoints()).parallel().mapToDouble(this::objective).sum();
        double penalty = this.penalty();
        StringBuilder sb = new StringBuilder();
        sb.append("empirical loss = " + obj).append("\n");
        sb.append("regularization penalty = " + penalty).append("\n");
        sb.append("total objective = " + (obj + penalty)).append("\n");
        return sb.toString();
    }

    private double penalty() {
        KLLoss klLoss = new KLLoss(this.crf, this.dataSet, this.targets, this.variance);
        return klLoss.getPenalty();
    }
}

