/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.multilabel_classification.crf;

import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;

public class LinearRegWeights {
    private int numFeatures;
    private transient Vector weightVector;

    public LinearRegWeights(int numFeatures) {
        this.numFeatures = numFeatures;
        this.weightVector = new SequentialAccessSparseVector(numFeatures);
    }

    public LinearRegWeights(int numFeatures, Vector weightVector) {
        this.numFeatures = numFeatures;
        if (weightVector.size() != numFeatures) {
            throw new IllegalArgumentException("weightVector.size()!=(numFeatures)");
        }
        this.weightVector = weightVector;
    }

    public Vector getWeights() {
        return this.weightVector;
    }

    public void setWeightVector(Vector weightVector) {
        this.weightVector = weightVector;
    }

    public void setWeight(int featureIndex, double weight) {
        this.weightVector.set(featureIndex, weight);
    }

    public String toString() {
        return "Weights{, numFeatures=" + this.numFeatures + ", weightVector=" + this.weightVector + '}';
    }
}

