/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.multilabel_classification.crf;

import edu.neu.ccs.pyramid.dataset.MultiLabel;
import edu.neu.ccs.pyramid.multilabel_classification.PluginPredictor;
import edu.neu.ccs.pyramid.multilabel_classification.crf.CMLCRF;
import edu.neu.ccs.pyramid.multilabel_classification.plugin_rule.GeneralF1Predictor;
import java.util.List;
import org.apache.mahout.math.Vector;

public class InstanceF1Predictor
implements PluginPredictor<CMLCRF> {
    private CMLCRF cmlcrf;
    private int numClasses;

    public InstanceF1Predictor(CMLCRF model) {
        this.cmlcrf = model;
        this.numClasses = model.getNumClasses();
    }

    @Override
    public MultiLabel predict(Vector vector) {
        List<MultiLabel> supports = this.cmlcrf.getSupportCombinations();
        double[] probs = this.cmlcrf.predictCombinationProbs(vector);
        GeneralF1Predictor generalF1Predictor = new GeneralF1Predictor();
        return generalF1Predictor.predict(this.numClasses, supports, probs);
    }

    public GeneralF1Predictor.Analysis showPredictBySupport(Vector vector, MultiLabel truth) {
        List<MultiLabel> support = this.cmlcrf.getSupportCombinations();
        double[] probs = this.cmlcrf.predictCombinationProbs(vector);
        GeneralF1Predictor generalF1Predictor = new GeneralF1Predictor();
        MultiLabel prediction = generalF1Predictor.predict(this.cmlcrf.getNumClasses(), support, probs);
        GeneralF1Predictor.Analysis analysis = GeneralF1Predictor.showSupportPrediction(support, probs, truth, prediction, this.cmlcrf.getNumClasses());
        return analysis;
    }

    @Override
    public CMLCRF getModel() {
        return this.cmlcrf;
    }
}

