/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.multilabel_classification.cbm;

import edu.neu.ccs.pyramid.classification.Classifier;
import edu.neu.ccs.pyramid.classification.lkboost.LKBOutputCalculator;
import edu.neu.ccs.pyramid.classification.lkboost.LKBoost;
import edu.neu.ccs.pyramid.classification.lkboost.LKBoostOptimizer;
import edu.neu.ccs.pyramid.classification.logistic_regression.ElasticNetLogisticTrainer;
import edu.neu.ccs.pyramid.classification.logistic_regression.LogisticLoss;
import edu.neu.ccs.pyramid.classification.logistic_regression.LogisticRegression;
import edu.neu.ccs.pyramid.classification.logistic_regression.RidgeLogisticOptimizer;
import edu.neu.ccs.pyramid.dataset.DataSet;
import edu.neu.ccs.pyramid.dataset.MultiLabel;
import edu.neu.ccs.pyramid.dataset.MultiLabelClfDataSet;
import edu.neu.ccs.pyramid.eval.Entropy;
import edu.neu.ccs.pyramid.eval.KLDivergence;
import edu.neu.ccs.pyramid.multilabel_classification.cbm.CBM;
import edu.neu.ccs.pyramid.optimization.Terminator;
import edu.neu.ccs.pyramid.regression.RegressorFactory;
import edu.neu.ccs.pyramid.regression.regression_tree.RegTreeConfig;
import edu.neu.ccs.pyramid.regression.regression_tree.RegTreeFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.mahout.math.Vector;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.broadcast.Broadcast;

public class SparkCBMOptimizer {
    private static final Logger logger = LogManager.getLogger();
    private CBM cbm;
    private MultiLabelClfDataSet dataSet;
    private Terminator terminator;
    double[][] gammas;
    double[][] gammasT;
    private double[][][] targetsDistributions;
    private double temperature = 1.0;
    private double priorVarianceMultiClass = 1.0;
    private double priorVarianceBinary = 1.0;
    private double regularizationMultiClass = 1.0;
    private double regularizationBinary = 1.0;
    private double l1RatioBinary = 0.0;
    private double l1RatioMultiClass = 0.0;
    private boolean lineSearch = true;
    private int numLeavesBinary = 2;
    private int numLeavesMultiClass = 2;
    private double shrinkageBinary = 0.1;
    private double shrinkageMultiClass = 0.1;
    private int numIterationsBinary = 20;
    private int numIterationsMultiClass = 20;
    private JavaSparkContext sparkContext;
    private Broadcast<MultiLabelClfDataSet> dataSetBroadCast;
    private Broadcast<double[][][]> targetDisBroadCast;

    public SparkCBMOptimizer(CBM cbm, MultiLabelClfDataSet dataSet, JavaSparkContext sparkContext) {
        int n;
        this.cbm = cbm;
        this.dataSet = dataSet;
        this.terminator = new Terminator();
        this.terminator.setGoal(Terminator.Goal.MINIMIZE);
        this.gammas = new double[dataSet.getNumDataPoints()][cbm.getNumComponents()];
        this.gammasT = new double[cbm.getNumComponents()][dataSet.getNumDataPoints()];
        double average = 1.0 / (double)cbm.getNumComponents();
        for (n = 0; n < dataSet.getNumDataPoints(); ++n) {
            for (int k = 0; k < cbm.getNumComponents(); ++k) {
                this.gammas[n][k] = average;
                this.gammasT[k][n] = average;
            }
        }
        this.targetsDistributions = new double[cbm.getNumClasses()][dataSet.getNumDataPoints()][2];
        for (n = 0; n < dataSet.getNumDataPoints(); ++n) {
            for (int l = 0; l < cbm.getNumClasses(); ++l) {
                this.targetsDistributions[l][n][0] = 1.0;
            }
            MultiLabel multiLabel = dataSet.getMultiLabels()[n];
            for (int l : multiLabel.getMatchedLabels()) {
                this.targetsDistributions[l][n][0] = 0.0;
                this.targetsDistributions[l][n][1] = 1.0;
            }
        }
        this.sparkContext = sparkContext;
        this.dataSetBroadCast = sparkContext.broadcast((Object)dataSet);
        this.targetDisBroadCast = sparkContext.broadcast((Object)this.targetsDistributions);
    }

    public void setPriorVarianceMultiClass(double priorVarianceMultiClass) {
        this.priorVarianceMultiClass = priorVarianceMultiClass;
    }

    public void setPriorVarianceBinary(double priorVarianceBinary) {
        this.priorVarianceBinary = priorVarianceBinary;
    }

    public void setNumLeavesBinary(int numLeavesBinary) {
        this.numLeavesBinary = numLeavesBinary;
    }

    public void setNumLeavesMultiClass(int numLeavesMultiClass) {
        this.numLeavesMultiClass = numLeavesMultiClass;
    }

    public void setShrinkageBinary(double shrinkageBinary) {
        this.shrinkageBinary = shrinkageBinary;
    }

    public void setShrinkageMultiClass(double shrinkageMultiClass) {
        this.shrinkageMultiClass = shrinkageMultiClass;
    }

    public void setNumIterationsBinary(int numIterationsBinary) {
        this.numIterationsBinary = numIterationsBinary;
    }

    public void setNumIterationsMultiClass(int numIterationsMultiClass) {
        this.numIterationsMultiClass = numIterationsMultiClass;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public void optimize() {
        do {
            this.iterate();
        } while (!this.terminator.shouldTerminate());
    }

    public void iterate() {
        this.eStep();
        this.mStep();
        this.terminator.add(this.getObjective());
    }

    private void eStep() {
        if (logger.isDebugEnabled()) {
            logger.debug("start E step");
        }
        this.updateGamma();
        if (logger.isDebugEnabled()) {
            logger.debug("finish E step");
            logger.debug("objective = " + this.getObjective());
        }
    }

    private void updateGamma() {
        IntStream.range(0, this.dataSet.getNumDataPoints()).parallel().forEach(this::updateGamma);
    }

    private void updateGamma(int n) {
        Vector x = this.dataSet.getRow(n);
        MultiLabel y = this.dataSet.getMultiLabels()[n];
        double[] posterior = this.cbm.posteriorMembership(x, y);
        for (int k = 0; k < this.cbm.numComponents; ++k) {
            this.gammas[n][k] = posterior[k];
            this.gammasT[k][n] = posterior[k];
        }
    }

    void mStep() {
        if (logger.isDebugEnabled()) {
            logger.debug("start M step");
        }
        this.updateBinaryClassifiers();
        this.updateMultiClassClassifier();
        if (logger.isDebugEnabled()) {
            logger.debug("finish M step");
            logger.debug("objective = " + this.getObjective());
        }
    }

    private void updateBinaryClassifiers() {
        if (logger.isDebugEnabled()) {
            logger.debug("start updateBinaryClassifiers");
        }
        Classifier.ProbabilityEstimator[][] localBinaryClassifiers = this.cbm.binaryClassifiers;
        double[][] localGammasT = this.gammasT;
        Broadcast<MultiLabelClfDataSet> localDataSetBroadcast = this.dataSetBroadCast;
        Broadcast<double[][][]> localTargetsBroadcast = this.targetDisBroadCast;
        double localVariance = this.priorVarianceBinary;
        ArrayList<BinaryTask> binaryTaskList = new ArrayList<BinaryTask>();
        for (int k = 0; k < this.cbm.numComponents; ++k) {
            for (int l = 0; l < this.cbm.numLabels; ++l) {
                LogisticRegression logisticRegression = (LogisticRegression)localBinaryClassifiers[k][l];
                double[] weights = localGammasT[k];
                binaryTaskList.add(new BinaryTask(k, l, logisticRegression, weights));
            }
        }
        JavaRDD binaryTaskRDD = this.sparkContext.parallelize(binaryTaskList, binaryTaskList.size());
        List results = binaryTaskRDD.map((Function & Serializable)binaryTask -> {
            int labelIndex = binaryTask.classIndex;
            return SparkCBMOptimizer.updateBinaryLogisticRegression(binaryTask.componentIndex, binaryTask.classIndex, binaryTask.logisticRegression, (MultiLabelClfDataSet)localDataSetBroadcast.value(), binaryTask.weights, ((double[][][])localTargetsBroadcast.value())[labelIndex], localVariance);
        }).collect();
        for (BinaryTaskResult result : results) {
            this.cbm.binaryClassifiers[result.componentIndex][result.classIndex] = result.binaryClassifier;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("finish updateBinaryClassifiers");
        }
    }

    private static BinaryTaskResult updateBinaryLogisticRegression(int componentIndex, int labelIndex, LogisticRegression logisticRegression, MultiLabelClfDataSet dataSet, double[] weights, double[][] targets, double variance) {
        RidgeLogisticOptimizer ridgeLogisticOptimizer = new RidgeLogisticOptimizer(logisticRegression, (DataSet)dataSet, weights, targets, variance, false);
        ridgeLogisticOptimizer.getOptimizer().getTerminator().setMaxIteration(15);
        ridgeLogisticOptimizer.optimize();
        return new BinaryTaskResult(componentIndex, labelIndex, logisticRegression);
    }

    private void updateMultiClassClassifier() {
        String type;
        if (logger.isDebugEnabled()) {
            logger.debug("start updateMultiClassClassifier()");
        }
        switch (type = this.cbm.getMultiClassClassifierType()) {
            case "lr": {
                this.updateMultiClassLR();
                break;
            }
            case "boost": {
                this.updateMultiClassBoost();
                break;
            }
            case "elasticnet": {
                this.updateMultiClassEL();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type: " + this.cbm.getMultiClassClassifierType());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("finish updateMultiClassClassifier()");
        }
    }

    private void updateMultiClassEL() {
        ElasticNetLogisticTrainer elasticNetLogisticTrainer = new ElasticNetLogisticTrainer.Builder((LogisticRegression)this.cbm.multiClassClassifier, (DataSet)this.dataSet, this.cbm.multiClassClassifier.getNumClasses(), this.gammas).setRegularization(this.regularizationMultiClass).setL1Ratio(this.l1RatioMultiClass).setLineSearch(this.lineSearch).build();
        elasticNetLogisticTrainer.getTerminator().setMaxIteration(15);
        elasticNetLogisticTrainer.optimize();
    }

    private void updateMultiClassLR() {
        RidgeLogisticOptimizer ridgeLogisticOptimizer = new RidgeLogisticOptimizer((LogisticRegression)this.cbm.multiClassClassifier, (DataSet)this.dataSet, this.gammas, this.priorVarianceMultiClass, true);
        ridgeLogisticOptimizer.getOptimizer().getTerminator().setMaxIteration(15);
        ridgeLogisticOptimizer.optimize();
    }

    private void updateMultiClassBoost() {
        int numComponents = this.cbm.numComponents;
        int numIterations = this.numIterationsMultiClass;
        double shrinkage = this.shrinkageMultiClass;
        LKBoost boost = (LKBoost)this.cbm.multiClassClassifier;
        RegTreeConfig regTreeConfig = new RegTreeConfig().setMaxNumLeaves(this.numLeavesMultiClass);
        RegTreeFactory regTreeFactory = new RegTreeFactory(regTreeConfig);
        regTreeFactory.setLeafOutputCalculator(new LKBOutputCalculator(numComponents));
        LKBoostOptimizer optimizer = new LKBoostOptimizer(boost, (DataSet)this.dataSet, (RegressorFactory)regTreeFactory, this.gammas);
        optimizer.setShrinkage(shrinkage);
        optimizer.initialize();
        optimizer.iterate(numIterations);
    }

    public double getObjective() {
        return this.multiClassClassifierObj() + this.binaryObj() + (1.0 - this.temperature) * this.getEntropy();
    }

    private double getEntropy() {
        return IntStream.range(0, this.dataSet.getNumDataPoints()).parallel().mapToDouble(this::getEntropy).sum();
    }

    private double getEntropy(int i) {
        return Entropy.entropy(this.gammas[i]);
    }

    private double binaryObj() {
        return IntStream.range(0, this.cbm.numComponents).mapToDouble(this::binaryObj).sum();
    }

    private double binaryObj(int clusterIndex) {
        return IntStream.range(0, this.cbm.numLabels).parallel().mapToDouble(l -> this.binaryObj(clusterIndex, l)).sum();
    }

    private double binaryObj(int clusterIndex, int classIndex) {
        String type;
        switch (type = this.cbm.getBinaryClassifierType()) {
            case "lr": {
                return this.binaryLRObj(clusterIndex, classIndex);
            }
            case "boost": {
                return this.binaryBoostObj(clusterIndex, classIndex);
            }
            case "elasticnet": {
                return this.binaryLRELObj(clusterIndex, classIndex);
            }
        }
        throw new IllegalArgumentException("unknown type: " + type);
    }

    private double binaryLRELObj(int clusterIndex, int classIndex) {
        LogisticLoss logisticLoss = new LogisticLoss((LogisticRegression)this.cbm.binaryClassifiers[clusterIndex][classIndex], this.dataSet, this.gammasT[clusterIndex], this.targetsDistributions[classIndex], this.regularizationBinary, this.l1RatioBinary, false);
        return logisticLoss.getValueEL();
    }

    private double binaryLRObj(int clusterIndex, int classIndex) {
        LogisticLoss logisticLoss = new LogisticLoss((LogisticRegression)this.cbm.binaryClassifiers[clusterIndex][classIndex], (DataSet)this.dataSet, this.gammasT[clusterIndex], this.targetsDistributions[classIndex], this.priorVarianceBinary, false);
        return logisticLoss.getValue();
    }

    private double binaryBoostObj(int clusterIndex, int classIndex) {
        Classifier.ProbabilityEstimator estimator = this.cbm.binaryClassifiers[clusterIndex][classIndex];
        double[][] targets = this.targetsDistributions[classIndex];
        double[] weights = this.gammasT[clusterIndex];
        return KLDivergence.kl(estimator, this.dataSet, targets, weights);
    }

    private double multiClassClassifierObj() {
        String type;
        switch (type = this.cbm.getMultiClassClassifierType()) {
            case "lr": {
                return this.multiClassLRObj();
            }
            case "boost": {
                return this.multiClassBoostObj();
            }
            case "elasticnet": {
                return this.multiClassLRELObj();
            }
        }
        throw new IllegalArgumentException("unknown type: " + type);
    }

    private double multiClassLRELObj() {
        LogisticLoss logisticLoss = new LogisticLoss((LogisticRegression)this.cbm.multiClassClassifier, (DataSet)this.dataSet, this.gammas, this.regularizationMultiClass, this.l1RatioMultiClass, true);
        return logisticLoss.getValueEL();
    }

    private double multiClassBoostObj() {
        Classifier.ProbabilityEstimator estimator = this.cbm.multiClassClassifier;
        double[][] targets = this.gammas;
        return KLDivergence.kl(estimator, this.dataSet, targets);
    }

    private double multiClassLRObj() {
        LogisticLoss logisticLoss = new LogisticLoss((LogisticRegression)this.cbm.multiClassClassifier, this.dataSet, this.gammas, this.priorVarianceMultiClass, true);
        return logisticLoss.getValue();
    }

    public Terminator getTerminator() {
        return this.terminator;
    }

    public double[][] getGammas() {
        return this.gammas;
    }

    public double[][] getPIs() {
        double[][] PIs = new double[this.dataSet.getNumDataPoints()][this.cbm.getNumComponents()];
        for (int n = 0; n < PIs.length; ++n) {
            double[] logProbs = this.cbm.multiClassClassifier.predictLogClassProbs(this.dataSet.getRow(n));
            for (int k = 0; k < PIs[n].length; ++k) {
                PIs[n][k] = Math.exp(logProbs[k]);
            }
        }
        return PIs;
    }

    public double getRegularizationMultiClass() {
        return this.regularizationMultiClass;
    }

    public void setRegularizationMultiClass(double regularizationMultiClass) {
        this.regularizationMultiClass = regularizationMultiClass;
    }

    public double getRegularizationBinary() {
        return this.regularizationBinary;
    }

    public void setRegularizationBinary(double regularizationBinary) {
        this.regularizationBinary = regularizationBinary;
    }

    public boolean isLineSearch() {
        return this.lineSearch;
    }

    public void setLineSearch(boolean lineSearch) {
        this.lineSearch = lineSearch;
    }

    public double getL1RatioBinary() {
        return this.l1RatioBinary;
    }

    public void setL1RatioBinary(double l1RatioBinary) {
        this.l1RatioBinary = l1RatioBinary;
    }

    public double getL1RatioMultiClass() {
        return this.l1RatioMultiClass;
    }

    public void setL1RatioMultiClass(double l1RatioMultiClass) {
        this.l1RatioMultiClass = l1RatioMultiClass;
    }

    private static class BinaryTaskResult
    implements Serializable {
        int componentIndex;
        int classIndex;
        Classifier.ProbabilityEstimator binaryClassifier;

        public BinaryTaskResult(int componentIndex, int classIndex, Classifier.ProbabilityEstimator binaryClassifier) {
            this.componentIndex = componentIndex;
            this.classIndex = classIndex;
            this.binaryClassifier = binaryClassifier;
        }
    }

    private static class BinaryTask
    implements Serializable {
        int componentIndex;
        int classIndex;
        LogisticRegression logisticRegression;
        double[] weights;

        public BinaryTask(int componentIndex, int classIndex, LogisticRegression logisticRegression, double[] weights) {
            this.componentIndex = componentIndex;
            this.classIndex = classIndex;
            this.logisticRegression = logisticRegression;
            this.weights = weights;
        }
    }
}

