/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.multilabel_classification.cbm;

import edu.neu.ccs.pyramid.classification.Classifier;
import edu.neu.ccs.pyramid.classification.lkboost.LKBOutputCalculator;
import edu.neu.ccs.pyramid.classification.lkboost.LKBoost;
import edu.neu.ccs.pyramid.classification.lkboost.LKBoostOptimizer;
import edu.neu.ccs.pyramid.classification.logistic_regression.ElasticNetLogisticTrainer;
import edu.neu.ccs.pyramid.classification.logistic_regression.LogisticLoss;
import edu.neu.ccs.pyramid.classification.logistic_regression.LogisticRegression;
import edu.neu.ccs.pyramid.classification.logistic_regression.RidgeLogisticOptimizer;
import edu.neu.ccs.pyramid.dataset.DataSet;
import edu.neu.ccs.pyramid.dataset.MultiLabel;
import edu.neu.ccs.pyramid.dataset.MultiLabelClfDataSet;
import edu.neu.ccs.pyramid.eval.Entropy;
import edu.neu.ccs.pyramid.eval.KLDivergence;
import edu.neu.ccs.pyramid.multilabel_classification.cbm.CBM;
import edu.neu.ccs.pyramid.optimization.Terminator;
import edu.neu.ccs.pyramid.regression.RegressorFactory;
import edu.neu.ccs.pyramid.regression.regression_tree.RegTreeConfig;
import edu.neu.ccs.pyramid.regression.regression_tree.RegTreeFactory;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.mahout.math.Vector;

public class CBMOptimizer {
    private static final Logger logger = LogManager.getLogger();
    private CBM cbm;
    private MultiLabelClfDataSet dataSet;
    private Terminator terminator;
    double[][] gammas;
    double[][] gammasT;
    private double[][][] targetsDistributions;
    private boolean isParallel = true;
    private double temperature = 1.0;
    private boolean hardAssignment = false;
    private double priorVarianceMultiClass = 1.0;
    private double priorVarianceBinary = 1.0;
    private double regularizationMultiClass = 1.0;
    private double regularizationBinary = 1.0;
    private double l1RatioBinary = 0.0;
    private double l1RatioMultiClass = 0.0;
    private boolean lineSearch = true;
    private int numLeavesBinary = 2;
    private int numLeavesMultiClass = 2;
    private double shrinkageBinary = 0.1;
    private double shrinkageMultiClass = 0.1;
    private int numIterationsBinary = 20;
    private int numIterationsMultiClass = 20;
    private double noiseGammaSet = 0.0;
    private double[] noiseSetWeights;
    private double[] jointProbs;
    private double noiseGammaLabel = 0.0;
    private double[][] noiseLabelWeights;
    private double[][] marginals;
    private int parameterUpdatesPerIter = 10;

    public CBMOptimizer(CBM cbm, MultiLabelClfDataSet dataSet) {
        int n;
        this.cbm = cbm;
        this.dataSet = dataSet;
        this.terminator = new Terminator();
        this.terminator.setGoal(Terminator.Goal.MINIMIZE);
        this.gammas = new double[dataSet.getNumDataPoints()][cbm.getNumComponents()];
        this.gammasT = new double[cbm.getNumComponents()][dataSet.getNumDataPoints()];
        double average = 1.0 / (double)cbm.getNumComponents();
        for (n = 0; n < dataSet.getNumDataPoints(); ++n) {
            for (int k = 0; k < cbm.getNumComponents(); ++k) {
                this.gammas[n][k] = average;
                this.gammasT[k][n] = average;
            }
        }
        this.targetsDistributions = new double[cbm.getNumClasses()][dataSet.getNumDataPoints()][2];
        for (n = 0; n < dataSet.getNumDataPoints(); ++n) {
            for (int l = 0; l < cbm.getNumClasses(); ++l) {
                this.targetsDistributions[l][n][0] = 1.0;
            }
            MultiLabel multiLabel = dataSet.getMultiLabels()[n];
            for (int l : multiLabel.getMatchedLabels()) {
                this.targetsDistributions[l][n][0] = 0.0;
                this.targetsDistributions[l][n][1] = 1.0;
            }
        }
        this.jointProbs = new double[dataSet.getNumDataPoints()];
        this.noiseSetWeights = new double[dataSet.getNumDataPoints()];
        this.marginals = new double[dataSet.getNumDataPoints()][dataSet.getNumClasses()];
        this.noiseLabelWeights = new double[dataSet.getNumDataPoints()][dataSet.getNumClasses()];
    }

    private void updateJointProbs() {
        IntStream.range(0, this.dataSet.getNumDataPoints()).parallel().forEach(i -> {
            this.jointProbs[i] = this.cbm.predictAssignmentProb(this.dataSet.getRow(i), this.dataSet.getMultiLabels()[i]);
        });
    }

    private void updateSetWeights() {
        int i;
        double total = 0.0;
        double n = this.dataSet.getNumDataPoints();
        for (i = 0; i < this.jointProbs.length; ++i) {
            total += Math.pow(this.jointProbs[i], this.noiseGammaSet);
        }
        for (i = 0; i < this.jointProbs.length; ++i) {
            this.noiseSetWeights[i] = n * Math.pow(this.jointProbs[i], this.noiseGammaSet) / total;
        }
    }

    private void updateMarginals() {
        IntStream.range(0, this.dataSet.getNumDataPoints()).parallel().forEach(i -> {
            double[] predictedMarginals = this.cbm.predictClassProbs(this.dataSet.getRow(i));
            for (int l = 0; l < this.dataSet.getNumClasses(); ++l) {
                this.marginals[i][l] = this.dataSet.getMultiLabels()[i].matchClass(l) ? predictedMarginals[l] : 1.0 - predictedMarginals[l];
            }
        });
    }

    private void updateLabelWeights() {
        int l;
        double total = 0.0;
        double n = this.dataSet.getNumDataPoints();
        double numLabels = this.dataSet.getNumClasses();
        int i = 0;
        while ((double)i < n) {
            l = 0;
            while ((double)l < numLabels) {
                total += Math.pow(this.marginals[i][l], this.noiseGammaLabel);
                ++l;
            }
            ++i;
        }
        i = 0;
        while ((double)i < n) {
            l = 0;
            while ((double)l < numLabels) {
                this.noiseLabelWeights[i][l] = n * numLabels * Math.pow(this.marginals[i][l], this.noiseGammaLabel) / total;
                ++l;
            }
            ++i;
        }
    }

    public void setNoiseGammaSet(double noiseGammaSet) {
        this.noiseGammaSet = noiseGammaSet;
    }

    public void setNoiseGammaLabel(double noiseGammaLabel) {
        this.noiseGammaLabel = noiseGammaLabel;
    }

    public void setPriorVarianceMultiClass(double priorVarianceMultiClass) {
        this.priorVarianceMultiClass = priorVarianceMultiClass;
    }

    public void setPriorVarianceBinary(double priorVarianceBinary) {
        this.priorVarianceBinary = priorVarianceBinary;
    }

    public void setNumLeavesBinary(int numLeavesBinary) {
        this.numLeavesBinary = numLeavesBinary;
    }

    public void setNumLeavesMultiClass(int numLeavesMultiClass) {
        this.numLeavesMultiClass = numLeavesMultiClass;
    }

    public void setShrinkageBinary(double shrinkageBinary) {
        this.shrinkageBinary = shrinkageBinary;
    }

    public void setShrinkageMultiClass(double shrinkageMultiClass) {
        this.shrinkageMultiClass = shrinkageMultiClass;
    }

    public void setNumIterationsBinary(int numIterationsBinary) {
        this.numIterationsBinary = numIterationsBinary;
    }

    public void setNumIterationsMultiClass(int numIterationsMultiClass) {
        this.numIterationsMultiClass = numIterationsMultiClass;
    }

    public void setParameterUpdatesPerIter(int parameterUpdatesPerIter) {
        this.parameterUpdatesPerIter = parameterUpdatesPerIter;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public double[][] getNoiseLabelWeights() {
        return this.noiseLabelWeights;
    }

    public double[] getNoiseSetWeights() {
        return this.noiseSetWeights;
    }

    public void optimize() {
        do {
            this.iterate();
        } while (!this.terminator.shouldTerminate());
    }

    public void iterate() {
        this.updateJointProbs();
        this.updateSetWeights();
        this.updateMarginals();
        this.updateLabelWeights();
        this.eStep();
        this.mStep();
        this.terminator.add(this.getObjective());
    }

    private void eStep() {
        if (logger.isDebugEnabled()) {
            logger.debug("start E step");
        }
        this.updateGamma();
        if (logger.isDebugEnabled()) {
            logger.debug("finish E step");
            logger.debug("objective = " + this.getObjective());
        }
    }

    private void updateGamma() {
        IntStream.range(0, this.dataSet.getNumDataPoints()).parallel().forEach(this::updateGamma);
    }

    private void updateGamma(int n) {
        Vector x = this.dataSet.getRow(n);
        MultiLabel y = this.dataSet.getMultiLabels()[n];
        double[] posterior = this.cbm.posteriorMembership(x, y, this.noiseLabelWeights[n]);
        for (int k = 0; k < this.cbm.numComponents; ++k) {
            this.gammas[n][k] = posterior[k];
            this.gammasT[k][n] = posterior[k];
        }
    }

    void mStep() {
        if (logger.isDebugEnabled()) {
            logger.debug("start M step");
        }
        this.updateBinaryClassifiers();
        this.updateMultiClassClassifier();
        if (logger.isDebugEnabled()) {
            logger.debug("finish M step");
            logger.debug("objective = " + this.getObjective());
        }
    }

    private void updateBinaryClassifiers() {
        if (logger.isDebugEnabled()) {
            logger.debug("start updateBinaryClassifiers");
        }
        IntStream.range(0, this.cbm.numComponents).forEach(this::updateBinaryClassifiers);
        if (logger.isDebugEnabled()) {
            logger.debug("finish updateBinaryClassifiers");
        }
    }

    private void updateBinaryClassifiers(int component) {
        String type;
        switch (type = this.cbm.getBinaryClassifierType()) {
            case "lr": {
                IntStream.range(0, this.cbm.numLabels).parallel().forEach(l -> this.updateBinaryLogisticRegression(component, l));
                break;
            }
            case "boost": {
                IntStream.range(0, this.cbm.numLabels).forEach(l -> this.updateBinaryBoosting(component, l));
                break;
            }
            case "elasticnet": {
                IntStream.range(0, this.cbm.numLabels).parallel().forEach(l -> this.updateBinaryLogisticRegressionEL(component, l));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type: " + this.cbm.getBinaryClassifierType());
            }
        }
    }

    private void updateBinaryBoosting(int componentIndex, int labelIndex) {
        int numIterations = this.numIterationsBinary;
        double shrinkage = this.shrinkageBinary;
        LKBoost boost = (LKBoost)this.cbm.binaryClassifiers[componentIndex][labelIndex];
        RegTreeConfig regTreeConfig = new RegTreeConfig().setMaxNumLeaves(this.numLeavesBinary);
        RegTreeFactory regTreeFactory = new RegTreeFactory(regTreeConfig);
        regTreeFactory.setLeafOutputCalculator(new LKBOutputCalculator(2));
        LKBoostOptimizer optimizer = new LKBoostOptimizer(boost, this.dataSet, regTreeFactory, this.gammasT[componentIndex], this.targetsDistributions[labelIndex]);
        optimizer.setShrinkage(shrinkage);
        optimizer.initialize();
        optimizer.iterate(numIterations);
    }

    private void updateBinaryLogisticRegression(int componentIndex, int labelIndex) {
        double[] instanceWeights = new double[this.dataSet.getNumDataPoints()];
        for (int i = 0; i < this.dataSet.getNumDataPoints(); ++i) {
            instanceWeights[i] = this.gammasT[componentIndex][i] * this.noiseSetWeights[i] * this.noiseLabelWeights[i][labelIndex];
        }
        RidgeLogisticOptimizer ridgeLogisticOptimizer = new RidgeLogisticOptimizer((LogisticRegression)this.cbm.binaryClassifiers[componentIndex][labelIndex], (DataSet)this.dataSet, instanceWeights, this.targetsDistributions[labelIndex], this.priorVarianceBinary, false);
        ridgeLogisticOptimizer.getOptimizer().getTerminator().setMaxIteration(this.parameterUpdatesPerIter);
        ridgeLogisticOptimizer.optimize();
    }

    private void updateBinaryLogisticRegressionEL(int componentIndex, int labelIndex) {
        ElasticNetLogisticTrainer elasticNetLogisticTrainer = new ElasticNetLogisticTrainer.Builder((LogisticRegression)this.cbm.binaryClassifiers[componentIndex][labelIndex], this.dataSet, 2, this.targetsDistributions[labelIndex], this.gammasT[componentIndex]).setRegularization(this.regularizationBinary).setL1Ratio(this.l1RatioBinary).setLineSearch(this.lineSearch).build();
        elasticNetLogisticTrainer.setActiveSet(false);
        elasticNetLogisticTrainer.getTerminator().setMaxIteration(2);
        elasticNetLogisticTrainer.optimize();
    }

    private void updateMultiClassClassifier() {
        String type;
        if (logger.isDebugEnabled()) {
            logger.debug("start updateMultiClassClassifier()");
        }
        switch (type = this.cbm.getMultiClassClassifierType()) {
            case "lr": {
                this.updateMultiClassLR();
                break;
            }
            case "boost": {
                this.updateMultiClassBoost();
                break;
            }
            case "elasticnet": {
                this.updateMultiClassEL();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type: " + this.cbm.getMultiClassClassifierType());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("finish updateMultiClassClassifier()");
        }
    }

    private void updateMultiClassEL() {
        ElasticNetLogisticTrainer elasticNetLogisticTrainer = new ElasticNetLogisticTrainer.Builder((LogisticRegression)this.cbm.multiClassClassifier, (DataSet)this.dataSet, this.cbm.multiClassClassifier.getNumClasses(), this.gammas).setRegularization(this.regularizationMultiClass).setL1Ratio(this.l1RatioMultiClass).setLineSearch(this.lineSearch).build();
        elasticNetLogisticTrainer.setActiveSet(false);
        elasticNetLogisticTrainer.getTerminator().setMaxIteration(2);
        elasticNetLogisticTrainer.optimize();
    }

    private void updateMultiClassLR() {
        RidgeLogisticOptimizer ridgeLogisticOptimizer = new RidgeLogisticOptimizer((LogisticRegression)this.cbm.multiClassClassifier, (DataSet)this.dataSet, this.noiseSetWeights, this.gammas, this.priorVarianceMultiClass, true);
        ridgeLogisticOptimizer.getOptimizer().getTerminator().setMaxIteration(this.parameterUpdatesPerIter);
        ridgeLogisticOptimizer.optimize();
    }

    private void updateMultiClassBoost() {
        int numComponents = this.cbm.numComponents;
        int numIterations = this.numIterationsMultiClass;
        double shrinkage = this.shrinkageMultiClass;
        LKBoost boost = (LKBoost)this.cbm.multiClassClassifier;
        RegTreeConfig regTreeConfig = new RegTreeConfig().setMaxNumLeaves(this.numLeavesMultiClass);
        RegTreeFactory regTreeFactory = new RegTreeFactory(regTreeConfig);
        regTreeFactory.setLeafOutputCalculator(new LKBOutputCalculator(numComponents));
        LKBoostOptimizer optimizer = new LKBoostOptimizer(boost, (DataSet)this.dataSet, (RegressorFactory)regTreeFactory, this.gammas);
        optimizer.setShrinkage(shrinkage);
        optimizer.initialize();
        optimizer.iterate(numIterations);
    }

    public double getObjective() {
        return this.multiClassClassifierObj() + this.binaryObj() + (1.0 - this.temperature) * this.getEntropy();
    }

    private double getEntropy() {
        return IntStream.range(0, this.dataSet.getNumDataPoints()).parallel().mapToDouble(this::getEntropy).sum();
    }

    private double getEntropy(int i) {
        return Entropy.entropy(this.gammas[i]);
    }

    private double binaryObj() {
        return IntStream.range(0, this.cbm.numComponents).mapToDouble(this::binaryObj).sum();
    }

    private double binaryObj(int clusterIndex) {
        return IntStream.range(0, this.cbm.numLabels).parallel().mapToDouble(l -> this.binaryObj(clusterIndex, l)).sum();
    }

    private double binaryObj(int clusterIndex, int classIndex) {
        String type;
        switch (type = this.cbm.getBinaryClassifierType()) {
            case "lr": {
                return this.binaryLRObj(clusterIndex, classIndex);
            }
            case "boost": {
                return this.binaryBoostObj(clusterIndex, classIndex);
            }
            case "elasticnet": {
                return this.binaryLRELObj(clusterIndex, classIndex);
            }
        }
        throw new IllegalArgumentException("unknown type: " + type);
    }

    private double binaryLRELObj(int clusterIndex, int classIndex) {
        LogisticLoss logisticLoss = new LogisticLoss((LogisticRegression)this.cbm.binaryClassifiers[clusterIndex][classIndex], this.dataSet, this.gammasT[clusterIndex], this.targetsDistributions[classIndex], this.regularizationBinary, this.l1RatioBinary, false);
        return logisticLoss.getValueEL();
    }

    private double binaryLRObj(int clusterIndex, int classIndex) {
        LogisticLoss logisticLoss = new LogisticLoss((LogisticRegression)this.cbm.binaryClassifiers[clusterIndex][classIndex], (DataSet)this.dataSet, this.gammasT[clusterIndex], this.targetsDistributions[classIndex], this.priorVarianceBinary, false);
        return logisticLoss.getValue();
    }

    private double binaryBoostObj(int clusterIndex, int classIndex) {
        Classifier.ProbabilityEstimator estimator = this.cbm.binaryClassifiers[clusterIndex][classIndex];
        double[][] targets = this.targetsDistributions[classIndex];
        double[] weights = this.gammasT[clusterIndex];
        return KLDivergence.kl(estimator, this.dataSet, targets, weights);
    }

    private double multiClassClassifierObj() {
        String type;
        switch (type = this.cbm.getMultiClassClassifierType()) {
            case "lr": {
                return this.multiClassLRObj();
            }
            case "boost": {
                return this.multiClassBoostObj();
            }
            case "elasticnet": {
                return this.multiClassLRELObj();
            }
        }
        throw new IllegalArgumentException("unknown type: " + type);
    }

    private double multiClassLRELObj() {
        LogisticLoss logisticLoss = new LogisticLoss((LogisticRegression)this.cbm.multiClassClassifier, (DataSet)this.dataSet, this.gammas, this.regularizationMultiClass, this.l1RatioMultiClass, true);
        return logisticLoss.getValueEL();
    }

    private double multiClassBoostObj() {
        Classifier.ProbabilityEstimator estimator = this.cbm.multiClassClassifier;
        double[][] targets = this.gammas;
        return KLDivergence.kl(estimator, this.dataSet, targets);
    }

    private double multiClassLRObj() {
        LogisticLoss logisticLoss = new LogisticLoss((LogisticRegression)this.cbm.multiClassClassifier, this.dataSet, this.gammas, this.priorVarianceMultiClass, true);
        return logisticLoss.getValue();
    }

    public Terminator getTerminator() {
        return this.terminator;
    }

    public double[][] getGammas() {
        return this.gammas;
    }

    public double[][] getPIs() {
        double[][] PIs = new double[this.dataSet.getNumDataPoints()][this.cbm.getNumComponents()];
        for (int n = 0; n < PIs.length; ++n) {
            double[] logProbs = this.cbm.multiClassClassifier.predictLogClassProbs(this.dataSet.getRow(n));
            for (int k = 0; k < PIs[n].length; ++k) {
                PIs[n][k] = Math.exp(logProbs[k]);
            }
        }
        return PIs;
    }

    public double getRegularizationMultiClass() {
        return this.regularizationMultiClass;
    }

    public void setRegularizationMultiClass(double regularizationMultiClass) {
        this.regularizationMultiClass = regularizationMultiClass;
    }

    public double getRegularizationBinary() {
        return this.regularizationBinary;
    }

    public void setRegularizationBinary(double regularizationBinary) {
        this.regularizationBinary = regularizationBinary;
    }

    public boolean isLineSearch() {
        return this.lineSearch;
    }

    public void setLineSearch(boolean lineSearch) {
        this.lineSearch = lineSearch;
    }

    public double getL1RatioBinary() {
        return this.l1RatioBinary;
    }

    public void setL1RatioBinary(double l1RatioBinary) {
        this.l1RatioBinary = l1RatioBinary;
    }

    public double getL1RatioMultiClass() {
        return this.l1RatioMultiClass;
    }

    public void setL1RatioMultiClass(double l1RatioMultiClass) {
        this.l1RatioMultiClass = l1RatioMultiClass;
    }
}

